/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsBase;
import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.SmsStatusPullCallbackResult;
import com.github.qcloudsms.SmsStatusPullReplyResult;
import com.github.qcloudsms.httpclient.DefaultHTTPClient;
import com.github.qcloudsms.httpclient.HTTPClient;
import com.github.qcloudsms.httpclient.HTTPException;
import com.github.qcloudsms.httpclient.HTTPMethod;
import com.github.qcloudsms.httpclient.HTTPRequest;
import com.github.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class SmsMobileStatusPuller
extends SmsBase {
    private String url = "https://yun.tim.qq.com/v5/tlssmssvr/pullstatus4mobile";

    public SmsMobileStatusPuller(int appid, String appkey) {
        super(appid, appkey, new DefaultHTTPClient());
    }

    public SmsMobileStatusPuller(int appid, String appkey, HTTPClient httpclient) {
        super(appid, appkey, httpclient);
    }

    private HTTPResponse pull(int type, String nationCode, String mobile, long beginTime, long endTime, int max) throws IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject();
        body.put("sig", (Object)SmsSenderUtil.calculateSignature(this.appkey, random, now)).put("type", type).put("time", now).put("max", max).put("begin_time", beginTime).put("end_time", endTime).put("nationcode", (Object)nationCode).put("mobile", (Object)mobile);
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(600000).setBody(body.toString());
        try {
            return this.httpclient.fetch(req);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    public SmsStatusPullCallbackResult pullCallback(String nationCode, String mobile, long beginTime, long endTime, int max) throws HTTPException, JSONException, IOException {
        HTTPResponse res = this.pull(0, nationCode, mobile, beginTime, endTime, max);
        this.handleError(res);
        return new SmsStatusPullCallbackResult().parseFromHTTPResponse(res);
    }

    public SmsStatusPullReplyResult pullReply(String nationCode, String mobile, long beginTime, long endTime, int max) throws HTTPException, JSONException, IOException {
        HTTPResponse res = this.pull(1, nationCode, mobile, beginTime, endTime, max);
        this.handleError(res);
        return new SmsStatusPullReplyResult().parseFromHTTPResponse(res);
    }
}

