/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers.ast;

import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import lombok.ast.Expression;
import lombok.ast.IFieldEditor;
import lombok.ast.Node;
import lombok.javac.handlers.ast.JavacASTMaker;
import lombok.javac.handlers.ast.JavacField;

public final class JavacFieldEditor
implements IFieldEditor<JCTree> {
    private final JavacField field;
    private final JavacASTMaker builder;

    JavacFieldEditor(JavacField field, JCTree source) {
        this.field = field;
        this.builder = new JavacASTMaker(field.node(), source);
    }

    JCTree.JCVariableDecl get() {
        return this.field.get();
    }

    @Override
    public <T extends JCTree> T build(Node<?> node) {
        return this.builder.build(node);
    }

    @Override
    public <T extends JCTree> T build(Node<?> node, Class<T> extectedType) {
        return this.builder.build(node, extectedType);
    }

    @Override
    public <T extends JCTree> List<T> build(List<? extends Node<?>> nodes) {
        return this.builder.build(nodes);
    }

    @Override
    public <T extends JCTree> List<T> build(List<? extends Node<?>> nodes, Class<T> extectedType) {
        return this.builder.build(nodes, extectedType);
    }

    @Override
    public void replaceInitialization(Expression<?> initialization) {
        this.get().init = initialization == null ? null : (JCTree.JCExpression)this.build(initialization, JCTree.JCExpression.class);
    }

    @Override
    public void makePrivate() {
        this.makePackagePrivate();
        this.get().mods.flags |= 2L;
    }

    @Override
    public void makePackagePrivate() {
        this.get().mods.flags &= 0xFFFFFFFFFFFFFFF8L;
    }

    @Override
    public void makeProtected() {
        this.makePackagePrivate();
        this.get().mods.flags |= 4L;
    }

    @Override
    public void makePublic() {
        this.makePackagePrivate();
        this.get().mods.flags |= 1L;
    }

    @Override
    public void makeNonFinal() {
        this.get().mods.flags &= 0xFFFFFFFFFFFFFFEFL;
    }

    public String toString() {
        return this.get().toString();
    }
}

