/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import lombok.Cleanup;
import lombok.core.AnnotationValues;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.ResolutionBased;
import lombok.javac.handlers.JavacHandlerUtil;

@ResolutionBased
public class HandleCleanup
extends JavacAnnotationHandler<Cleanup> {
    @Override
    public void handle(AnnotationValues<Cleanup> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JCTree.JCBlock finalizer;
        List<JCTree.JCStatement> statements;
        if (JavacHandlerUtil.inNetbeansEditor(annotationNode)) {
            return;
        }
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Cleanup.class);
        Cleanup cleanup = annotation.getInstance();
        String cleanupName = cleanup.value();
        boolean quietly = cleanup.quietly();
        if (cleanupName.length() == 0) {
            annotationNode.addError("cleanupName cannot be the empty string.");
            return;
        }
        boolean isLocalDeclaration = false;
        switch (((JavacNode)annotationNode.up()).getKind()) {
            case ARGUMENT: {
                isLocalDeclaration = false;
                break;
            }
            case LOCAL: {
                isLocalDeclaration = true;
                break;
            }
            default: {
                annotationNode.addError("@Cleanup is legal only on local variable declarations.");
                return;
            }
        }
        JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)((JavacNode)annotationNode.up()).get();
        if (isLocalDeclaration && decl.init == null) {
            annotationNode.addError("@Cleanup variable declarations need to be initialized.");
            return;
        }
        JavacNode ancestor = (JavacNode)((JavacNode)annotationNode.up()).directUp();
        JCTree blockNode = (JCTree)ancestor.get();
        if (blockNode instanceof JCTree.JCBlock) {
            statements = ((JCTree.JCBlock)blockNode).stats;
        } else if (blockNode instanceof JCTree.JCCase) {
            statements = ((JCTree.JCCase)blockNode).stats;
        } else if (blockNode instanceof JCTree.JCMethodDecl) {
            statements = ((JCTree.JCMethodDecl)blockNode).body.stats;
        } else {
            annotationNode.addError("@Cleanup is legal only on a local variable declaration inside a block.");
            return;
        }
        boolean seenDeclaration = false;
        ListBuffer newStatements = ListBuffer.lb();
        ListBuffer tryBlock = ListBuffer.lb();
        for (JCTree.JCStatement statement : statements) {
            if (isLocalDeclaration && !seenDeclaration) {
                if (statement == decl) {
                    seenDeclaration = true;
                }
                newStatements.append(statement);
                continue;
            }
            tryBlock.append(statement);
        }
        if (isLocalDeclaration && !seenDeclaration) {
            annotationNode.addError("LOMBOK BUG: Can't find this local variable declaration inside its parent.");
            return;
        }
        this.doAssignmentCheck(annotationNode, tryBlock.toList(), decl.name);
        TreeMaker maker = annotationNode.getTreeMaker();
        if ("close".equals(cleanupName) && !annotation.isExplicit("value")) {
            JCTree.JCFieldAccess cleanupMethod = maker.Select((JCTree.JCExpression)maker.TypeCast(JavacHandlerUtil.chainDotsString(annotationNode, "java.io.Closeable"), (JCTree.JCExpression)maker.Ident(decl.name)), annotationNode.toName(cleanupName));
            List<JCTree.JCStatement> cleanupCall = List.of(maker.Exec(maker.Apply(List.<JCTree.JCExpression>nil(), cleanupMethod, List.<JCTree.JCExpression>nil())));
            if (quietly) {
                cleanupCall = this.cleanupQuietly(maker, annotationNode, cleanupCall);
            }
            JCTree.JCInstanceOf isClosable = maker.TypeTest(maker.Ident(decl.name), JavacHandlerUtil.chainDotsString(annotationNode, "java.io.Closeable"));
            JCTree.JCIf ifIsClosableCleanup = maker.If(isClosable, maker.Block(0L, cleanupCall), null);
            finalizer = JavacHandlerUtil.recursiveSetGeneratedBy(maker.Block(0L, List.of(ifIsClosableCleanup)), ast);
        } else {
            JCTree.JCFieldAccess cleanupMethod = maker.Select((JCTree.JCExpression)maker.Ident(decl.name), annotationNode.toName(cleanupName));
            List<JCTree.JCStatement> cleanupCall = List.of(maker.Exec(maker.Apply(List.<JCTree.JCExpression>nil(), cleanupMethod, List.<JCTree.JCExpression>nil())));
            JCTree.JCMethodInvocation preventNullAnalysis = this.preventNullAnalysis(maker, annotationNode, maker.Ident(decl.name));
            JCTree.JCBinary isNull = maker.Binary(Javac.getCtcInt(JCTree.class, "NE"), preventNullAnalysis, maker.Literal(Javac.getCtcInt(TypeTags.class, "BOT"), null));
            if (quietly) {
                cleanupCall = this.cleanupQuietly(maker, annotationNode, cleanupCall);
            }
            JCTree.JCIf ifNotNullCleanup = maker.If(isNull, maker.Block(0L, cleanupCall), null);
            finalizer = JavacHandlerUtil.recursiveSetGeneratedBy(maker.Block(0L, List.of(ifNotNullCleanup)), ast);
        }
        newStatements.append(JavacHandlerUtil.setGeneratedBy(maker.Try(JavacHandlerUtil.setGeneratedBy(maker.Block(0L, tryBlock.toList()), ast), List.<JCTree.JCCatch>nil(), finalizer), ast));
        if (blockNode instanceof JCTree.JCBlock) {
            ((JCTree.JCBlock)blockNode).stats = newStatements.toList();
        } else if (blockNode instanceof JCTree.JCCase) {
            ((JCTree.JCCase)blockNode).stats = newStatements.toList();
        } else if (blockNode instanceof JCTree.JCMethodDecl) {
            ((JCTree.JCMethodDecl)blockNode).body.stats = newStatements.toList();
        } else {
            throw new AssertionError((Object)"Should not get here");
        }
        ancestor.rebuild();
    }

    private List<JCTree.JCStatement> cleanupQuietly(TreeMaker maker, JavacNode node, List<JCTree.JCStatement> cleanupCall) {
        JCTree.JCVariableDecl catchParam = maker.VarDef(maker.Modifiers(16L), node.toName("$ex"), JavacHandlerUtil.chainDotsString(node, "java.io.IOException"), null);
        JCTree.JCBlock catchBody = maker.at(0).Block(0L, List.<JCTree.JCStatement>nil());
        return List.of(maker.Try(maker.Block(0L, cleanupCall), List.of(maker.Catch(catchParam, catchBody)), null));
    }

    private JCTree.JCMethodInvocation preventNullAnalysis(TreeMaker maker, JavacNode node, JCTree.JCExpression expression) {
        JCTree.JCMethodInvocation singletonList = maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.chainDotsString(node, "java.util.Collections.singletonList"), List.of(expression));
        JCTree.JCMethodInvocation cleanedExpr = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)singletonList, node.toName("get")), List.of(maker.Literal(4, 0)));
        return cleanedExpr;
    }

    private void doAssignmentCheck(JavacNode node, List<JCTree.JCStatement> statements, Name name) {
        for (JCTree.JCStatement statement : statements) {
            this.doAssignmentCheck0(node, statement, name);
        }
    }

    private void doAssignmentCheck0(JavacNode node, JCTree statement, Name name) {
        JavacNode problemNode;
        if (statement instanceof JCTree.JCAssign) {
            this.doAssignmentCheck0(node, ((JCTree.JCAssign)statement).rhs, name);
        }
        if (statement instanceof JCTree.JCExpressionStatement) {
            this.doAssignmentCheck0(node, ((JCTree.JCExpressionStatement)statement).expr, name);
        }
        if (statement instanceof JCTree.JCVariableDecl) {
            this.doAssignmentCheck0(node, ((JCTree.JCVariableDecl)statement).init, name);
        }
        if (statement instanceof JCTree.JCTypeCast) {
            this.doAssignmentCheck0(node, ((JCTree.JCTypeCast)statement).expr, name);
        }
        if (statement instanceof JCTree.JCIdent && ((JCTree.JCIdent)statement).name.contentEquals(name) && (problemNode = (JavacNode)node.getNodeFor(statement)) != null) {
            problemNode.addWarning("You're assigning an auto-cleanup variable to something else. This is a bad idea.");
        }
    }
}

