/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PageHelper
implements Interceptor {
    public static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    public static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    public static final MetaObject NULL_META_OBJECT = MetaObject.forObject(NullObject.class, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY);
    private static final String BOUND_SQL = "sqlSource.boundSql.sql";
    private static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    private static final List<ResultMapping> EMPTY_RESULTMAPPING = new ArrayList<ResultMapping>(0);
    private static String dialect = "";
    private static boolean offsetAsPageNum = false;
    private static boolean rowBoundsWithCount = false;
    private static boolean pageSizeZero = false;

    public static MetaObject forObject(Object object) {
        return MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY);
    }

    public static void startPage(int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize, true);
    }

    public static void startPage(int pageNum, int pageSize, boolean count) {
        LOCAL_PAGE.set(new Page(pageNum, pageSize, count));
    }

    private Page getPage(RowBounds rowBounds) {
        Page page = LOCAL_PAGE.get();
        LOCAL_PAGE.remove();
        if (page == null) {
            page = offsetAsPageNum ? new Page(rowBounds.getOffset(), rowBounds.getLimit(), rowBoundsWithCount) : new Page(rowBounds, rowBoundsWithCount);
        }
        return page;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        Object[] args = invocation.getArgs();
        RowBounds rowBounds = (RowBounds)args[2];
        if (LOCAL_PAGE.get() == null && rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        args[2] = RowBounds.DEFAULT;
        MappedStatement ms = (MappedStatement)args[0];
        Object parameterObject = args[1];
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        Page page = this.getPage(rowBounds);
        if (pageSizeZero && page.getPageSize() == 0) {
            Object result2 = invocation.proceed();
            page.addAll((List)result2);
            page.setPageSize(page.size());
            page.setTotal(page.size());
            return page;
        }
        MappedStatement qs = this.newMappedStatement(ms, new BoundSqlSqlSource(boundSql));
        args[0] = qs;
        MetaObject msObject = PageHelper.forObject(qs);
        String sql = (String)msObject.getValue(BOUND_SQL);
        if (page.isCount()) {
            msObject.setValue(BOUND_SQL, (Object)this.getCountSql(sql));
            result = invocation.proceed();
            page.setTotal(((Integer)((List)result).get(0)).intValue());
            if (page.getTotal() == 0L) {
                return page;
            }
        }
        if (page.getPageSize() > 0) {
            msObject.setValue(BOUND_SQL, (Object)this.getPageSql(sql, page));
            msObject.setValue("resultMaps", (Object)ms.getResultMaps());
            result = invocation.proceed();
            page.addAll((List)result);
        }
        return page;
    }

    private String getCountSql(String sql) {
        return "select count(0) from (" + sql + ") tmp_count";
    }

    private String getPageSql(String sql, Page page) {
        StringBuilder pageSql = new StringBuilder(200);
        if ("mysql".equals(dialect)) {
            pageSql.append("select * from (");
            pageSql.append(sql);
            pageSql.append(") as tmp_page limit " + page.getStartRow() + "," + page.getPageSize());
        } else if ("hsqldb".equals(dialect)) {
            pageSql.append(sql);
            pageSql.append(" LIMIT " + page.getPageSize() + " OFFSET " + page.getStartRow());
        } else if ("oracle".equals(dialect)) {
            pageSql.append("select * from ( select temp.*, rownum row_id from ( ");
            pageSql.append(sql);
            pageSql.append(" ) temp where rownum <= ").append(page.getEndRow());
            pageSql.append(") where row_id > ").append(page.getStartRow());
        }
        return pageSql.toString();
    }

    private MappedStatement newMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId() + "_PageHelper", newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), ms.getId(), Integer.TYPE, EMPTY_RESULTMAPPING).build();
        resultMaps.add(resultMap);
        builder.resultMaps(resultMaps);
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties p) {
        String sizeZero;
        String withcount;
        dialect = p.getProperty("dialect");
        if (dialect == null || "".equals(dialect)) {
            throw new RuntimeException("Mybatis\u5206\u9875\u63d2\u4ef6PageHelper\u65e0\u6cd5\u83b7\u53d6dialect\u53c2\u6570!");
        }
        String offset = p.getProperty("offsetAsPageNum");
        if (offset != null && "TRUE".equalsIgnoreCase(offset)) {
            offsetAsPageNum = true;
        }
        if ((withcount = p.getProperty("rowBoundsWithCount")) != null && "TRUE".equalsIgnoreCase(withcount)) {
            rowBoundsWithCount = true;
        }
        if ((sizeZero = p.getProperty("pageSizeZero")) != null && "TRUE".equalsIgnoreCase(sizeZero)) {
            pageSizeZero = true;
        }
    }

    private class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }

    private static class NullObject {
        private NullObject() {
        }
    }
}

