/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.ArraySet;
import httl.util.MapEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
implements Map<K, V> {
    private final K[] keys;
    private final V[] values;

    public OrderedMap(K[] keys, V[] values) {
        if (keys == null) {
            throw new IllegalArgumentException("keys == null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values == null");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys.length != values.length");
        }
        this.keys = keys;
        this.values = values;
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length > 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (K k : this.keys) {
            if (!key.equals(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (V v : this.values) {
            if (!value.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        ArraySet set = new ArraySet(this.keys.length);
        for (K key : this.keys) {
            set.add(key);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ArraySet<Map.Entry<K, V>> set = new ArraySet<Map.Entry<K, V>>(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            set.add(new MapEntry<K, V>(this.keys[i], this.values[i]));
        }
        return set;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("Readonly.");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Readonly.");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Readonly.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Readonly.");
    }
}

