/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.Token;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfaScanner {
    public static final int BREAK = -1;
    public static final int BACKSPACE = -50;
    public static final int PUSH = -100;
    public static final int POP = -1000000;
    public static final int EMPTY = 1000000;
    public static final int ERROR = -100000000;

    public List<Token> scan(String charStream, int offset) throws ParseException {
        return this.scan(charStream, offset, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<Token> scan(String charStream, int offset, boolean errorWithSource) throws ParseException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder buffer = new StringBuilder();
        StringBuilder remain = new StringBuilder();
        int pre = 0;
        int state = 0;
        int i = 0;
        int p = 0;
        while (true) {
            block22: {
                char ch;
                if (remain.length() > 0) {
                    ch = remain.charAt(0);
                    remain.deleteCharAt(0);
                } else {
                    if (i >= charStream.length()) {
                        if (buffer.length() <= 0) return tokens;
                        String message = buffer.toString();
                        tokens.add(new Token(message, offset - message.length(), pre));
                        return tokens;
                    }
                    ch = charStream.charAt(i++);
                    ++offset;
                }
                buffer.append(ch);
                state = this.next(state, ch);
                if (state <= -100000000) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("DFAScanner.state.error, error code: ").append(-100000000 - state);
                    if (errorWithSource) {
                        string = ", source: " + charStream;
                        throw new ParseException(stringBuilder.append(string).toString(), offset - buffer.length());
                    }
                    string = "";
                    throw new ParseException(stringBuilder.append(string).toString(), offset - buffer.length());
                }
                if (state <= -1000000) {
                    int n = -(state % -1000000);
                    int e = (state - n) / -1000000 - 1;
                    if (p <= 0) {
                        String string;
                        StringBuilder stringBuilder = new StringBuilder().append("DFAScanner.mismatch.stack");
                        if (errorWithSource) {
                            string = ", source: " + charStream;
                            throw new ParseException(stringBuilder.append(string).toString(), offset - buffer.length());
                        }
                        string = "";
                        throw new ParseException(stringBuilder.append(string).toString(), offset - buffer.length());
                    }
                    if (--p == 0) {
                        state = e;
                        if (state == 0) {
                            state = -1;
                        }
                        break block22;
                    } else {
                        state = n;
                        continue;
                    }
                }
                if (state <= -100) {
                    ++p;
                    state = -100 - state;
                    continue;
                }
            }
            if (state <= -1) {
                int acceptLength;
                if (state <= -50) {
                    acceptLength = buffer.length() + state - -50;
                    if (acceptLength > 0) {
                        int space = 0;
                        for (int s = acceptLength - 1; s >= 0 && Character.isSpaceChar(buffer.charAt(s)); ++space, --s) {
                        }
                        acceptLength -= space;
                    }
                } else {
                    acceptLength = buffer.length() + state - -1;
                }
                if (acceptLength < 0 || acceptLength > buffer.length()) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("DFAScanner.accepter.error");
                    if (errorWithSource) {
                        string = ", source: " + charStream;
                        throw new ParseException(stringBuilder.append(string).toString(), offset - buffer.length());
                    }
                    string = "";
                    throw new ParseException(stringBuilder.append(string).toString(), offset - buffer.length());
                }
                if (acceptLength != 0) {
                    String message = buffer.substring(0, acceptLength);
                    Token token = new Token(message, offset - buffer.length(), pre);
                    tokens.add(token);
                }
                if (acceptLength != buffer.length()) {
                    remain.insert(0, buffer.substring(acceptLength));
                }
                buffer.setLength(0);
                state = 0;
            }
            pre = state;
        }
    }

    public abstract int next(int var1, char var2);
}

