/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DateUtils {
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<SimpleDateFormat> DEFAULT_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtils.DEFAULT_FORMAT);
        }
    };
    private static final ThreadLocal<Map<String, SimpleDateFormat>> LOCAL = new ThreadLocal();

    public static DateFormat getDateFormat(String format, TimeZone timeZone) {
        SimpleDateFormat formatter;
        Map<String, SimpleDateFormat> formatters;
        if (StringUtils.isEmpty(format) || DEFAULT_FORMAT.equals(format)) {
            if (timeZone == null) {
                return DEFAULT_LOCAL.get();
            }
            format = DEFAULT_FORMAT;
        }
        if ((formatters = LOCAL.get()) == null) {
            formatters = new HashMap<String, SimpleDateFormat>();
            LOCAL.set(formatters);
        }
        String key = format;
        if (timeZone != null) {
            key = key + timeZone.getID();
        }
        if ((formatter = formatters.get(key)) == null) {
            formatter = new SimpleDateFormat(format);
            if (timeZone != null) {
                formatter.setTimeZone(timeZone);
            }
            formatters.put(key, formatter);
        }
        return formatter;
    }

    public static String format(Date value) {
        return DateUtils.format(value, DEFAULT_FORMAT, null);
    }

    public static String format(Date value, String format) {
        return DateUtils.format(value, format, null);
    }

    public static Date parse(String value, String format) {
        return DateUtils.parse(value, format, null);
    }

    public static String format(Date value, String format, TimeZone timeZone) {
        if (value == null) {
            return null;
        }
        return DateUtils.getDateFormat(format, timeZone).format(value);
    }

    public static Date parse(String value, String format, TimeZone timeZone) {
        try {
            return DateUtils.getDateFormat(format, timeZone).parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

