/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigUtils {
    private static final Pattern WINDOWS_FILE_PATTERN = Pattern.compile("^[A-Za-z]+:");
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^\\d+$");
    private static final String REF = "$";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String COMMA = ",";

    public static boolean isInteger(String value) {
        return StringUtils.isNotEmpty(value) && INTEGER_PATTERN.matcher(value).matches();
    }

    public static Properties loadProperties(String path) {
        return ConfigUtils.loadProperties(path, false);
    }

    public static Properties loadProperties(String path, boolean required) {
        Properties properties = new Properties();
        return ConfigUtils.loadProperties(properties, path, required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Properties properties, String path, boolean required) {
        Properties properties2;
        block14: {
            if (StringUtils.isEmpty(path)) {
                throw new IllegalArgumentException("path == null");
            }
            InputStream in = null;
            try {
                if (path.startsWith("/") || path.startsWith("./") || path.startsWith("../") || WINDOWS_FILE_PATTERN.matcher(path).matches()) {
                    File file = new File(path);
                    if (file.exists()) {
                        in = new FileInputStream(file);
                    }
                } else {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                }
                if (in != null) {
                    properties.load(in);
                } else if (required) {
                    throw new FileNotFoundException("Not found httl config file " + path);
                }
                properties2 = properties;
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (required) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    return properties;
                }
            }
            in.close();
        }
        return properties2;
    }

    public static boolean isFilePath(String path) {
        return path != null && (path.startsWith("/") || path.startsWith("./") || path.startsWith("../") || WINDOWS_FILE_PATTERN.matcher(path).matches());
    }

    public static String getRealPath(String path) {
        if (StringUtils.isEmpty(path)) {
            return null;
        }
        if (ConfigUtils.isFilePath(path)) {
            File file = new File(path);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
        } else {
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url != null) {
                return url.getFile();
            }
        }
        return null;
    }

    public static Map<String, String> filterWithPrefix(String prefix, Map<String, String> input, boolean escape) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String key = entry.getKey();
            if (escape) {
                key = key.replace('_', '.');
            }
            if (!key.startsWith(prefix)) continue;
            key = key.substring(prefix.length());
            String value = entry.getValue();
            if (escape) {
                if (value.startsWith(PLUS)) {
                    key = key + PLUS;
                    value = value.substring(PLUS.length());
                } else if (value.startsWith(MINUS)) {
                    key = key + MINUS;
                    value = value.substring(MINUS.length());
                }
            }
            ret.put(key, value);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static Properties mergeProperties(Object ... configs) {
        ArrayList<void> list = new ArrayList<void>();
        int last = configs.length - 1;
        for (int i = 0; i <= last; ++i) {
            void var5_6;
            Object config = configs[i];
            if (config == null) continue;
            if (config instanceof String) {
                boolean required = i == last || configs[i + 1] == null;
                Properties properties = ConfigUtils.loadProperties((String)config, required);
            } else {
                Map map = (Map)config;
            }
            list.add(var5_6);
        }
        Properties result = new Properties();
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String k;
                String v;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.endsWith(MINUS)) {
                    if (!StringUtils.isNotEmpty(value) || !StringUtils.isNotEmpty(v = result.getProperty(k = key.substring(0, key.length() - MINUS.length()))) || !v.contains(value)) continue;
                    result.setProperty(k, StringUtils.removeCommaValue(v, value));
                    continue;
                }
                if (key.endsWith(PLUS)) {
                    if (!StringUtils.isNotEmpty(value)) continue;
                    k = key.substring(0, key.length() - PLUS.length());
                    v = result.getProperty(k);
                    if (StringUtils.isNotEmpty(v)) {
                        result.setProperty(k, value + COMMA + v);
                        continue;
                    }
                    result.setProperty(k, value);
                    continue;
                }
                result.setProperty(key, value);
            }
        }
        for (Map.Entry entry : new HashMap<Object, Object>(result).entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotEmpty(value) || !value.contains(REF)) continue;
            if (value.contains(COMMA)) {
                String[] values = StringUtils.splitByComma(value);
                StringBuilder buf = new StringBuilder(value.length());
                for (String v : values) {
                    if (buf.length() > 0) {
                        buf.append(COMMA);
                    }
                    buf.append(ConfigUtils.getRefValue(result, v));
                }
                result.put(key, buf.toString());
                continue;
            }
            result.put(key, ConfigUtils.getRefValue(result, value));
        }
        return result;
    }

    private static String getRefValue(Properties result, String v) {
        while (v != null && v.startsWith(REF)) {
            String ref = v.substring(1);
            if ((v = result.getProperty(ref)) != null) continue;
            v = System.getProperty(ref);
        }
        return v == null ? "" : v;
    }

    private ConfigUtils() {
    }
}

