/*
 * Decompiled with CFR 0.152.
 */
package httl.util;

import httl.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    public static final String CLASS_EXTENSION = ".class";
    public static final String JAVA_EXTENSION = ".java";
    private static final ConcurrentMap<Class<?>, Map<String, Method>> GETTER_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();
    private static final int JIT_LIMIT = 5120;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Object newInstance(String name) {
        try {
            return ClassUtils.forName(name).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static Class<?> forName(String[] packages, String className) {
        if (packages != null && packages.length > 0 && !className.contains(".") && !CLASS_CACHE.containsKey(className)) {
            for (String pkg : packages) {
                try {
                    return ClassUtils._forName(pkg + "." + className);
                }
                catch (ClassNotFoundException e2) {
                }
            }
            try {
                return ClassUtils._forName("java.lang." + className);
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
        }
        try {
            return ClassUtils._forName(className);
        }
        catch (ClassNotFoundException e) {
            int i = className.lastIndexOf(46);
            if (i > 0 && i < className.length() - 1) {
                try {
                    return ClassUtils._forName(className.substring(0, i) + "$" + className.substring(i + 1));
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
            }
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static Class<?> forName(String className) {
        try {
            return ClassUtils._forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static Class<?> _forName(String name) throws ClassNotFoundException {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        String key = name;
        Class<?> clazz = (Class<?>)CLASS_CACHE.get(key);
        if (clazz == null) {
            Class<?> old;
            int index = name.indexOf(91);
            if (index > 0) {
                int i = (name.length() - index) / 2;
                name = name.substring(0, index);
                StringBuilder sb = new StringBuilder();
                while (i-- > 0) {
                    sb.append("[");
                }
                if ("void".equals(name)) {
                    sb.append("V");
                } else if ("boolean".equals(name)) {
                    sb.append("Z");
                } else if ("byte".equals(name)) {
                    sb.append("B");
                } else if ("char".equals(name)) {
                    sb.append("C");
                } else if ("double".equals(name)) {
                    sb.append("D");
                } else if ("float".equals(name)) {
                    sb.append("F");
                } else if ("int".equals(name)) {
                    sb.append("I");
                } else if ("long".equals(name)) {
                    sb.append("J");
                } else if ("short".equals(name)) {
                    sb.append("S");
                } else {
                    sb.append('L').append(name).append(';');
                }
                name = sb.toString();
            }
            if ((old = CLASS_CACHE.putIfAbsent(key, clazz = Class.forName(name, true, Thread.currentThread().getContextClassLoader()))) != null) {
                clazz = old;
            }
        }
        return clazz;
    }

    public static Class<?> getUnboxedClass(Class<?> type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return type;
    }

    public static Class<?> getBoxedClass(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }

    public static Boolean boxed(boolean v) {
        return v;
    }

    public static Character boxed(char v) {
        return Character.valueOf(v);
    }

    public static Byte boxed(byte v) {
        return v;
    }

    public static Short boxed(short v) {
        return v;
    }

    public static Integer boxed(int v) {
        return v;
    }

    public static Long boxed(long v) {
        return v;
    }

    public static Float boxed(float v) {
        return Float.valueOf(v);
    }

    public static Double boxed(double v) {
        return v;
    }

    public static <T> T boxed(T v) {
        return v;
    }

    public static boolean unboxed(Boolean v) {
        return v == null ? false : v;
    }

    public static char unboxed(Character v) {
        return v == null ? (char)'\u0000' : v.charValue();
    }

    public static byte unboxed(Byte v) {
        return v == null ? (byte)0 : v;
    }

    public static short unboxed(Short v) {
        return v == null ? (short)0 : v;
    }

    public static int unboxed(Integer v) {
        return v == null ? 0 : v;
    }

    public static long unboxed(Long v) {
        return v == null ? 0L : v;
    }

    public static float unboxed(Float v) {
        return v == null ? 0.0f : v.floatValue();
    }

    public static double unboxed(Double v) {
        return v == null ? 0.0 : v;
    }

    public static <T> T unboxed(T v) {
        return v;
    }

    public static boolean isTrue(boolean object) {
        return object;
    }

    public static boolean isTrue(char object) {
        return object != '\u0000';
    }

    public static boolean isTrue(byte object) {
        return object != 0;
    }

    public static boolean isTrue(short object) {
        return object != 0;
    }

    public static boolean isTrue(int object) {
        return object != 0;
    }

    public static boolean isTrue(long object) {
        return object != 0L;
    }

    public static boolean isTrue(float object) {
        return object != 0.0f;
    }

    public static boolean isTrue(double object) {
        return object != 0.0;
    }

    public static boolean isTrue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ClassUtils.getSize(object) != 0;
    }

    public static boolean isNotEmpty(Object object) {
        return ClassUtils.isTrue(object);
    }

    public static int getSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof char[]) {
            return ((char[])object).length;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length;
        }
        return -1;
    }

    public static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMethodFullName(String name, Class<?>[] parameterTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append("(");
        if (parameterTypes != null && parameterTypes.length > 0) {
            boolean first = true;
            for (Class<?> type : parameterTypes) {
                if (type == null) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append(type.getCanonicalName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static Class<?> getGenericClass(Class<?> cls) {
        return ClassUtils.getGenericClass(cls, 0);
    }

    public static Class<?> getGenericClass(Class<?> cls, int i) {
        try {
            ParameterizedType parameterizedType = cls.getGenericInterfaces().length > 0 && cls.getGenericInterfaces()[0] instanceof ParameterizedType ? (ParameterizedType)cls.getGenericInterfaces()[0] : (cls.getGenericSuperclass() instanceof ParameterizedType ? (ParameterizedType)cls.getGenericSuperclass() : null);
            if (parameterizedType != null) {
                Type genericClass = parameterizedType.getActualTypeArguments()[i];
                if (genericClass instanceof ParameterizedType) {
                    return (Class)((ParameterizedType)genericClass).getRawType();
                }
                if (genericClass instanceof GenericArrayType) {
                    Class componentType = (Class)((GenericArrayType)genericClass).getGenericComponentType();
                    if (componentType.isArray()) {
                        return componentType;
                    }
                    return Array.newInstance(componentType, 0).getClass();
                }
                if (genericClass instanceof Class) {
                    return (Class)genericClass;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cls.getSuperclass() != null && cls.getSuperclass() != Object.class) {
            return ClassUtils.getGenericClass(cls.getSuperclass(), i);
        }
        throw new IllegalArgumentException(cls.getName() + " generic type undefined!");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.specification.version");
    }

    public static boolean isBeforeJava5(String javaVersion) {
        return StringUtils.isEmpty(javaVersion) || "1.0".equals(javaVersion) || "1.1".equals(javaVersion) || "1.2".equals(javaVersion) || "1.3".equals(javaVersion) || "1.4".equals(javaVersion);
    }

    public static boolean isBeforeJava6(String javaVersion) {
        return ClassUtils.isBeforeJava5(javaVersion) || "1.5".equals(javaVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Throwable e) {
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        p.print(e.getClass().getName() + ": ");
        if (e.getMessage() != null) {
            p.print(e.getMessage() + "\n");
        }
        p.println();
        try {
            e.printStackTrace(p);
            String string = w.toString();
            return string;
        }
        finally {
            p.close();
        }
    }

    public static void checkBytecode(String name, byte[] bytecode) {
        if (bytecode.length > 5120) {
            System.err.println("The template bytecode too long, may be affect the JIT compiler. template class: " + name);
        }
    }

    public static String getSizeMethod(Class<?> cls, String[] sizers) {
        for (String sizer : sizers) {
            try {
                return cls.getMethod(sizer, new Class[0]).getName() + "()";
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    public static String getMethodName(Method method, Class<?>[] parameterClasses, String rightCode) {
        if (method.getParameterTypes().length > parameterClasses.length) {
            Class<?>[] types = method.getParameterTypes();
            StringBuilder buf = new StringBuilder(rightCode);
            for (int i = parameterClasses.length; i < types.length; ++i) {
                Class<?> type;
                if (buf.length() > 0) {
                    buf.append(",");
                }
                String def = (type = types[i]) == Boolean.TYPE ? "false" : (type == Character.TYPE ? "'\\0'" : (type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE ? "0" : "null"));
                buf.append(def);
            }
        }
        return method.getName() + "(" + rightCode + ")";
    }

    public static Object searchProperty(Object leftParameter, String name) throws Exception {
        Object result;
        Class<?> leftClass = leftParameter.getClass();
        if (leftParameter.getClass().isArray() && "length".equals(name)) {
            result = Array.getLength(leftParameter);
        } else if (leftParameter instanceof Map) {
            result = ((Map)leftParameter).get(name);
        } else {
            try {
                String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = leftClass.getMethod(getter, new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                result = method.invoke(leftParameter, new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                try {
                    String getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    Method method = leftClass.getMethod(getter, new Class[0]);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    result = method.invoke(leftParameter, new Object[0]);
                }
                catch (NoSuchMethodException e3) {
                    Field field = leftClass.getField(name);
                    result = field.get(leftParameter);
                }
            }
        }
        return result;
    }

    public static Method searchMethod(Class<?> currentClass, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return ClassUtils.searchMethod(currentClass, name, parameterTypes, false);
    }

    public static Method searchMethod(Class<?> currentClass, String name, Class<?>[] parameterTypes, boolean boxed) throws NoSuchMethodException {
        if (currentClass == null) {
            throw new NoSuchMethodException("class == null");
        }
        try {
            return currentClass.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Method likeMethod = null;
            for (Method method : currentClass.getMethods()) {
                if (!method.getName().equals(name) || parameterTypes.length != method.getParameterTypes().length || !Modifier.isPublic(method.getModifiers())) continue;
                if (parameterTypes.length > 0) {
                    Class<?>[] types = method.getParameterTypes();
                    boolean eq = true;
                    boolean like = true;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Class<?> type = types[i];
                        Class<?> parameterType = parameterTypes[i];
                        if (type == null || parameterType == null || type.equals(parameterType)) continue;
                        eq = false;
                        if (boxed) {
                            type = ClassUtils.getBoxedClass(type);
                            parameterType = ClassUtils.getBoxedClass(parameterType);
                        }
                        if (type.isAssignableFrom(parameterType)) continue;
                        eq = false;
                        like = false;
                        break;
                    }
                    if (!eq) {
                        if (!like || likeMethod != null && !likeMethod.getParameterTypes()[0].isAssignableFrom(method.getParameterTypes()[0])) continue;
                        likeMethod = method;
                        continue;
                    }
                }
                return method;
            }
            if (likeMethod != null) {
                return likeMethod;
            }
            throw e;
        }
    }

    public static String getInitCode(Class<?> type) {
        if (Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type)) {
            return "0";
        }
        if (Character.TYPE.equals(type)) {
            return "'\\0'";
        }
        if (Boolean.TYPE.equals(type)) {
            return "false";
        }
        return "null";
    }

    public static String getInitCodeWithType(Class<?> type) {
        if (Byte.TYPE.equals(type)) {
            return "(byte) 0";
        }
        if (Short.TYPE.equals(type)) {
            return "(short) 0";
        }
        if (Integer.TYPE.equals(type)) {
            return "0";
        }
        if (Long.TYPE.equals(type)) {
            return "0l";
        }
        if (Float.TYPE.equals(type)) {
            return "0f";
        }
        if (Double.TYPE.equals(type)) {
            return "0d";
        }
        if (Character.TYPE.equals(type)) {
            return "'\\0'";
        }
        if (Boolean.TYPE.equals(type)) {
            return "false";
        }
        return "(" + type.getCanonicalName() + ") null";
    }

    public static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value == null ? false : ClassUtils.toBoolean(String.valueOf(value));
    }

    public static char toChar(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return value == null ? (char)'\u0000' : ClassUtils.toChar(String.valueOf(value));
    }

    public static byte toByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return value == null ? (byte)0 : ClassUtils.toByte(String.valueOf(value));
    }

    public static short toShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return value == null ? (short)0 : ClassUtils.toShort(String.valueOf(value));
    }

    public static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return value == null ? 0 : ClassUtils.toInt(String.valueOf(value));
    }

    public static long toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return value == null ? 0L : ClassUtils.toLong(String.valueOf(value));
    }

    public static float toFloat(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return value == null ? 0.0f : ClassUtils.toFloat(String.valueOf(value));
    }

    public static double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return value == null ? 0.0 : ClassUtils.toDouble(String.valueOf(value));
    }

    public static Class<?> toClass(Object value) {
        if (value instanceof Class) {
            return (Class)value;
        }
        return value == null ? null : ClassUtils.toClass(String.valueOf(value));
    }

    public static boolean toBoolean(String value) {
        return StringUtils.isEmpty(value) ? false : Boolean.parseBoolean(value);
    }

    public static char toChar(String value) {
        return StringUtils.isEmpty(value) ? (char)'\u0000' : value.charAt(0);
    }

    public static byte toByte(String value) {
        return StringUtils.isEmpty(value) ? (byte)0 : Byte.parseByte(value);
    }

    public static short toShort(String value) {
        return StringUtils.isEmpty(value) ? (short)0 : Short.parseShort(value);
    }

    public static int toInt(String value) {
        return StringUtils.isEmpty(value) ? 0 : Integer.parseInt(value);
    }

    public static long toLong(String value) {
        return StringUtils.isEmpty(value) ? 0L : Long.parseLong(value);
    }

    public static float toFloat(String value) {
        return StringUtils.isEmpty(value) ? 0.0f : Float.parseFloat(value);
    }

    public static double toDouble(String value) {
        return StringUtils.isEmpty(value) ? 0.0 : Double.parseDouble(value);
    }

    public static Class<?> toClass(String value) {
        return StringUtils.isEmpty(value) ? null : ClassUtils.forName(value);
    }

    public static Method getGetter(Object bean, String property) {
        Map<String, Method> cache = (ConcurrentHashMap)GETTER_CACHE.get(bean.getClass());
        if (cache == null) {
            cache = new ConcurrentHashMap();
            for (Method method : bean.getClass().getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
                String name = method.getName();
                if (name.length() > 3 && name.startsWith("get")) {
                    cache.put(name.substring(3, 4).toLowerCase() + name.substring(4), method);
                    continue;
                }
                if (name.length() <= 2 || !name.startsWith("is")) continue;
                cache.put(name.substring(2, 3).toLowerCase() + name.substring(3), method);
            }
            Map old = GETTER_CACHE.putIfAbsent(bean.getClass(), cache);
            if (old != null) {
                cache = old;
            }
        }
        return (Method)cache.get(property);
    }

    public static Object getProperty(Object bean, String property) {
        if (bean == null || StringUtils.isEmpty(property)) {
            return null;
        }
        try {
            Method getter = ClassUtils.getGetter(bean, property);
            if (getter != null) {
                if (!getter.isAccessible()) {
                    getter.setAccessible(true);
                }
                return getter.invoke(bean, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setProperties(Object bean, Map<String, Object> properties) {
        for (Method method : bean.getClass().getMethods()) {
            String name = method.getName();
            if (name.length() <= 3 || !name.startsWith("set") || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1 || method.getDeclaringClass() == Object.class) continue;
            String key = name.substring(3, 4).toLowerCase() + name.substring(4);
            try {
                Object value = properties.get(key);
                if (value == null) continue;
                method.invoke(bean, ClassUtils.convertCompatibleType(value, method.getParameterTypes()[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Map<String, Object> getProperties(Object bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method method : bean.getClass().getMethods()) {
            String name = method.getName();
            if ((name.length() <= 3 || !name.startsWith("get")) && (name.length() <= 2 || !name.startsWith("is")) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getDeclaringClass() == Object.class) continue;
            int i = name.startsWith("get") ? 3 : 2;
            String key = name.substring(i, i + 1).toLowerCase() + name.substring(i + 1);
            try {
                map.put(key, method.invoke(bean, new Object[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    public static <K, V> Set<Map.Entry<K, V>> entrySet(Map<K, V> map) {
        return map == null ? null : map.entrySet();
    }

    public static String dumpException(Throwable e) {
        StringWriter sw = new StringWriter(160);
        sw.write(e.getClass().getName());
        sw.write(":\n");
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String filterJavaKeyword(String name) {
        if ("abstract".equals(name) || "assert".equals(name) || "boolean".equals(name) || "break".equals(name) || "byte".equals(name) || "case".equals(name) || "catch".equals(name) || "char".equals(name) || "class".equals(name) || "continue".equals(name) || "default".equals(name) || "do".equals(name) || "double".equals(name) || "else".equals(name) || "enum".equals(name) || "extends".equals(name) || "final".equals(name) || "finally".equals(name) || "float".equals(name) || "for".equals(name) || "if".equals(name) || "implements".equals(name) || "import".equals(name) || "instanceof".equals(name) || "int".equals(name) || "interface".equals(name) || "long".equals(name) || "native".equals(name) || "new".equals(name) || "package".equals(name) || "private".equals(name) || "protected".equals(name) || "public".equals(name) || "return".equals(name) || "strictfp".equals(name) || "short".equals(name) || "static".equals(name) || "super".equals(name) || "switch".equals(name) || "synchronized".equals(name) || "this".equals(name) || "throw".equals(name) || "throws".equals(name) || "transient".equals(name) || "try".equals(name) || "void".equals(name) || "volatile".equals(name) || "while".equals(name)) {
            return "$" + name;
        }
        return name;
    }

    public static Object convertCompatibleType(Object value, Class<?> type) {
        if (value == null || type == null || type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof String) {
            String string = (String)value;
            if (Character.TYPE.equals(type) || Character.class.equals(type)) {
                if (string.length() != 1) {
                    throw new IllegalArgumentException(String.format("CAN NOT convert String(%s) to char! when convert String to char, the String MUST only 1 char.", string));
                }
                return Character.valueOf(string.charAt(0));
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, string);
            }
            if (type == BigInteger.class) {
                return new BigInteger(string);
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(string);
            }
            if (type == Short.class || type == Short.TYPE) {
                return new Short(string);
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return new Integer(string);
            }
            if (type == Long.class || type == Long.TYPE) {
                return new Long(string);
            }
            if (type == Double.class || type == Double.TYPE) {
                return new Double(string);
            }
            if (type == Float.class || type == Float.TYPE) {
                return new Float(string);
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return new Byte(string);
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return new Boolean(string);
            }
            if (type == Date.class) {
                try {
                    return new SimpleDateFormat(DATE_FORMAT).parse((String)value);
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Failed to parse date " + value + " by format " + DATE_FORMAT + ", cause: " + e.getMessage(), e);
                }
            }
            if (type == Class.class) {
                return ClassUtils.forName((String)value);
            }
        } else if (value instanceof Number) {
            Number number = (Number)value;
            if (type == Byte.TYPE || type == Byte.class) {
                return number.byteValue();
            }
            if (type == Short.TYPE || type == Short.class) {
                return number.shortValue();
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return number.intValue();
            }
            if (type == Long.TYPE || type == Long.class) {
                return number.longValue();
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (type == Double.TYPE || type == Double.class) {
                return number.doubleValue();
            }
            if (type == BigInteger.class) {
                return BigInteger.valueOf(number.longValue());
            }
            if (type == BigDecimal.class) {
                return BigDecimal.valueOf(number.doubleValue());
            }
            if (type == Date.class) {
                return new Date(number.longValue());
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (type.isArray()) {
                int length = collection.size();
                Object array = Array.newInstance(type.getComponentType(), length);
                int i = 0;
                for (Object item : collection) {
                    Array.set(array, i++, item);
                }
                return array;
            }
            if (!type.isInterface()) {
                try {
                    Collection result = (Collection)type.newInstance();
                    result.addAll(collection);
                    return result;
                }
                catch (Throwable e) {}
            } else {
                if (type == List.class) {
                    return new ArrayList(collection);
                }
                if (type == Set.class) {
                    return new HashSet(collection);
                }
            }
        } else if (value.getClass().isArray() && Collection.class.isAssignableFrom(type)) {
            AbstractCollection collection;
            if (!type.isInterface()) {
                try {
                    collection = (ArrayList)type.newInstance();
                }
                catch (Throwable e) {
                    collection = new ArrayList();
                }
            } else {
                collection = type == Set.class ? new HashSet() : new ArrayList();
            }
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                collection.add(Array.get(value, i));
            }
            return collection;
        }
        return value;
    }

    private ClassUtils() {
    }

    static {
        CLASS_CACHE.put("boolean", Boolean.TYPE);
        CLASS_CACHE.put("char", Character.TYPE);
        CLASS_CACHE.put("byte", Byte.TYPE);
        CLASS_CACHE.put("short", Short.TYPE);
        CLASS_CACHE.put("int", Integer.TYPE);
        CLASS_CACHE.put("long", Long.TYPE);
        CLASS_CACHE.put("float", Float.TYPE);
        CLASS_CACHE.put("double", Double.TYPE);
        CLASS_CACHE.put("void", Void.TYPE);
        CLASS_CACHE.put("Boolean", Boolean.class);
        CLASS_CACHE.put("Character", Character.class);
        CLASS_CACHE.put("Byte", Byte.class);
        CLASS_CACHE.put("Short", Short.class);
        CLASS_CACHE.put("Integer", Integer.class);
        CLASS_CACHE.put("Long", Long.class);
        CLASS_CACHE.put("Float", Float.class);
        CLASS_CACHE.put("Double", Double.class);
        CLASS_CACHE.put("Number", Number.class);
        CLASS_CACHE.put("String", String.class);
        CLASS_CACHE.put("Object", Object.class);
        CLASS_CACHE.put("Class", Class.class);
        CLASS_CACHE.put("Void", Void.class);
        CLASS_CACHE.put("java.lang.Boolean", Boolean.class);
        CLASS_CACHE.put("java.lang.Character", Character.class);
        CLASS_CACHE.put("java.lang.Byte", Byte.class);
        CLASS_CACHE.put("java.lang.Short", Short.class);
        CLASS_CACHE.put("java.lang.Integer", Integer.class);
        CLASS_CACHE.put("java.lang.Long", Long.class);
        CLASS_CACHE.put("java.lang.Float", Float.class);
        CLASS_CACHE.put("java.lang.Double", Double.class);
        CLASS_CACHE.put("java.lang.Number", Number.class);
        CLASS_CACHE.put("java.lang.String", String.class);
        CLASS_CACHE.put("java.lang.Object", Object.class);
        CLASS_CACHE.put("java.lang.Class", Class.class);
        CLASS_CACHE.put("java.lang.Void", Void.class);
        CLASS_CACHE.put("java.util.Date", Date.class);
        CLASS_CACHE.put("boolean[]", boolean[].class);
        CLASS_CACHE.put("char[]", char[].class);
        CLASS_CACHE.put("byte[]", byte[].class);
        CLASS_CACHE.put("short[]", short[].class);
        CLASS_CACHE.put("int[]", int[].class);
        CLASS_CACHE.put("long[]", long[].class);
        CLASS_CACHE.put("float[]", float[].class);
        CLASS_CACHE.put("double[]", double[].class);
        CLASS_CACHE.put("Boolean[]", Boolean[].class);
        CLASS_CACHE.put("Character[]", Character[].class);
        CLASS_CACHE.put("Byte[]", Byte[].class);
        CLASS_CACHE.put("Short[]", Short[].class);
        CLASS_CACHE.put("Integer[]", Integer[].class);
        CLASS_CACHE.put("Long[]", Long[].class);
        CLASS_CACHE.put("Float[]", Float[].class);
        CLASS_CACHE.put("Double[]", Double[].class);
        CLASS_CACHE.put("Number[]", Number[].class);
        CLASS_CACHE.put("String[]", String[].class);
        CLASS_CACHE.put("Object[]", Object[].class);
        CLASS_CACHE.put("Class[]", Class[].class);
        CLASS_CACHE.put("Void[]", Void[].class);
        CLASS_CACHE.put("java.lang.Boolean[]", Boolean[].class);
        CLASS_CACHE.put("java.lang.Character[]", Character[].class);
        CLASS_CACHE.put("java.lang.Byte[]", Byte[].class);
        CLASS_CACHE.put("java.lang.Short[]", Short[].class);
        CLASS_CACHE.put("java.lang.Integer[]", Integer[].class);
        CLASS_CACHE.put("java.lang.Long[]", Long[].class);
        CLASS_CACHE.put("java.lang.Float[]", Float[].class);
        CLASS_CACHE.put("java.lang.Double[]", Double[].class);
        CLASS_CACHE.put("java.lang.Number[]", Number[].class);
        CLASS_CACHE.put("java.lang.String[]", String[].class);
        CLASS_CACHE.put("java.lang.Object[]", Object[].class);
        CLASS_CACHE.put("java.lang.Class[]", Class[].class);
        CLASS_CACHE.put("java.lang.Void[]", Void[].class);
        CLASS_CACHE.put("java.util.Date[]", Date[].class);
    }
}

