/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Node;
import httl.Template;
import httl.ast.AddOperator;
import httl.ast.AndOperator;
import httl.ast.ArrayOperator;
import httl.ast.AstVisitor;
import httl.ast.BinaryOperator;
import httl.ast.BitAndOperator;
import httl.ast.BitNotOperator;
import httl.ast.BitOrOperator;
import httl.ast.BitXorOperator;
import httl.ast.BreakDirective;
import httl.ast.CastOperator;
import httl.ast.ConditionOperator;
import httl.ast.Constant;
import httl.ast.DivOperator;
import httl.ast.ElseDirective;
import httl.ast.EntryOperator;
import httl.ast.EqualsOperator;
import httl.ast.ForDirective;
import httl.ast.GreaterEqualsOperator;
import httl.ast.GreaterOperator;
import httl.ast.IfDirective;
import httl.ast.IndexOperator;
import httl.ast.InstanceofOperator;
import httl.ast.LeftShiftOperator;
import httl.ast.LessEqualsOperator;
import httl.ast.LessOperator;
import httl.ast.ListOperator;
import httl.ast.MacroDirective;
import httl.ast.MethodOperator;
import httl.ast.ModOperator;
import httl.ast.MulOperator;
import httl.ast.NegativeOperator;
import httl.ast.NewOperator;
import httl.ast.NotEqualsOperator;
import httl.ast.NotOperator;
import httl.ast.OrOperator;
import httl.ast.PositiveOperator;
import httl.ast.RightShiftOperator;
import httl.ast.SequenceOperator;
import httl.ast.SetDirective;
import httl.ast.StaticMethodOperator;
import httl.ast.SubOperator;
import httl.ast.Text;
import httl.ast.UnsignShiftOperator;
import httl.ast.ValueDirective;
import httl.ast.Variable;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Switcher;
import httl.util.ClassUtils;
import httl.util.CollectionUtils;
import httl.util.Condition;
import httl.util.LinkedStack;
import httl.util.MapEntry;
import httl.util.Status;
import httl.util.StringSequence;
import httl.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedVisitor
extends AstVisitor {
    private Filter currentTextFilter;
    private Filter textFilter;
    private Filter valueFilter;
    private Formatter<Object> formatter;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private String filterVariable;
    private String formatterVariable;
    private String[] forVariable;
    private String ifVariable;
    private String breakVariable;
    private String outputEncoding;
    private Map<Class<?>, Object> importMethods;
    private List<StringSequence> importSequences;
    private Map<String, Template> importMacros;
    private String[] importPackages;
    private Template template;
    private Object out;
    private String preText;
    private final LinkedStack<Object> parameterStack = new LinkedStack();

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setImportMacros(Map<String, Template> importMacros) {
        this.importMacros = importMacros;
    }

    public void setImportMethods(Map<Class<?>, Object> importMethods) {
        this.importMethods = importMethods;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setImportSequences(List<StringSequence> importSequences) {
        this.importSequences = importSequences;
    }

    private List<String> getSequence(String begin, String end) {
        if (this.importSequences != null) {
            for (StringSequence sequence : this.importSequences) {
                if (!sequence.containSequence(begin, end)) continue;
                return sequence.getSequence(begin, end);
            }
        }
        throw new IllegalStateException("No such sequence from \"" + begin + "\" to \"" + end + "\".");
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setOut(Object out) {
        this.out = out;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setFormatter(Formatter<Object> formatter) {
        this.formatter = formatter;
    }

    public void setTextFilter(Filter textFilter) {
        this.textFilter = textFilter;
        this.currentTextFilter = textFilter;
    }

    public void setValueFilter(Filter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public void setIfVariable(String ifVariable) {
        this.ifVariable = ifVariable;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    private Object popExpressionResult(int offset) throws IOException, ParseException {
        Object result = this.parameterStack.pop();
        if (!this.parameterStack.isEmpty()) {
            throw new ParseException("The directive expression error.", offset);
        }
        return result;
    }

    @Override
    public void visit(Text node) throws IOException, ParseException {
        try {
            String text = node.getContent();
            if (this.textFilterSwitcher != null || this.valueFilterSwitcher != null || this.formatterSwitcher != null) {
                List<String> formatterLocations;
                List<String> valueLocations;
                List<String> textLocations;
                HashSet<String> locations = new HashSet<String>();
                List<String> list = textLocations = this.textFilterSwitcher == null ? null : this.textFilterSwitcher.locations();
                if (textLocations != null) {
                    locations.addAll(textLocations);
                }
                List<String> list2 = valueLocations = this.valueFilterSwitcher == null ? null : this.valueFilterSwitcher.locations();
                if (valueLocations != null) {
                    locations.addAll(valueLocations);
                }
                List<String> list3 = formatterLocations = this.formatterSwitcher == null ? null : this.formatterSwitcher.locations();
                if (formatterLocations != null) {
                    locations.addAll(formatterLocations);
                }
                if (locations != null && locations.size() > 0) {
                    TreeMap<Integer, HashSet<String>> switchesd = new TreeMap<Integer, HashSet<String>>();
                    for (String location : locations) {
                        int i = -1;
                        while ((i = text.indexOf(location, i + 1)) >= 0) {
                            Integer key = i;
                            HashSet<String> values = (HashSet<String>)switchesd.get(key);
                            if (values == null) {
                                values = new HashSet<String>();
                                switchesd.put(key, values);
                            }
                            values.add(location);
                        }
                    }
                    if (switchesd.size() > 0) {
                        int begin = 0;
                        for (Map.Entry entry : switchesd.entrySet()) {
                            int end = (Integer)entry.getKey();
                            String part = text.substring(begin, end);
                            if (StringUtils.isNotEmpty(part)) {
                                this.preText = part = this.currentTextFilter == null ? part : this.currentTextFilter.filter(this.preText, part);
                                if (this.out instanceof Writer) {
                                    ((Writer)this.out).write(part);
                                } else if (this.out instanceof OutputStream) {
                                    ((OutputStream)this.out).write(part.getBytes(this.outputEncoding));
                                }
                            }
                            begin = end;
                            for (String location : (Set)entry.getValue()) {
                                if (textLocations != null && textLocations.contains(location)) {
                                    this.currentTextFilter = this.textFilterSwitcher.switchover(location, this.textFilter);
                                }
                                if (valueLocations != null && valueLocations.contains(location)) {
                                    Context.getContext().put(this.filterVariable, (Object)this.valueFilterSwitcher.switchover(location, this.valueFilter));
                                }
                                if (formatterLocations == null || !formatterLocations.contains(location)) continue;
                                Context.getContext().put(this.formatterVariable, (Object)this.formatterSwitcher.switchover(location, this.formatter));
                            }
                        }
                        if (begin > 0) {
                            text = text.substring(begin);
                        }
                    }
                }
            }
            if (StringUtils.isNotEmpty(text)) {
                this.preText = text = this.currentTextFilter == null ? text : this.currentTextFilter.filter(this.preText, text);
                if (this.out instanceof Writer) {
                    ((Writer)this.out).write(text);
                } else if (this.out instanceof OutputStream) {
                    ((OutputStream)this.out).write(text.getBytes(this.outputEncoding));
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), node.getOffset());
        }
    }

    @Override
    public void visit(ValueDirective node) throws IOException, ParseException {
        Object result = this.popExpressionResult(node.getOffset());
        if (result instanceof Template) {
            ((Template)result).render(this.out);
        } else {
            Formatter format = (Formatter)Context.getContext().get(this.formatterVariable, this.formatter);
            String text = format == null ? StringUtils.toString(result) : format.toString(null, result);
            Filter filter = (Filter)Context.getContext().get(this.filterVariable, this.valueFilter);
            if (!node.isNoFilter() && filter != null) {
                text = filter.filter(node.getExpression().toString(), text);
            }
            try {
                if (text != null) {
                    if (this.out instanceof Writer) {
                        ((Writer)this.out).write(text);
                    } else if (this.out instanceof OutputStream) {
                        ((OutputStream)this.out).write(text.getBytes(this.outputEncoding));
                    }
                }
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage(), node.getOffset());
            }
        }
    }

    @Override
    public void visit(SetDirective node) throws IOException, ParseException {
        if (node.getExpression() != null) {
            Object result = this.popExpressionResult(node.getOffset());
            if (node.isExport() && Context.getContext().getParent() != null) {
                Context.getContext().getParent().put(node.getName(), result);
            } else {
                Context.getContext().put(node.getName(), result);
            }
        }
    }

    @Override
    public void visit(BreakDirective node) throws IOException, ParseException {
        boolean result = true;
        if (node.getExpression() != null) {
            result = ClassUtils.isTrue(this.popExpressionResult(node.getOffset()));
        }
        if (result) {
            Context.getContext().put(this.breakVariable, (Object)true);
        }
    }

    @Override
    public boolean visit(IfDirective node) throws IOException, ParseException {
        boolean result = ClassUtils.isTrue(this.popExpressionResult(node.getOffset()));
        Context.getContext().put(this.ifVariable, (Object)result);
        return result;
    }

    @Override
    public boolean visit(ElseDirective node) throws IOException, ParseException {
        boolean result = true;
        if (node.getExpression() != null) {
            result = ClassUtils.isTrue(this.popExpressionResult(node.getOffset()));
        }
        boolean bl = result = result && !ClassUtils.isTrue(Context.getContext().get(this.ifVariable));
        if (result) {
            Context.getContext().put(this.ifVariable, (Object)true);
        }
        return result;
    }

    @Override
    public boolean visit(ForDirective node) throws IOException, ParseException {
        Object data = this.popExpressionResult(node.getOffset());
        boolean result = ClassUtils.isTrue(data);
        Context.getContext().put(this.ifVariable, (Object)result);
        Iterator<?> iterator = CollectionUtils.toIterator(data);
        Status status = new Status((Status)Context.getContext().get(this.forVariable[0]), data);
        for (String var : this.forVariable) {
            Context.getContext().put(var, (Object)status);
        }
        block1: while (iterator.hasNext()) {
            Object item = iterator.next();
            Context.getContext().put(node.getName(), item);
            for (Node child : node.getChildren()) {
                child.accept(this);
                if (!ClassUtils.isTrue(Context.getContext().get(this.breakVariable))) continue;
                Context.getContext().remove(this.breakVariable);
                break block1;
            }
            status.increment();
        }
        for (String var : this.forVariable) {
            Context.getContext().put(var, (Object)status.getParent());
        }
        return false;
    }

    @Override
    public boolean visit(MacroDirective node) throws IOException, ParseException {
        return false;
    }

    @Override
    public boolean visit(Template node) throws IOException, ParseException {
        for (Node child : node.getChildren()) {
            child.accept(this);
            if (!ClassUtils.isTrue(Context.getContext().get(this.breakVariable))) continue;
            Context.getContext().remove(this.breakVariable);
            break;
        }
        return false;
    }

    @Override
    public void visit(Constant node) throws IOException, ParseException {
        this.parameterStack.push(node.getValue());
    }

    @Override
    public void visit(Variable node) throws IOException, ParseException {
        this.parameterStack.push(Context.getContext().get(node.getName()));
    }

    @Override
    public void visit(CastOperator node) throws IOException, ParseException {
        Object parameter;
        Object result = parameter = this.parameterStack.pop();
        this.parameterStack.push(result);
    }

    @Override
    public void visit(PositiveOperator node) throws IOException, ParseException {
        Object parameter;
        Object result = parameter = this.parameterStack.pop();
        this.parameterStack.push(result);
    }

    @Override
    public void visit(NegativeOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Number result = null;
        if (parameter instanceof Integer) {
            result = -((Integer)parameter).intValue();
        } else if (parameter instanceof Long) {
            result = -((Long)parameter).longValue();
        } else if (parameter instanceof Float) {
            result = Float.valueOf(-((Float)parameter).floatValue());
        } else if (parameter instanceof Double) {
            result = -((Double)parameter).doubleValue();
        } else if (parameter instanceof Short) {
            result = -((Short)parameter).shortValue();
        } else if (parameter instanceof Byte) {
            result = -((Byte)parameter).byteValue();
        } else {
            throw new ParseException("The unary operator \"" + node.getName() + "\" unsupported parameter type " + parameter.getClass(), node.getOffset());
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(NotOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Boolean result = !ClassUtils.isTrue(parameter);
        this.parameterStack.push(result);
    }

    @Override
    public void visit(BitNotOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Number result = null;
        if (parameter instanceof Integer) {
            result = ~((Integer)parameter).intValue();
        } else if (parameter instanceof Long) {
            result = (Long)parameter ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (parameter instanceof Short) {
            result = ~((Short)parameter).shortValue();
        } else if (parameter instanceof Byte) {
            result = ~((Byte)parameter).byteValue();
        } else {
            throw new ParseException("The unary operator \"" + node.getName() + "\" unsupported parameter type " + parameter.getClass(), node.getOffset());
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(ListOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Object result = null;
        if (parameter instanceof Object[]) {
            Object[] array = (Object[])parameter;
            Class<Object> cls = null;
            for (Object obj : array) {
                if (obj == null) continue;
                if (cls == null) {
                    cls = obj.getClass();
                    continue;
                }
                if (cls == obj.getClass()) continue;
                cls = Object.class;
                break;
            }
            if (Map.Entry.class.isAssignableFrom(cls)) {
                HashMap map = new HashMap();
                for (Object obj : array) {
                    if (obj == null) continue;
                    Map.Entry entry = (Map.Entry)obj;
                    map.put(entry.getKey(), entry.getValue());
                }
                result = map;
            } else if (cls != null && cls != Object.class) {
                cls = ClassUtils.getUnboxedClass(cls);
                Object newArray = Array.newInstance(cls, array.length);
                for (int i = 0; i < array.length; ++i) {
                    Object obj = array[i];
                    if (obj == null) continue;
                    Array.set(newArray, i, obj);
                }
                result = newArray;
            } else {
                result = array;
            }
        } else if (parameter instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)parameter;
            HashMap map = new HashMap();
            map.put(entry.getKey(), entry.getValue());
            result = map;
        } else {
            result = new Object[]{parameter};
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(NewOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Object result = null;
        String name = node.getName();
        Class<?> cls = ClassUtils.forName(this.importPackages, name);
        Object[] args = parameter == null && node.getParameter() instanceof Constant && ((Constant)node.getParameter()).isBoxed() ? new Object[]{} : (parameter instanceof Object[] ? (Object[])parameter : new Object[]{parameter});
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? null : ClassUtils.getUnboxedClass(args[i].getClass());
        }
        try {
            result = cls.getConstructor(types).newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException("No such constructor " + ClassUtils.getMethodFullName(name, types) + ", cause: " + e.getMessage(), node.getOffset());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new ParseException("Failed to create " + ClassUtils.getMethodFullName(name, types) + ", cause: " + e.getMessage(), node.getOffset());
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(StaticMethodOperator node) throws IOException, ParseException {
        Object parameter = this.parameterStack.pop();
        Object result = null;
        String name = node.getName();
        String filteredName = ClassUtils.filterJavaKeyword(name);
        Object[] args = parameter == null && node.getParameter() instanceof Constant && ((Constant)node.getParameter()).isBoxed() ? new Object[]{} : (parameter instanceof Object[] ? (Object[])parameter : new Object[]{parameter});
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? null : args[i].getClass();
        }
        boolean found = false;
        if (this.importMethods != null && this.importMethods.size() > 0) {
            for (Map.Entry<Class<?>, Object> entry : this.importMethods.entrySet()) {
                Class<?> function = entry.getKey();
                try {
                    Method method = ClassUtils.searchMethod(function, filteredName, types, true);
                    if (Object.class.equals(method.getDeclaringClass())) continue;
                    Class<?> type = method.getReturnType();
                    if (type == Void.TYPE) {
                        throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                    }
                    result = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, args) : method.invoke(entry.getValue(), args);
                    found = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    throw new ParseException("Failed to invoke method " + ClassUtils.getMethodFullName(filteredName, types) + " in class " + function.getCanonicalName() + ", cause: " + ClassUtils.dumpException(e), node.getOffset());
                }
            }
        }
        if (!found) {
            Template macro;
            Object value = Context.getContext().get(name);
            if (value instanceof Template) {
                macro = (Template)value;
            } else {
                macro = this.template.getMacros().get(name);
                if (macro == null && this.importMacros != null) {
                    macro = this.importMacros.get(name);
                }
            }
            if (macro != null) {
                result = macro.evaluate(args);
            } else {
                throw new ParseException("No such macro \"" + filteredName + "\" or import method " + ClassUtils.getMethodFullName(filteredName, types) + ".", node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(AddOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Object result = null;
        result = leftParameter instanceof Integer && rightParameter instanceof Number ? Integer.valueOf(((Number)leftParameter).intValue() + ((Number)rightParameter).intValue()) : (leftParameter instanceof Long && rightParameter instanceof Number ? Long.valueOf(((Number)leftParameter).longValue() + ((Number)rightParameter).longValue()) : (leftParameter instanceof Float && rightParameter instanceof Number ? Float.valueOf(((Number)leftParameter).floatValue() + ((Number)rightParameter).floatValue()) : (leftParameter instanceof Double && rightParameter instanceof Number ? Double.valueOf(((Number)leftParameter).doubleValue() + ((Number)rightParameter).doubleValue()) : (leftParameter instanceof Short && rightParameter instanceof Number ? Integer.valueOf(((Number)leftParameter).shortValue() + ((Number)rightParameter).shortValue()) : (leftParameter instanceof Byte && rightParameter instanceof Number ? Integer.valueOf(((Number)leftParameter).byteValue() + ((Number)rightParameter).byteValue()) : (leftParameter instanceof Map && rightParameter instanceof Map ? CollectionUtils.merge((Map)leftParameter, (Map)rightParameter) : (leftParameter instanceof Collection ? (rightParameter instanceof Collection ? CollectionUtils.merge((Collection)leftParameter, (Collection)rightParameter) : (rightParameter instanceof Object[] ? CollectionUtils.merge((Collection)leftParameter, (Object[])rightParameter) : CollectionUtils.merge((Collection)leftParameter, Arrays.asList(rightParameter)))) : (leftParameter instanceof Object[] ? (rightParameter instanceof Collection ? CollectionUtils.merge((Object[])leftParameter, (Collection)rightParameter) : (rightParameter instanceof Object[] ? CollectionUtils.merge((Object[])leftParameter, (Object[])rightParameter) : CollectionUtils.merge((Object[])leftParameter, Arrays.asList(rightParameter)))) : StringUtils.concat(leftParameter, rightParameter)))))))));
        this.parameterStack.push(result);
    }

    @Override
    public void visit(SubOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() - ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() - ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Float && rightParameter instanceof Number) {
                result = Float.valueOf(((Number)leftParameter).floatValue() - ((Number)rightParameter).floatValue());
            } else if (leftParameter instanceof Double && rightParameter instanceof Number) {
                result = ((Number)leftParameter).doubleValue() - ((Number)rightParameter).doubleValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() - ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() - ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(MulOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() * ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() * ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Float && rightParameter instanceof Number) {
                result = Float.valueOf(((Number)leftParameter).floatValue() * ((Number)rightParameter).floatValue());
            } else if (leftParameter instanceof Double && rightParameter instanceof Number) {
                result = ((Number)leftParameter).doubleValue() * ((Number)rightParameter).doubleValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() * ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() * ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(DivOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() / ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() / ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Float && rightParameter instanceof Number) {
                result = Float.valueOf(((Number)leftParameter).floatValue() / ((Number)rightParameter).floatValue());
            } else if (leftParameter instanceof Double && rightParameter instanceof Number) {
                result = ((Number)leftParameter).doubleValue() / ((Number)rightParameter).doubleValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() / ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() / ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(ModOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() % ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() % ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Float && rightParameter instanceof Number) {
                result = Float.valueOf(((Number)leftParameter).floatValue() % ((Number)rightParameter).floatValue());
            } else if (leftParameter instanceof Double && rightParameter instanceof Number) {
                result = ((Number)leftParameter).doubleValue() % ((Number)rightParameter).doubleValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() % ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() % ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(EqualsOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter instanceof String && !(rightParameter instanceof String)) {
            rightParameter = StringUtils.toString(rightParameter);
        } else if (!(leftParameter instanceof String) && rightParameter instanceof String) {
            leftParameter = StringUtils.toString(leftParameter);
        }
        result = leftParameter != null ? Boolean.valueOf(leftParameter.equals(rightParameter)) : Boolean.valueOf(rightParameter == null);
        this.parameterStack.push(result);
    }

    @Override
    public void visit(NotEqualsOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter instanceof String && !(rightParameter instanceof String)) {
            rightParameter = StringUtils.toString(rightParameter);
        } else if (!(leftParameter instanceof String) && rightParameter instanceof String) {
            leftParameter = StringUtils.toString(leftParameter);
        }
        result = leftParameter != null ? Boolean.valueOf(!leftParameter.equals(rightParameter)) : Boolean.valueOf(rightParameter != null);
        this.parameterStack.push(result);
    }

    @Override
    public void visit(GreaterOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Comparable) {
                result = ((Comparable)leftParameter).compareTo(rightParameter) > 0;
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(GreaterEqualsOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Comparable) {
                result = ((Comparable)leftParameter).compareTo(rightParameter) >= 0;
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(LessOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Comparable) {
                result = ((Comparable)leftParameter).compareTo(rightParameter) < 0;
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(LessEqualsOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Comparable) {
                result = ((Comparable)leftParameter).compareTo(rightParameter) <= 0;
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(AndOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = null;
        if (leftParameter != null) {
            result = ClassUtils.isTrue(leftParameter) && ClassUtils.isTrue(rightParameter);
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(OrOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Object result = null;
        if (leftParameter != null) {
            result = ClassUtils.isTrue(leftParameter) ? leftParameter : rightParameter;
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(BitAndOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() & ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() & ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() & ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() & ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(BitOrOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() | ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() | ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() | ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() | ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(BitXorOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() ^ ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() ^ ((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() ^ ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() ^ ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(RightShiftOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() >> ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() >> (int)((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() >> ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() >> ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(LeftShiftOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() << ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() << (int)((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() << ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() << ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(UnsignShiftOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Number result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Number) {
                result = ((Number)leftParameter).intValue() >>> ((Number)rightParameter).intValue();
            } else if (leftParameter instanceof Long && rightParameter instanceof Number) {
                result = ((Number)leftParameter).longValue() >>> (int)((Number)rightParameter).longValue();
            } else if (leftParameter instanceof Short && rightParameter instanceof Number) {
                result = ((Number)leftParameter).shortValue() >>> ((Number)rightParameter).shortValue();
            } else if (leftParameter instanceof Byte && rightParameter instanceof Number) {
                result = ((Number)leftParameter).byteValue() >>> ((Number)rightParameter).byteValue();
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(ArrayOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Object[] result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Object[] && node.getLeftParameter() instanceof BinaryOperator && ",".equals(((BinaryOperator)node.getLeftParameter()).getName())) {
                Object[] leftArray = (Object[])leftParameter;
                Object[] array = new Object[leftArray.length + 1];
                System.arraycopy(leftArray, 0, array, 0, leftArray.length);
                array[leftArray.length] = rightParameter;
                result = array;
            } else {
                Object[] array = new Object[]{leftParameter, rightParameter};
                result = array;
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(ConditionOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Condition result = null;
        if (leftParameter != null) {
            result = new Condition(ClassUtils.isTrue(leftParameter), rightParameter);
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(EntryOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Object result = null;
        if (leftParameter != null) {
            Condition condition;
            result = leftParameter instanceof Condition ? ((condition = (Condition)leftParameter).isStatus() ? condition.getValue() : rightParameter) : new MapEntry<Object, Object>(leftParameter, rightParameter);
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(InstanceofOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Boolean result = false;
        if (leftParameter != null) {
            if (rightParameter instanceof Class) {
                result = ((Class)rightParameter).isInstance(leftParameter);
            } else if (rightParameter instanceof String) {
                result = ClassUtils.forName((String)rightParameter).isInstance(leftParameter);
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(IndexOperator node) throws IOException, ParseException {
        void var4_30;
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Object var4_4 = null;
        if (leftParameter != null) {
            if (rightParameter instanceof Number) {
                if (leftParameter instanceof List) {
                    Object e = ((List)leftParameter).get(((Number)rightParameter).intValue());
                } else if (leftParameter instanceof Object[]) {
                    Object object = ((Object[])leftParameter)[((Number)rightParameter).intValue()];
                } else if (leftParameter instanceof int[]) {
                    Integer n = ((int[])leftParameter)[((Number)rightParameter).intValue()];
                } else if (leftParameter instanceof long[]) {
                    Long l = ((long[])leftParameter)[((Number)rightParameter).intValue()];
                } else if (leftParameter instanceof float[]) {
                    Float f = Float.valueOf(((float[])leftParameter)[((Number)rightParameter).intValue()]);
                } else if (leftParameter instanceof double[]) {
                    Double d = ((double[])leftParameter)[((Number)rightParameter).intValue()];
                } else if (leftParameter instanceof short[]) {
                    Short s = ((short[])leftParameter)[((Number)rightParameter).intValue()];
                } else if (leftParameter instanceof byte[]) {
                    Byte by = ((byte[])leftParameter)[((Number)rightParameter).intValue()];
                } else if (leftParameter instanceof char[]) {
                    Character c = Character.valueOf(((char[])leftParameter)[((Number)rightParameter).intValue()]);
                } else if (leftParameter instanceof boolean[]) {
                    Boolean bl = ((boolean[])leftParameter)[((Number)rightParameter).intValue()];
                } else {
                    if (!(leftParameter instanceof char[])) throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
                    Character c = Character.valueOf(((char[])leftParameter)[((Number)rightParameter).intValue()]);
                }
            } else if (rightParameter instanceof int[] || rightParameter instanceof Object[] && CollectionUtils.isIntegerArray((Object[])rightParameter)) {
                int[] indexs;
                int[] nArray = indexs = rightParameter instanceof int[] ? (int[])rightParameter : CollectionUtils.toIntegerArray((Object[])rightParameter);
                if (leftParameter instanceof List) {
                    List list = CollectionUtils.subList((List)leftParameter, indexs);
                } else if (leftParameter instanceof Object[]) {
                    Object[] objectArray = CollectionUtils.subArray((Object[])leftParameter, indexs);
                } else if (leftParameter instanceof int[]) {
                    int[] nArray2 = CollectionUtils.subArray((int[])leftParameter, indexs);
                } else if (leftParameter instanceof long[]) {
                    long[] lArray = CollectionUtils.subArray((long[])leftParameter, indexs);
                } else if (leftParameter instanceof float[]) {
                    float[] fArray = CollectionUtils.subArray((float[])leftParameter, indexs);
                } else if (leftParameter instanceof double[]) {
                    double[] dArray = CollectionUtils.subArray((double[])leftParameter, indexs);
                } else if (leftParameter instanceof short[]) {
                    short[] sArray = CollectionUtils.subArray((short[])leftParameter, indexs);
                } else if (leftParameter instanceof byte[]) {
                    byte[] byArray = CollectionUtils.subArray((byte[])leftParameter, indexs);
                } else if (leftParameter instanceof char[]) {
                    char[] cArray = CollectionUtils.subArray((char[])leftParameter, indexs);
                } else if (leftParameter instanceof boolean[]) {
                    boolean[] blArray = CollectionUtils.subArray((boolean[])leftParameter, indexs);
                } else {
                    if (!(leftParameter instanceof char[])) throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
                    char[] cArray = CollectionUtils.subArray((char[])leftParameter, indexs);
                }
            } else {
                if (!(rightParameter instanceof String)) throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
                if (leftParameter instanceof Map) {
                    Object v = ((Map)leftParameter).get((String)rightParameter);
                } else {
                    if (!StringUtils.isNamed((String)rightParameter)) throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
                    try {
                        Object object = ClassUtils.searchProperty(leftParameter, (String)rightParameter);
                    }
                    catch (Exception e) {
                        throw new ParseException(e.getMessage(), node.getOffset());
                    }
                }
            }
        }
        this.parameterStack.push(var4_30);
    }

    @Override
    public void visit(SequenceOperator node) throws IOException, ParseException {
        Object rightParameter = this.parameterStack.pop();
        Object leftParameter = this.parameterStack.pop();
        Object result = null;
        if (leftParameter != null) {
            if (leftParameter instanceof Integer && rightParameter instanceof Integer) {
                result = CollectionUtils.createSequence((int)((Integer)leftParameter), (int)((Integer)rightParameter));
            } else if (leftParameter instanceof Long && rightParameter instanceof Long) {
                result = CollectionUtils.createSequence((long)((Long)leftParameter), (long)((Long)rightParameter));
            } else if (leftParameter instanceof Float && rightParameter instanceof Float) {
                result = CollectionUtils.createSequence(((Float)leftParameter).floatValue(), ((Float)rightParameter).floatValue());
            } else if (leftParameter instanceof Double && rightParameter instanceof Double) {
                result = CollectionUtils.createSequence((double)((Double)leftParameter), (double)((Double)rightParameter));
            } else if (leftParameter instanceof Short && rightParameter instanceof Short) {
                result = CollectionUtils.createSequence((short)((Short)leftParameter), (short)((Short)rightParameter));
            } else if (leftParameter instanceof Byte && rightParameter instanceof Byte) {
                result = CollectionUtils.createSequence((byte)((Byte)leftParameter), (byte)((Byte)rightParameter));
            } else if (leftParameter instanceof Character && rightParameter instanceof Character) {
                result = CollectionUtils.createSequence(((Character)leftParameter).charValue(), ((Character)rightParameter).charValue());
            } else if (leftParameter instanceof String && rightParameter instanceof String) {
                result = this.getSequence((String)leftParameter, (String)rightParameter);
            } else {
                throw new ParseException("The binary operator \"" + node.getName() + "\" unsupported parameter type " + leftParameter.getClass().getName() + ", " + rightParameter.getClass().getName(), node.getOffset());
            }
        }
        this.parameterStack.push(result);
    }

    @Override
    public void visit(MethodOperator node) throws IOException, ParseException {
        Class<?> result;
        block28: {
            Object rightParameter = this.parameterStack.pop();
            Class<?> leftParameter = this.parameterStack.pop();
            result = null;
            if (leftParameter != null) {
                String name = node.getName();
                Class<?> leftClass = leftParameter.getClass();
                if ("to".equals(name) && rightParameter instanceof String) {
                    result = leftParameter;
                } else if ("class".equals(name)) {
                    result = node.getLeftParameter() instanceof Constant && !((Constant)node.getLeftParameter()).isBoxed() ? ClassUtils.getUnboxedClass(leftClass) : leftClass;
                } else {
                    name = ClassUtils.filterJavaKeyword(name);
                    Object[] args = rightParameter == null ? new Object[]{} : (rightParameter instanceof Object[] ? (Object[])rightParameter : new Object[]{rightParameter});
                    result = null;
                    boolean found = false;
                    if (this.importMethods != null && this.importMethods.size() > 0) {
                        Object[] staticArgs = new Object[args.length + 1];
                        staticArgs[0] = leftParameter;
                        System.arraycopy(args, 0, staticArgs, 1, args.length);
                        Class[] types = new Class[staticArgs.length];
                        for (int i = 0; i < staticArgs.length; ++i) {
                            types[i] = staticArgs[i] == null ? null : staticArgs[i].getClass();
                        }
                        for (Map.Entry<Class<?>, Object> entry : this.importMethods.entrySet()) {
                            Class<?> function = entry.getKey();
                            try {
                                Method method = ClassUtils.searchMethod(function, name, types, true);
                                if (Object.class.equals(method.getDeclaringClass())) break;
                                Class<?> type = method.getReturnType();
                                if (type == Void.TYPE) {
                                    throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                                }
                                result = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, staticArgs) : method.invoke(entry.getValue(), staticArgs);
                                found = true;
                                break;
                            }
                            catch (NoSuchMethodException e) {
                            }
                            catch (Exception e) {
                                throw new ParseException("Failed to invoke method " + ClassUtils.getMethodFullName(name, types) + " in class " + function.getCanonicalName() + ", cause: " + e.getMessage(), node.getOffset());
                            }
                        }
                    }
                    if (!found) {
                        try {
                            Class[] types = new Class[args.length];
                            for (int i = 0; i < args.length; ++i) {
                                types[i] = args[i] == null ? null : args[i].getClass();
                            }
                            try {
                                Method method = ClassUtils.searchMethod(leftClass, name, types, true);
                                if (!method.isAccessible()) {
                                    method.setAccessible(true);
                                }
                                result = method.invoke(leftParameter, args);
                                found = true;
                            }
                            catch (NoSuchMethodException e) {
                                if (args.length == 0) {
                                    try {
                                        result = ClassUtils.searchProperty(leftParameter, name);
                                        found = true;
                                    }
                                    catch (NoSuchFieldException e2) {
                                        // empty catch block
                                    }
                                }
                                if (found) break block28;
                                if (leftParameter instanceof Template) {
                                    Template macro = ((Template)((Object)leftParameter)).getMacros().get(name);
                                    if (macro != null) {
                                        result = macro.evaluate(args);
                                        break block28;
                                    }
                                    throw new ParseException("No such macro or method " + name + " in " + leftParameter.getClass().getCanonicalName(), node.getOffset());
                                }
                                if (leftParameter instanceof Class) {
                                    Class<?> function = leftParameter;
                                    Method method = ClassUtils.searchMethod(function, name, types, true);
                                    Class<?> type = method.getReturnType();
                                    if (type == Void.TYPE) {
                                        throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                                    }
                                    if (!Modifier.isStatic(method.getModifiers())) {
                                        throw new ParseException("Can not call non-static method " + method.getName() + " in class " + function.getName(), node.getOffset());
                                    }
                                    result = method.invoke(null, args);
                                    break block28;
                                }
                                throw new ParseException("No such method " + name + " in " + leftParameter.getClass().getCanonicalName(), node.getOffset());
                            }
                        }
                        catch (ParseException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new ParseException(ClassUtils.toString(e), node.getOffset());
                        }
                    }
                }
            }
        }
        this.parameterStack.push(result);
    }
}

