/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.ast.AddOperator;
import httl.ast.AndOperator;
import httl.ast.ArrayOperator;
import httl.ast.AstVisitor;
import httl.ast.BinaryOperator;
import httl.ast.BitAndOperator;
import httl.ast.BitNotOperator;
import httl.ast.BitOrOperator;
import httl.ast.BitXorOperator;
import httl.ast.BreakDirective;
import httl.ast.CastOperator;
import httl.ast.ConditionOperator;
import httl.ast.Constant;
import httl.ast.DivOperator;
import httl.ast.ElseDirective;
import httl.ast.EntryOperator;
import httl.ast.EqualsOperator;
import httl.ast.Expression;
import httl.ast.ForDirective;
import httl.ast.GreaterEqualsOperator;
import httl.ast.GreaterOperator;
import httl.ast.IfDirective;
import httl.ast.IndexOperator;
import httl.ast.InstanceofOperator;
import httl.ast.LeftShiftOperator;
import httl.ast.LessEqualsOperator;
import httl.ast.LessOperator;
import httl.ast.ListOperator;
import httl.ast.MacroDirective;
import httl.ast.MethodOperator;
import httl.ast.ModOperator;
import httl.ast.MulOperator;
import httl.ast.NegativeOperator;
import httl.ast.NewOperator;
import httl.ast.NotEqualsOperator;
import httl.ast.NotOperator;
import httl.ast.Operator;
import httl.ast.OrOperator;
import httl.ast.PositiveOperator;
import httl.ast.RightShiftOperator;
import httl.ast.SequenceOperator;
import httl.ast.SetDirective;
import httl.ast.Statement;
import httl.ast.StaticMethodOperator;
import httl.ast.SubOperator;
import httl.ast.Text;
import httl.ast.UnsignShiftOperator;
import httl.ast.ValueDirective;
import httl.ast.Variable;
import httl.spi.Compiler;
import httl.spi.Converter;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Interceptor;
import httl.spi.Switcher;
import httl.spi.formatters.MultiFormatter;
import httl.spi.translators.templates.CompiledTemplate;
import httl.spi.translators.templates.OutputStreamTemplate;
import httl.spi.translators.templates.WriterTemplate;
import httl.util.ByteCache;
import httl.util.CharCache;
import httl.util.ClassUtils;
import httl.util.CollectionUtils;
import httl.util.IOUtils;
import httl.util.LinkedStack;
import httl.util.MapEntry;
import httl.util.OrderedMap;
import httl.util.ParameterizedTypeImpl;
import httl.util.Status;
import httl.util.StringCache;
import httl.util.StringSequence;
import httl.util.StringUtils;
import httl.util.VolatileReference;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledVisitor
extends AstVisitor {
    private LinkedStack<Type> typeStack = new LinkedStack();
    private LinkedStack<String> codeStack = new LinkedStack();
    private Map<String, Class<?>> variableTypes = new HashMap();
    private StringBuilder builder = new StringBuilder();
    private StringBuilder textFields = new StringBuilder();
    private String filterKey = null;
    private VolatileReference<Filter> filterReference = new VolatileReference();
    private Set<String> setVariables = new HashSet<String>();
    private Set<String> getVariables = new HashSet<String>();
    private List<String> defVariables = new ArrayList<String>();
    private List<Class<?>> defVariableTypes = new ArrayList();
    private Map<String, Class<?>> types = new HashMap();
    private Map<String, Class<?>> returnTypes = new HashMap();
    private Map<String, Class<?>> macros = new HashMap();
    private Resource resource;
    private Node node;
    private int offset;
    private boolean stream;
    private String engineName;
    private String[] forVariable;
    private String[] importGetters;
    private String[] importSizers;
    private String filterVariable;
    private String formatterVariable;
    private String defaultFilterVariable;
    private String defaultFormatterVariable;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private Filter templateFilter;
    private Filter textFilter;
    private Map<String, Template> importMacroTemplates = new ConcurrentHashMap<String, Template>();
    private String[] importPackages;
    private Set<String> importPackageSet;
    private Map<String, Class<?>> importTypes;
    private Map<Class<?>, Object> functions = new ConcurrentHashMap();
    private List<StringSequence> sequences = new CopyOnWriteArrayList<StringSequence>();
    private static final String TEMPLATE_CLASS_PREFIX = CompiledTemplate.class.getPackage().getName() + ".Template_";
    private final AtomicInteger seq = new AtomicInteger();
    private boolean sourceInClass;
    private boolean textInClass;
    private String outputEncoding;
    private Class<?> defaultVariableType;
    private Compiler compiler;

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    public void setImportSizers(String[] importSizers) {
        this.importSizers = importSizers;
    }

    public void setTypes(Map<String, Class<?>> types) {
        this.types = types;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setDefaultFilterVariable(String defaultFilterVariable) {
        this.defaultFilterVariable = defaultFilterVariable;
    }

    public void setDefaultFormatterVariable(String defaultFormatterVariable) {
        this.defaultFormatterVariable = defaultFormatterVariable;
    }

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setTemplateFilter(Filter templateFilter) {
        this.templateFilter = templateFilter;
    }

    public void setTextFilter(Filter textFilter) {
        this.textFilter = textFilter;
        this.filterReference.set(textFilter);
    }

    public void setImportMacroTemplates(Map<String, Template> importMacroTemplates) {
        this.importMacroTemplates = importMacroTemplates;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setImportPackageSet(Set<String> importPackageSet) {
        this.importPackageSet = importPackageSet;
    }

    public void setImportTypes(Map<String, Class<?>> importTypes) {
        this.importTypes = importTypes;
    }

    public void setImportMethods(Map<Class<?>, Object> functions) {
        this.functions = functions;
    }

    public void setImportSequences(List<StringSequence> sequences) {
        this.sequences = sequences;
    }

    public void setImportGetters(String[] importGetters) {
        this.importGetters = importGetters;
    }

    public void setSourceInClass(boolean sourceInClass) {
        this.sourceInClass = sourceInClass;
    }

    public void setTextInClass(boolean textInClass) {
        this.textInClass = textInClass;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setDefaultVariableType(Class<?> defaultVariableType) {
        this.defaultVariableType = defaultVariableType;
    }

    @Override
    public boolean visit(Statement node) throws IOException, ParseException {
        boolean result = super.visit(node);
        this.filterKey = node.toString();
        return result;
    }

    @Override
    public void visit(Text node) throws IOException, ParseException {
        String part;
        String txt = node.getContent();
        Filter filter = this.filterReference.get();
        if (this.textFilterSwitcher != null || this.valueFilterSwitcher != null || this.formatterSwitcher != null) {
            List<String> formatterLocations;
            List<String> valueLocations;
            List<String> textLocations;
            HashSet<String> locations = new HashSet<String>();
            List<String> list = textLocations = this.textFilterSwitcher == null ? null : this.textFilterSwitcher.locations();
            if (textLocations != null) {
                locations.addAll(textLocations);
            }
            List<String> list2 = valueLocations = this.valueFilterSwitcher == null ? null : this.valueFilterSwitcher.locations();
            if (valueLocations != null) {
                locations.addAll(valueLocations);
            }
            List<String> list3 = formatterLocations = this.formatterSwitcher == null ? null : this.formatterSwitcher.locations();
            if (formatterLocations != null) {
                locations.addAll(formatterLocations);
            }
            if (locations != null && locations.size() > 0) {
                TreeMap<Integer, HashSet<String>> switchesd = new TreeMap<Integer, HashSet<String>>();
                for (String location : locations) {
                    int i = -1;
                    while ((i = txt.indexOf(location, i + 1)) >= 0) {
                        Integer key = i;
                        HashSet<String> values = (HashSet<String>)switchesd.get(key);
                        if (values == null) {
                            values = new HashSet<String>();
                            switchesd.put(key, values);
                        }
                        values.add(location);
                    }
                }
                if (switchesd.size() > 0) {
                    this.getVariables.add(this.filterVariable);
                    int begin = 0;
                    for (Map.Entry entry : switchesd.entrySet()) {
                        int end = (Integer)entry.getKey();
                        String part2 = this.getTextPart(txt.substring(begin, end), filter, false);
                        if (StringUtils.isNotEmpty(part2)) {
                            this.builder.append("\t$output.write(" + part2 + ");\n");
                        }
                        begin = end;
                        for (String location : (Set)entry.getValue()) {
                            if (textLocations != null && textLocations.contains(location)) {
                                filter = this.textFilterSwitcher.switchover(location, this.textFilter);
                                this.filterReference.set(filter);
                            }
                            if (valueLocations != null && valueLocations.contains(location)) {
                                this.builder.append("\t" + this.filterVariable + " = switchFilter(\"" + StringUtils.escapeString(location) + "\", " + this.defaultFilterVariable + ");\n");
                            }
                            if (formatterLocations == null || !formatterLocations.contains(location)) continue;
                            this.builder.append("\t" + this.formatterVariable + " = switchFormatter(\"" + StringUtils.escapeString(location) + "\", " + this.defaultFormatterVariable + ");\n");
                        }
                    }
                    if (begin > 0) {
                        txt = txt.substring(begin);
                    }
                }
            }
        }
        if (StringUtils.isNotEmpty(part = this.getTextPart(txt, filter, false))) {
            this.builder.append("\t$output.write(" + part + ");\n");
        }
    }

    @Override
    public void visit(ValueDirective node) throws IOException, ParseException {
        boolean nofilter = node.isNoFilter();
        String code = this.popExpressionCode();
        Class<?> returnType = this.popExpressionReturnType();
        Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
        this.getVariables.addAll(variableTypes.keySet());
        if (Template.class.isAssignableFrom(returnType)) {
            if (!StringUtils.isNamed(code)) {
                code = "(" + code + ")";
            }
            this.builder.append("\tif (");
            this.builder.append(code);
            this.builder.append(" != null) ");
            this.builder.append(code);
            this.builder.append(".render($output);\n");
        } else if (nofilter && Resource.class.isAssignableFrom(returnType)) {
            if (!StringUtils.isNamed(code)) {
                code = "(" + code + ")";
            }
            this.builder.append("\t");
            this.builder.append(IOUtils.class.getName());
            this.builder.append(".copy(");
            this.builder.append(code);
            if (this.stream) {
                this.builder.append(".openStream()");
            } else {
                this.builder.append(".openReader()");
            }
            this.builder.append(", $output);\n");
        } else {
            if (Object.class.equals(returnType)) {
                if (!StringUtils.isNamed(code)) {
                    code = "(" + code + ")";
                }
                this.builder.append("\tif (");
                this.builder.append(code);
                this.builder.append(" instanceof ");
                this.builder.append(Template.class.getName());
                this.builder.append(") {\n\t((");
                this.builder.append(Template.class.getName());
                this.builder.append(")");
                this.builder.append(code);
                this.builder.append(").render($output);\n\t}");
                if (nofilter) {
                    this.builder.append(" else if (");
                    this.builder.append(code);
                    this.builder.append(" instanceof ");
                    this.builder.append(Resource.class.getName());
                    this.builder.append(") {\n\t");
                    this.builder.append(IOUtils.class.getName());
                    this.builder.append(".copy(((");
                    this.builder.append(Resource.class.getName());
                    this.builder.append(")");
                    this.builder.append(code);
                    if (this.stream) {
                        this.builder.append(").openStream()");
                    } else {
                        this.builder.append(").openReader()");
                    }
                    this.builder.append(", $output);\n\t}");
                } else {
                    code = "(" + code + " instanceof " + Resource.class.getName() + " ? " + IOUtils.class.getName() + ".readToString(((" + Resource.class.getName() + ")" + code + ").openReader()) : " + code + ")";
                }
                this.builder.append(" else {\n");
            } else if (Resource.class.isAssignableFrom(returnType)) {
                if (!StringUtils.isNamed(code)) {
                    code = "(" + code + ")";
                }
                code = "(" + code + " == null ? null : " + IOUtils.class.getName() + ".readToString(" + code + ".openReader()))";
            }
            this.getVariables.add(this.formatterVariable);
            String key = this.getTextPart(node.getExpression().toString(), null, true);
            if (!this.stream && Object.class.equals(returnType)) {
                String pre = "";
                String var = "$obj" + this.seq.getAndIncrement();
                pre = "\tObject " + var + " = " + code + ";\n";
                String charsCode = "formatter.toChars(" + key + ", (char[]) " + var + ")";
                code = "formatter.toString(" + key + ", " + var + ")";
                if (!nofilter) {
                    this.getVariables.add(this.filterVariable);
                    charsCode = "doFilter(" + this.filterVariable + ", " + key + ", " + charsCode + ")";
                    code = "doFilter(" + this.filterVariable + ", " + key + ", " + code + ")";
                }
                this.builder.append(pre);
                this.builder.append("\tif (" + var + " instanceof char[]) $output.write(");
                this.builder.append(charsCode);
                this.builder.append("); else $output.write(");
                this.builder.append(code);
                this.builder.append(");\n");
            } else {
                code = this.stream ? "formatter.toBytes(" + key + ", " + code + ")" : (char[].class.equals(returnType) ? "formatter.toChars(" + key + ", " + code + ")" : "formatter.toString(" + key + ", " + code + ")");
                if (!nofilter) {
                    this.getVariables.add(this.filterVariable);
                    code = "doFilter(" + this.filterVariable + ", " + key + ", " + code + ")";
                }
                this.builder.append("\t$output.write(");
                this.builder.append(code);
                this.builder.append(");\n");
            }
            if (Object.class.equals(returnType)) {
                this.builder.append("\t}\n");
            }
        }
    }

    @Override
    public void visit(SetDirective node) throws IOException, ParseException {
        Type type = node.getType();
        Class<?> clazz = (Class<?>)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        if (node.getExpression() != null) {
            String code = this.popExpressionCode();
            Class<?> returnType = this.popExpressionReturnType();
            Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
            if (clazz == null) {
                clazz = returnType;
            }
            this.appendVar(clazz, node.getName(), code, node.isExport(), node.isHide(), node.getType() != null, node.getOffset());
            this.getVariables.addAll(variableTypes.keySet());
        } else {
            clazz = this.checkVar(clazz, node.getName(), node.getOffset());
            this.types.put(node.getName(), clazz);
            if (type instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)type).getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Class arg = (Class)(args[i] instanceof ParameterizedType ? ((ParameterizedType)args[i]).getRawType() : args[i]);
                    this.types.put(node.getName() + ":" + i, arg);
                }
            }
            this.defVariables.add(node.getName());
            this.defVariableTypes.add(clazz);
        }
    }

    private Class<?> checkVar(Class<?> clazz, String var, int offset) throws IOException, ParseException {
        Class<?> cls = this.types.get(var);
        if (!(cls == null || cls.equals(clazz) || cls.isAssignableFrom(clazz) || clazz.isAssignableFrom(cls))) {
            throw new ParseException("Defined different type variable " + var + ", conflict types: " + cls.getCanonicalName() + ", " + clazz.getCanonicalName() + ".", offset);
        }
        if (cls != null && clazz.isAssignableFrom(cls)) {
            return cls;
        }
        return clazz;
    }

    private void appendVar(Class<?> clazz, String var, String code, boolean parent, boolean hide, boolean def, int offset) throws IOException, ParseException {
        clazz = this.checkVar(clazz, var, offset);
        String type = clazz.getCanonicalName();
        if (def || this.types.get(var) == null) {
            this.types.put(var, clazz);
        }
        this.setVariables.add(var);
        this.builder.append("\t" + var + " = (" + type + ")(" + code + ");\n");
        String ctx = null;
        if (parent) {
            ctx = "($context.getParent() != null ? $context.getParent() : $context)";
            this.returnTypes.put(var, clazz);
        } else if (!hide) {
            ctx = "$context";
        }
        if (StringUtils.isNotEmpty(ctx)) {
            this.builder.append("\t" + ctx + ".put(\"");
            this.builder.append(var);
            this.builder.append("\", ");
            this.builder.append(ClassUtils.class.getName() + ".boxed(" + var + ")");
            this.builder.append(");\n");
        }
    }

    @Override
    public boolean visit(IfDirective node) throws IOException, ParseException {
        String code = this.popExpressionCode();
        Class<?> returnType = this.popExpressionReturnType();
        Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
        this.builder.append("\tif(");
        this.builder.append(StringUtils.getConditionCode(returnType, code, this.importSizers));
        this.builder.append(") {\n");
        this.getVariables.addAll(variableTypes.keySet());
        return true;
    }

    @Override
    public void end(IfDirective node) throws IOException, ParseException {
        this.builder.append("\t}\n");
    }

    @Override
    public boolean visit(ElseDirective node) throws IOException, ParseException {
        if (node.getExpression() == null) {
            this.builder.append("\telse {\n");
        } else {
            String code = this.popExpressionCode();
            Class<?> returnType = this.popExpressionReturnType();
            Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
            this.builder.append("\telse if (");
            this.builder.append(StringUtils.getConditionCode(returnType, code, this.importSizers));
            this.builder.append(") {\n");
            this.getVariables.addAll(variableTypes.keySet());
        }
        return true;
    }

    @Override
    public void end(ElseDirective node) throws IOException, ParseException {
        this.builder.append("\t}\n");
    }

    @Override
    public boolean visit(ForDirective node) throws IOException, ParseException {
        String var = node.getName();
        Type type = node.getType();
        Class<Object> clazz = (Class<?>)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        String code = this.popExpressionCode();
        Class<?> returnType = this.popExpressionReturnType();
        Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
        String exprName = CompiledVisitor.getGenericVariableName(node.getExpression());
        if (clazz == null) {
            if (returnType.isArray()) {
                clazz = returnType.getComponentType();
            } else if (Map.class.isAssignableFrom(returnType)) {
                clazz = Map.Entry.class;
            } else if (Collection.class.isAssignableFrom(returnType)) {
                clazz = this.types.get(exprName + ":0");
            }
            if (clazz == null) {
                if (this.defaultVariableType == null) {
                    throw new ParseException("Can not resolve the variable " + node.getName() + " type in the #for directive. Please explicit define the variable type #for(Xxx " + node.getName() + " : " + node.getExpression() + ") in your template.", node.getOffset());
                }
                clazz = this.defaultVariableType;
            }
        }
        if (Map.class.isAssignableFrom(returnType)) {
            Class<?> valueType;
            Class<?> keyType = this.types.get(exprName + ":0");
            if (keyType != null) {
                this.types.put(var + ":0", keyType);
            }
            if ((valueType = this.types.get(exprName + ":1")) != null) {
                this.types.put(var + ":1", valueType);
            }
            code = ClassUtils.class.getName() + ".entrySet(" + code + ")";
        }
        int i = this.seq.incrementAndGet();
        String dataName = "_d_" + i;
        String sizeName = "_s_" + i;
        String name = "_i_" + var;
        this.builder.append("\t" + Object.class.getSimpleName() + " " + dataName + " = " + code + ";\n");
        this.builder.append("\tint " + sizeName + " = " + ClassUtils.class.getName() + ".getSize(" + dataName + ");\n");
        this.builder.append("\tif (" + dataName + " != null && " + sizeName + " != 0) {\n");
        this.builder.append("\t");
        for (String fv : this.forVariable) {
            this.builder.append(ClassUtils.filterJavaKeyword(fv));
            this.builder.append(" = ");
        }
        this.builder.append("new " + Status.class.getName() + "(" + ClassUtils.filterJavaKeyword(this.forVariable[0]) + ", " + dataName + ", " + sizeName + ");\n");
        this.builder.append("\tfor (" + Iterator.class.getName() + " " + name + " = " + CollectionUtils.class.getName() + ".toIterator(" + dataName + "); " + name + ".hasNext();) {\n");
        String varCode = clazz.isPrimitive() ? ClassUtils.class.getName() + ".unboxed((" + ClassUtils.getBoxedClass(clazz).getSimpleName() + ")" + name + ".next())" : name + ".next()";
        this.appendVar(clazz, var, varCode, false, false, node.getType() != null, node.getOffset());
        this.getVariables.addAll(variableTypes.keySet());
        for (String fv : this.forVariable) {
            this.setVariables.add(fv);
        }
        return true;
    }

    @Override
    public void end(ForDirective node) throws IOException, ParseException {
        this.builder.append("\t" + ClassUtils.filterJavaKeyword(this.forVariable[0]) + ".increment();\n\t}\n\t");
        for (String fv : this.forVariable) {
            this.builder.append(ClassUtils.filterJavaKeyword(fv));
            this.builder.append(" = ");
        }
        this.builder.append(ClassUtils.filterJavaKeyword(this.forVariable[0]) + ".getParent();\n\t}\n");
    }

    @Override
    public void visit(BreakDirective node) throws IOException, ParseException {
        String b;
        String string = b = node.getParent() instanceof ForDirective ? "break" : "return";
        if (node.getExpression() == null) {
            if (!(node.getParent() instanceof IfDirective) && !(node.getParent() instanceof ElseDirective)) {
                throw new ParseException("Can not #break without condition. Please use #break(condition) or #if(condition) #break #end.", node.getOffset());
            }
            this.builder.append("\t" + b + ";\n");
        } else {
            String code = this.popExpressionCode();
            Class<?> returnType = this.popExpressionReturnType();
            Map<String, Class<?>> variableTypes = this.popExpressionVariableTypes();
            this.builder.append("\tif(");
            this.builder.append(StringUtils.getConditionCode(returnType, code, this.importSizers));
            this.builder.append(") " + b + ";\n");
            this.getVariables.addAll(variableTypes.keySet());
        }
    }

    @Override
    public boolean visit(MacroDirective node) throws IOException, ParseException {
        this.types.put(node.getName(), Template.class);
        CompiledVisitor visitor = new CompiledVisitor();
        visitor.setResource(this.resource);
        visitor.setNode(node);
        visitor.setStream(this.stream);
        visitor.setOffset(this.offset);
        visitor.setDefaultFilterVariable(this.defaultFilterVariable);
        visitor.setDefaultFormatterVariable(this.defaultFormatterVariable);
        visitor.setDefaultVariableType(this.defaultVariableType);
        visitor.setEngineName(this.engineName);
        visitor.setFilterVariable(this.filterVariable);
        visitor.setFormatterSwitcher(this.formatterSwitcher);
        visitor.setFormatterVariable(this.formatterVariable);
        visitor.setForVariable(this.forVariable);
        visitor.setImportMacroTemplates(this.importMacroTemplates);
        visitor.setImportPackages(this.importPackages);
        visitor.setImportPackageSet(this.importPackageSet);
        visitor.setImportSizers(this.importSizers);
        visitor.setImportGetters(this.importGetters);
        visitor.setImportTypes(this.importTypes);
        visitor.setImportMethods(this.functions);
        visitor.setOutputEncoding(this.outputEncoding);
        visitor.setSourceInClass(this.sourceInClass);
        visitor.setTemplateFilter(this.templateFilter);
        visitor.setTextFilter(this.textFilter);
        visitor.setTextFilterSwitcher(this.textFilterSwitcher);
        visitor.setTextInClass(this.textInClass);
        visitor.setValueFilterSwitcher(this.valueFilterSwitcher);
        visitor.setCompiler(this.compiler);
        visitor.init();
        for (Node n : node.getChildren()) {
            n.accept(visitor);
        }
        Class<?> macroType = visitor.compile();
        this.macros.put(node.getName(), macroType);
        return false;
    }

    public void init() {
        if (this.types == null) {
            this.types = new HashMap();
        }
        if (this.importTypes != null && this.importTypes.size() > 0) {
            this.types.putAll(this.importTypes);
        }
        this.types.put("this", Template.class);
        this.types.put("super", Template.class);
        this.types.put(this.defaultFilterVariable, Filter.class);
        this.types.put(this.filterVariable, Filter.class);
        this.types.put(this.defaultFormatterVariable, Formatter.class);
        this.types.put(this.formatterVariable, Formatter.class);
        for (String fv : this.forVariable) {
            this.types.put(fv, Status.class);
        }
        for (String macro : this.importMacroTemplates.keySet()) {
            this.types.put(macro, Template.class);
        }
    }

    public Class<?> compile() throws IOException, ParseException {
        String code = this.getCode();
        return this.compiler.compile(code);
    }

    /*
     * WARNING - void declaration
     */
    private String getCode() throws IOException, ParseException {
        Class<?> type;
        String name = this.getTemplateClassName(this.resource, this.node, this.stream);
        String code = this.builder.toString();
        int i = name.lastIndexOf(46);
        String packageName = i < 0 ? "" : name.substring(0, i);
        String className = i < 0 ? name : name.substring(i + 1);
        StringBuilder imports = new StringBuilder();
        String[] packages = this.importPackages;
        if (packages != null && packages.length > 0) {
            for (String pkg : packages) {
                imports.append("import ");
                imports.append(pkg);
                imports.append(".*;\n");
            }
        }
        HashSet<String> defined = new HashSet<String>();
        StringBuilder statusInit = new StringBuilder();
        StringBuilder macroFields = new StringBuilder();
        StringBuilder macroInits = new StringBuilder();
        StringBuilder declare = new StringBuilder();
        if (this.getVariables.contains("this")) {
            defined.add("this");
            declare.append("\t" + Template.class.getName() + " " + ClassUtils.filterJavaKeyword("this") + " = this;\n");
        }
        if (this.getVariables.contains("super")) {
            defined.add("super");
            declare.append("\t" + Template.class.getName() + " " + ClassUtils.filterJavaKeyword("super") + " = ($context.getParent() == null ? null : $context.getParent().getTemplate());\n");
        }
        if (this.getVariables.contains(this.filterVariable)) {
            defined.add(this.filterVariable);
            defined.add(this.defaultFilterVariable);
            declare.append("\t" + Filter.class.getName() + " " + this.defaultFilterVariable + " = getFilter($context, \"" + this.filterVariable + "\");\n");
            declare.append("\t" + Filter.class.getName() + " " + this.filterVariable + " = " + this.defaultFilterVariable + ";\n");
        }
        if (this.getVariables.contains(this.formatterVariable)) {
            defined.add(this.formatterVariable);
            defined.add(this.defaultFormatterVariable);
            declare.append("\t" + MultiFormatter.class.getName() + " " + this.defaultFormatterVariable + " = getFormatter($context, \"" + this.formatterVariable + "\");\n");
            declare.append("\t" + MultiFormatter.class.getName() + " " + this.formatterVariable + " = " + this.defaultFormatterVariable + ";\n");
        }
        for (String var : this.defVariables) {
            void var15_17;
            if (!this.getVariables.contains(var) || defined.contains(var)) continue;
            Class<?> clazz = this.types.get(var);
            if (clazz == null) {
                Class<?> clazz2 = this.defaultVariableType;
            }
            defined.add(var);
            declare.append(this.getTypeCode((Class<?>)var15_17, var));
        }
        Set<String> macroKeySet = this.macros.keySet();
        for (String string : macroKeySet) {
            this.types.put(string, Template.class);
            if (!this.getVariables.contains(string) || defined.contains(string)) continue;
            defined.add(string);
            macroFields.append("private final " + Template.class.getName() + " " + string + ";\n");
            macroInits.append("\t" + string + " = getMacros().get(\"" + string + "\");\n");
            declare.append("\t" + Template.class.getName() + " " + string + " = getMacro($context, \"" + string + "\", this." + string + ");\n");
        }
        if (this.importTypes != null && this.importTypes.size() > 0) {
            for (Map.Entry entry : this.importTypes.entrySet()) {
                String var = (String)entry.getKey();
                if (!this.getVariables.contains(var) || defined.contains(var)) continue;
                defined.add(var);
                declare.append(this.getTypeCode((Class)entry.getValue(), var));
            }
        }
        for (String string : this.importMacroTemplates.keySet()) {
            if (!this.getVariables.contains(string) || defined.contains(string)) continue;
            defined.add(string);
            macroFields.append("private final " + Template.class.getName() + " " + string + ";\n");
            macroInits.append("\t" + string + " = getImportMacros().get(\"" + string + "\");\n");
            declare.append("\t" + Template.class.getName() + " " + string + " = getMacro($context, \"" + string + "\", this." + string + ");\n");
        }
        for (String string : this.setVariables) {
            if (defined.contains(string)) continue;
            defined.add(string);
            type = this.types.get(string);
            String typeName = this.getTypeName(type);
            declare.append("\t" + typeName + " " + ClassUtils.filterJavaKeyword(string) + " = " + ClassUtils.getInitCode(type) + ";\n");
        }
        for (String string : this.getVariables) {
            if (defined.contains(string)) continue;
            type = this.types.get(string);
            if (type == null) {
                type = this.defaultVariableType;
            }
            defined.add(string);
            declare.append(this.getTypeCode(type, string));
            this.defVariables.add(string);
            this.defVariableTypes.add(type);
        }
        StringBuilder funtionFileds = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Class<?>, Object> function : this.functions.entrySet()) {
            Class<?> functionType = function.getKey();
            if (function.getValue() instanceof Class) continue;
            String pkgName = functionType.getPackage() == null ? null : functionType.getPackage().getName();
            String typeName = pkgName != null && ("java.lang".equals(pkgName) || this.importPackageSet != null && this.importPackageSet.contains(pkgName)) ? functionType.getSimpleName() : functionType.getCanonicalName();
            funtionFileds.append("private final ");
            funtionFileds.append(typeName);
            funtionFileds.append(" $");
            funtionFileds.append(functionType.getName().replace('.', '_'));
            funtionFileds.append(";\n");
            stringBuilder.append("\tthis.$");
            stringBuilder.append(functionType.getName().replace('.', '_'));
            stringBuilder.append(" = (");
            stringBuilder.append(typeName);
            stringBuilder.append(") functions.get(");
            stringBuilder.append(typeName);
            stringBuilder.append(".class);\n");
        }
        String methodCode = statusInit.toString() + declare + code;
        this.textFields.append("private static final " + Map.class.getName() + " $VARS = " + this.toTypeCode(this.defVariables, this.defVariableTypes) + ";\n");
        String templateName = this.resource.getName();
        Node macro = this.node;
        while (macro instanceof MacroDirective) {
            templateName = templateName + "#" + ((MacroDirective)macro).getName();
            macro = ((MacroDirective)macro).getParent();
        }
        String sorceCode = "package " + packageName + ";\n" + "\n" + imports.toString() + "\n" + "public final class " + className + " extends " + (this.stream ? OutputStreamTemplate.class.getName() : WriterTemplate.class.getName()) + " {\n" + "\n" + this.textFields + "\n" + funtionFileds + "\n" + macroFields + "\n" + "public " + className + "(" + Engine.class.getName() + " engine, " + Interceptor.class.getName() + " interceptor, " + Compiler.class.getName() + " compiler, " + Switcher.class.getName() + " filterSwitcher, " + Switcher.class.getName() + " formatterSwitcher, " + Filter.class.getName() + " filter, " + Formatter.class.getName() + " formatter, " + Converter.class.getName() + " mapConverter, " + Converter.class.getName() + " outConverter, " + Map.class.getName() + " functions, " + Map.class.getName() + " importMacros, " + Resource.class.getName() + " resource, " + Template.class.getName() + " parent, " + Node.class.getName() + " root) {\n" + "\tsuper(engine, interceptor, compiler, filterSwitcher, formatterSwitcher, filter, formatter, mapConverter, outConverter, functions, importMacros, resource, parent, root);\n" + stringBuilder + macroInits + "}\n" + "\n" + "protected void doRender" + (this.stream ? "Stream" : "Writer") + "(" + Context.class.getName() + " $context, " + (this.stream ? OutputStream.class.getName() : Writer.class.getName()) + " $output) throws " + Exception.class.getName() + " {\n" + methodCode + "}\n" + "\n" + "public " + String.class.getSimpleName() + " getName() {\n" + "\treturn \"" + templateName + "\";\n" + "}\n" + "\n" + "public " + Map.class.getName() + " getVariables() {\n" + "\treturn $VARS;\n" + "}\n" + "\n" + "protected " + Map.class.getName() + " getMacroTypes() {\n" + "\treturn " + this.toTypeCode(this.macros) + ";\n" + "}\n" + "\n" + "public boolean isMacro() {\n" + "\treturn " + (this.node instanceof MacroDirective) + ";\n" + "}\n" + "\n" + "public int getOffset() {\n" + "\treturn " + this.offset + ";\n" + "}\n" + "\n" + "}\n";
        return sorceCode;
    }

    private String getTypeName(Class<?> type) {
        return type.getCanonicalName();
    }

    private String getTypeCode(Class<?> type, String var) {
        String typeName = this.getTypeName(type);
        if (type.isPrimitive()) {
            return "\t" + typeName + " " + ClassUtils.filterJavaKeyword(var) + " = " + ClassUtils.class.getName() + ".unboxed((" + ClassUtils.getBoxedClass(type).getSimpleName() + ") $context.get(\"" + var + "\"));\n";
        }
        return "\t" + typeName + " " + ClassUtils.filterJavaKeyword(var) + " = (" + typeName + ") $context.get(\"" + var + "\");\n";
    }

    private String toTypeCode(Map<String, Class<?>> types) {
        StringBuilder keyBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        if (types == null || types.size() == 0) {
            keyBuf.append("new String[0]");
            valueBuf.append("new Class[0]");
        } else {
            keyBuf.append("new String[] {");
            valueBuf.append("new Class[] {");
            boolean first = true;
            for (Map.Entry<String, Class<?>> entry : types.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    keyBuf.append(", ");
                    valueBuf.append(", ");
                }
                keyBuf.append("\"");
                keyBuf.append(StringUtils.escapeString(entry.getKey()));
                keyBuf.append("\"");
                valueBuf.append(entry.getValue().getCanonicalName());
                valueBuf.append(".class");
            }
            keyBuf.append("}");
            valueBuf.append("}");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(OrderedMap.class.getName());
        buf.append("(");
        buf.append((CharSequence)keyBuf);
        buf.append(", ");
        buf.append((CharSequence)valueBuf);
        buf.append(")");
        return buf.toString();
    }

    private String toTypeCode(List<String> names, List<Class<?>> types) {
        boolean first;
        StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(OrderedMap.class.getName());
        buf.append("(");
        if (names == null || names.size() == 0) {
            buf.append("new String[0]");
        } else {
            buf.append("new String[] {");
            first = true;
            for (String string : names) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append("\"");
                buf.append(StringUtils.escapeString(string));
                buf.append("\"");
            }
            buf.append("}");
        }
        buf.append(", ");
        if (names == null || names.size() == 0) {
            buf.append("new Class[0]");
        } else {
            buf.append("new Class[] {");
            first = true;
            for (Class clazz : types) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(clazz.getCanonicalName());
                buf.append(".class");
            }
            buf.append("}");
        }
        buf.append(")");
        return buf.toString();
    }

    private String getTemplateClassName(Resource resource, Node node, boolean stream) {
        String name = resource.getName();
        String encoding = resource.getEncoding();
        Locale locale = resource.getLocale();
        long lastModified = resource.getLastModified();
        StringBuilder buf = new StringBuilder(name.length() + 40);
        buf.append(name);
        Node macro = node;
        while (macro instanceof MacroDirective) {
            buf.append("_");
            buf.append(((MacroDirective)macro).getName());
            macro = ((MacroDirective)macro).getParent();
        }
        if (StringUtils.isNotEmpty(this.engineName)) {
            buf.append("_");
            buf.append(this.engineName);
        }
        if (StringUtils.isNotEmpty(encoding)) {
            buf.append("_");
            buf.append(encoding);
        }
        if (locale != null) {
            buf.append("_");
            buf.append(locale);
        }
        if (lastModified > 0L) {
            buf.append("_");
            buf.append(lastModified);
        }
        buf.append(stream ? "_stream" : "_writer");
        return TEMPLATE_CLASS_PREFIX + StringUtils.getVaildName(buf.toString());
    }

    private String getTextPart(String txt, Filter filter, boolean string) {
        if (StringUtils.isNotEmpty(txt)) {
            if (filter != null) {
                txt = filter.filter(this.filterKey, txt);
            }
            String var = "$TXT" + this.seq.incrementAndGet();
            if (string) {
                if (this.textInClass) {
                    this.textFields.append("private static final String " + var + " = \"" + StringUtils.escapeString(txt) + "\";\n");
                } else {
                    String txtId = StringCache.put(txt);
                    this.textFields.append("private static final String " + var + " = " + StringCache.class.getName() + ".getAndRemove(\"" + txtId + "\");\n");
                }
            } else if (this.stream) {
                if (this.textInClass) {
                    this.textFields.append("private static final byte[] " + var + " = new byte[] {" + StringUtils.toByteString(StringUtils.toBytes(txt, this.outputEncoding)) + "};\n");
                } else {
                    String txtId = ByteCache.put(StringUtils.toBytes(txt, this.outputEncoding));
                    this.textFields.append("private static final byte[] " + var + " = " + ByteCache.class.getName() + ".getAndRemove(\"" + txtId + "\");\n");
                }
            } else if (this.textInClass) {
                this.textFields.append("private static final char[] " + var + " = new char[] {" + StringUtils.toCharString(txt.toCharArray()) + "};\n");
            } else {
                String txtId = CharCache.put(txt.toCharArray());
                this.textFields.append("private static final char[] " + var + " = " + CharCache.class.getName() + ".getAndRemove(\"" + txtId + "\");\n");
            }
            return var;
        }
        return "";
    }

    private String popExpressionCode() {
        String code = this.codeStack.pop();
        if (!this.codeStack.isEmpty()) {
            throw new IllegalStateException("Illegal expression.");
        }
        return code;
    }

    private Class<?> popExpressionReturnType() {
        Type type = this.typeStack.pop();
        if (!this.typeStack.isEmpty()) {
            throw new IllegalStateException("Illegal expression.");
        }
        return (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
    }

    private Map<String, Class<?>> popExpressionVariableTypes() {
        Map<String, Class<?>> types = this.variableTypes;
        this.variableTypes = new HashMap();
        return types;
    }

    @Override
    public void visit(Constant node) throws IOException, ParseException {
        String code;
        Class<Object> type;
        Object value = node.getValue();
        if (value == null) {
            type = node.isBoxed() ? Void.TYPE : null;
            code = node.isBoxed() ? "" : "null";
        } else if (value.equals(Boolean.TRUE)) {
            type = node.isBoxed() ? Boolean.class : Boolean.TYPE;
            code = node.isBoxed() ? "Boolean.TRUE" : "true";
        } else if (value.equals(Boolean.FALSE)) {
            type = node.isBoxed() ? Boolean.class : Boolean.TYPE;
            code = node.isBoxed() ? "Boolean.FALSE" : "false";
        } else if (value instanceof String) {
            type = String.class;
            code = "\"" + StringUtils.escapeString((String)value) + "\"";
        } else if (value instanceof Character) {
            type = node.isBoxed() ? Character.class : Character.TYPE;
            code = node.isBoxed() ? "Character.valueOf('" + StringUtils.escapeString(String.valueOf(value)) + "')" : "'" + StringUtils.escapeString(String.valueOf(value)) + "'";
        } else if (value instanceof Double) {
            type = node.isBoxed() ? Double.class : Double.TYPE;
            code = node.isBoxed() ? "Double.valueOf(" + value + "d)" : value + "d";
        } else if (value instanceof Float) {
            type = node.isBoxed() ? Float.class : Float.TYPE;
            code = node.isBoxed() ? "Float.valueOf(" + value + "f)" : value + "f";
        } else if (value instanceof Long) {
            type = node.isBoxed() ? Long.class : Long.TYPE;
            code = node.isBoxed() ? "Long.valueOf(" + value + "l)" : value + "l";
        } else if (value instanceof Short) {
            type = node.isBoxed() ? Short.class : Short.TYPE;
            code = node.isBoxed() ? "Short.valueOf((short)" + value + ")" : "((short)" + value + ")";
        } else if (value instanceof Byte) {
            type = node.isBoxed() ? Byte.class : Byte.TYPE;
            code = node.isBoxed() ? "Byte.valueOf((byte)" + value + ")" : "((byte)" + value + ")";
        } else if (value instanceof Integer) {
            type = node.isBoxed() ? Integer.class : Integer.TYPE;
            code = node.isBoxed() ? "Integer.valueOf(" + value + ")" : String.valueOf(value);
        } else if (value instanceof Class) {
            type = node.isBoxed() ? ClassUtils.getBoxedClass((Class)value) : (Class<?>)value;
            code = ((Class)value).getCanonicalName();
        } else {
            throw new ParseException("Unsupported constant " + value, node.getOffset());
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(Variable node) throws IOException, ParseException {
        String name = node.getName();
        Class<?> type = this.types.get(name);
        if (type == null) {
            if (this.defaultVariableType == null) {
                throw new ParseException("Can not resolve the " + node.getName() + " variable type. Please explicit define the variable type #set(Xxx " + node.getName() + ") in your template.", node.getOffset());
            }
            type = this.defaultVariableType;
        }
        String code = ClassUtils.filterJavaKeyword(name);
        this.typeStack.push(type);
        this.codeStack.push(code);
        this.variableTypes.put(name, type);
    }

    @Override
    public void visit(PositiveOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Type type = parameterType;
        String code = parameterCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(NegativeOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Class parameterClass = (Class)(parameterType instanceof ParameterizedType ? ((ParameterizedType)parameterType).getRawType() : parameterType);
        String name = node.getName();
        Class type = parameterClass;
        String code = node.getParameter() instanceof Operator && ((Operator)node.getParameter()).getPriority() < node.getPriority() ? name + " (" + parameterCode + ")" : name + " " + parameterCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(NotOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Class parameterClass = (Class)(parameterType instanceof ParameterizedType ? ((ParameterizedType)parameterType).getRawType() : parameterType);
        Class<Boolean> type = Boolean.TYPE;
        String code = "! (" + StringUtils.getConditionCode(parameterClass, parameterCode, this.importSizers) + ")";
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(BitNotOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Class parameterClass = (Class)(parameterType instanceof ParameterizedType ? ((ParameterizedType)parameterType).getRawType() : parameterType);
        String name = node.getName();
        Class type = parameterClass;
        String code = node.getParameter() instanceof Operator && ((Operator)node.getParameter()).getPriority() < node.getPriority() ? name + " (" + parameterCode + ")" : name + " " + parameterCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(ListOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Class parameterClass = (Class)(parameterType instanceof ParameterizedType ? ((ParameterizedType)parameterType).getRawType() : parameterType);
        Class type = null;
        String code = null;
        if (parameterType instanceof ParameterizedType) {
            parameterClass = (Class)((ParameterizedType)parameterType).getActualTypeArguments()[0];
        }
        if (Map.Entry.class.isAssignableFrom(parameterClass)) {
            type = Map.class;
            code = CollectionUtils.class.getName() + ".toMap(new " + Map.Entry.class.getCanonicalName() + "[] {" + parameterCode + "})";
        } else {
            type = Array.newInstance(parameterClass, 0).getClass();
            code = "new " + parameterClass.getCanonicalName() + "[] {" + parameterCode + "}";
        }
        this.typeStack.push((Type)((Object)type));
        this.codeStack.push(code);
    }

    @Override
    public void visit(NewOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        String name = node.getName();
        Class<?> type = ClassUtils.forName(this.importPackages, name);
        String code = "new " + name + "(" + parameterCode + ")";
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(StaticMethodOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        Class parameterClass = (Class)(parameterType instanceof ParameterizedType ? ((ParameterizedType)parameterType).getRawType() : parameterType);
        String name = node.getName();
        Class type = null;
        String code = null;
        Class[] parameterTypes = parameterType instanceof ParameterizedType ? (Class[])((ParameterizedType)parameterType).getActualTypeArguments() : (parameterClass == Void.TYPE ? new Class[]{} : new Class[]{parameterClass});
        Class<?> t = this.types.get(name);
        if (t != null && Template.class.isAssignableFrom(t)) {
            this.variableTypes.put(name, Template.class);
            type = Object.class;
            code = "(" + name + " == null ? null : " + name + ".evaluate(new Object" + (parameterCode.length() == 0 ? "[0]" : "[] { " + parameterCode + " }") + "))";
        } else {
            name = ClassUtils.filterJavaKeyword(name);
            type = null;
            code = null;
            if (this.functions != null && this.functions.size() > 0) {
                for (Class<?> function : this.functions.keySet()) {
                    try {
                        Method method = ClassUtils.searchMethod(function, name, parameterTypes, parameterTypes.length == 1);
                        if (Object.class.equals(method.getDeclaringClass())) break;
                        type = method.getReturnType();
                        if (type == Void.TYPE) {
                            throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                        }
                        Class<?>[] pts = method.getParameterTypes();
                        if (parameterTypes.length == 1 && parameterTypes[0].isPrimitive() && pts[0].isAssignableFrom(ClassUtils.getBoxedClass(parameterTypes[0]))) {
                            parameterCode = ClassUtils.class.getName() + ".boxed(" + parameterCode + ")";
                        }
                        if (Modifier.isStatic(method.getModifiers())) {
                            code = function.getName() + "." + method.getName() + "(" + parameterCode + ")";
                            break;
                        }
                        code = "$" + function.getName().replace('.', '_') + "." + method.getName() + "(" + parameterCode + ")";
                        break;
                    }
                    catch (NoSuchMethodException e) {
                    }
                }
            }
            if (code == null) {
                throw new ParseException("No such macro \"" + name + "\" or import method " + ClassUtils.getMethodFullName(name, parameterTypes) + ".", node.getOffset());
            }
        }
        this.typeStack.push((Type)((Object)type));
        this.codeStack.push(code);
    }

    @Override
    public void visit(CastOperator node) throws IOException, ParseException {
        Type parameterType = this.typeStack.pop();
        String parameterCode = this.codeStack.pop();
        String name = node.getName();
        Class<?> type = ClassUtils.forName(this.importPackages, name);
        String code = parameterCode;
        if (!type.equals(parameterType)) {
            code = "(" + name + ")(" + parameterCode + ")";
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(AddOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = null;
        String code = null;
        boolean nullable = true;
        if ((Collection.class.isAssignableFrom(leftClass) || leftClass.isArray()) && (Collection.class.isAssignableFrom(rightClass) || rightClass.isArray()) || Map.class.isAssignableFrom(leftClass) && Map.class.isAssignableFrom(rightClass)) {
            code = CollectionUtils.class.getName() + ".merge(" + leftCode + ", " + rightCode + ")";
            type = leftType;
            nullable = false;
        } else if (rightClass.isPrimitive() && rightType != Boolean.TYPE) {
            type = rightClass;
            nullable = false;
        } else if (leftClass.isPrimitive() && leftClass != Boolean.TYPE) {
            type = leftClass;
            nullable = false;
        } else {
            type = String.class;
        }
        if (type != String.class) {
            Class clazz = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type;
            String typeName = clazz.getCanonicalName();
            typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
            if (!leftClass.isPrimitive() || leftClass == Boolean.TYPE) {
                leftCode = ClassUtils.class.getName() + ".to" + typeName + "(" + leftCode + ")";
                nullable = false;
            }
            if (!rightClass.isPrimitive() || leftClass == Boolean.TYPE) {
                rightCode = ClassUtils.class.getName() + ".to" + typeName + "(" + rightCode + ")";
                nullable = false;
            }
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        if (code == null) {
            code = nullable && type == String.class && !leftClass.isPrimitive() && !rightClass.isPrimitive() ? StringUtils.class.getName() + ".concat(" + leftCode + ", " + rightCode + ")" : leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(SubOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class type = rightClass.isPrimitive() && rightType != Boolean.TYPE ? rightClass : (leftClass.isPrimitive() && leftClass != Boolean.TYPE ? leftClass : Integer.TYPE);
        Class clazz = type;
        String typeName = clazz.getCanonicalName();
        typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        if (!leftClass.isPrimitive() || leftClass == Boolean.TYPE) {
            leftCode = ClassUtils.class.getName() + ".to" + typeName + "(" + leftCode + ")";
        }
        if (!rightClass.isPrimitive() || leftClass == Boolean.TYPE) {
            rightCode = ClassUtils.class.getName() + ".to" + typeName + "(" + rightCode + ")";
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(MulOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class type = rightClass.isPrimitive() && rightType != Boolean.TYPE ? rightClass : (leftClass.isPrimitive() && leftClass != Boolean.TYPE ? leftClass : Integer.TYPE);
        Class clazz = type;
        String typeName = clazz.getCanonicalName();
        typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        if (!leftClass.isPrimitive() || leftClass == Boolean.TYPE) {
            leftCode = ClassUtils.class.getName() + ".to" + typeName + "(" + leftCode + ")";
        }
        if (!rightClass.isPrimitive() || leftClass == Boolean.TYPE) {
            rightCode = ClassUtils.class.getName() + ".to" + typeName + "(" + rightCode + ")";
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(DivOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class type = rightClass.isPrimitive() && rightType != Boolean.TYPE ? rightClass : (leftClass.isPrimitive() && leftClass != Boolean.TYPE ? leftClass : Integer.TYPE);
        Class clazz = type;
        String typeName = clazz.getCanonicalName();
        typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        if (!leftClass.isPrimitive() || leftClass == Boolean.TYPE) {
            leftCode = ClassUtils.class.getName() + ".to" + typeName + "(" + leftCode + ")";
        }
        if (!rightClass.isPrimitive() || leftClass == Boolean.TYPE) {
            rightCode = ClassUtils.class.getName() + ".to" + typeName + "(" + rightCode + ")";
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(ModOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class type = rightClass.isPrimitive() && rightType != Boolean.TYPE ? rightClass : (leftClass.isPrimitive() && leftClass != Boolean.TYPE ? leftClass : Integer.TYPE);
        Class clazz = type;
        String typeName = clazz.getCanonicalName();
        typeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        if (!leftClass.isPrimitive() || leftClass == Boolean.TYPE) {
            leftCode = ClassUtils.class.getName() + ".to" + typeName + "(" + leftCode + ")";
        }
        if (!rightClass.isPrimitive() || leftClass == Boolean.TYPE) {
            rightCode = ClassUtils.class.getName() + ".to" + typeName + "(" + rightCode + ")";
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(EqualsOperator node) throws IOException, ParseException {
        String code;
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        if (!("null".equals(leftCode) || "null".equals(rightCode) || leftClass.isPrimitive() && rightClass.isPrimitive())) {
            if (leftClass.isPrimitive()) {
                leftCode = ClassUtils.class.getName() + ".boxed(" + leftCode + ")";
            } else if (rightClass.isPrimitive()) {
                rightCode = ClassUtils.class.getName() + ".boxed(" + rightCode + ")";
            }
            if (String.class.equals((Object)leftClass) && !String.class.equals((Object)rightClass)) {
                rightCode = StringUtils.class.getName() + ".toString(" + rightCode + ")";
            } else if (!String.class.equals((Object)leftClass) && String.class.equals((Object)rightClass)) {
                leftCode = StringUtils.class.getName() + ".toString(" + leftCode + ")";
            }
            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".equals(" + rightCode + ")", "(" + rightCode + ") == null");
        } else {
            code = leftCode + " == " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(NotEqualsOperator node) throws IOException, ParseException {
        String code;
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        if (!("null".equals(leftCode) || "null".equals(rightCode) || leftClass.isPrimitive() && rightClass.isPrimitive())) {
            if (leftClass.isPrimitive()) {
                leftCode = ClassUtils.class.getName() + ".boxed(" + leftCode + ")";
            } else if (rightClass.isPrimitive()) {
                rightCode = ClassUtils.class.getName() + ".boxed(" + rightCode + ")";
            }
            if (String.class.equals((Object)leftClass) && !String.class.equals((Object)rightClass)) {
                rightCode = StringUtils.class.getName() + ".toString(" + rightCode + ")";
            } else if (!String.class.equals((Object)leftClass) && String.class.equals((Object)rightClass)) {
                leftCode = StringUtils.class.getName() + ".toString(" + leftCode + ")";
            }
            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, "(! " + leftCode + ".equals(" + rightCode + "))", "(" + rightCode + ") != null");
        } else {
            code = leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(GreaterOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        String code = null;
        if (leftClass != null && Comparable.class.isAssignableFrom(leftClass)) {
            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".compareTo(" + rightCode + ") > 0");
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        if (code == null) {
            code = leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(GreaterEqualsOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        String code = null;
        if (leftClass != null && Comparable.class.isAssignableFrom(leftClass)) {
            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".compareTo(" + rightCode + ") >= 0");
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        if (code == null) {
            code = leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(LessOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        String code = null;
        if (leftClass != null && Comparable.class.isAssignableFrom(leftClass)) {
            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".compareTo(" + rightCode + ") < 0");
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        if (code == null) {
            code = leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(LessEqualsOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        String code = null;
        if (leftClass != null && Comparable.class.isAssignableFrom(leftClass)) {
            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, type, leftCode + ".compareTo(" + rightCode + ") <= 0");
        }
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        if (code == null) {
            code = leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(AndOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        if (!Boolean.TYPE.equals(leftClass)) {
            if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
                rightCode = "(" + rightCode + ")";
            }
            leftCode = StringUtils.getConditionCode(leftClass, leftCode, this.importSizers);
            rightCode = StringUtils.getConditionCode(rightClass, rightCode, this.importSizers);
        }
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(OrOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class type = leftClass;
        String code = null;
        code = !Boolean.TYPE.equals(leftClass) ? "(" + StringUtils.getConditionCode(leftClass, leftCode, this.importSizers) + " ? (" + leftCode + ") : (" + rightCode + "))" : leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(BitAndOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = leftType;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(BitOrOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = leftType;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(BitXorOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = leftType;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(RightShiftOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = leftType;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(LeftShiftOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = leftType;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(UnsignShiftOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Type type = leftType;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(ArrayOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        ParameterizedTypeImpl type = null;
        String code = null;
        ArrayList<Class> ts = new ArrayList<Class>();
        if (leftType instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)leftType).getActualTypeArguments()) {
                ts.add((Class)t);
            }
        } else if (leftType != Void.TYPE) {
            ts.add((Class)leftType);
        }
        if (rightType instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)rightType).getActualTypeArguments()) {
                ts.add((Class)t);
            }
        } else if (rightType != Void.TYPE) {
            ts.add((Class)rightType);
        }
        type = new ParameterizedTypeImpl((Type)((Object)Object[].class), ts.toArray(new Class[ts.size()]));
        code = leftCode + ", " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(ConditionOperator node) throws IOException, ParseException {
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class type = rightClass;
        if (node.getRightParameter() instanceof Operator && ((Operator)node.getRightParameter()).getPriority() < node.getPriority()) {
            rightCode = "(" + rightCode + ")";
        }
        leftCode = StringUtils.getConditionCode(leftClass, leftCode, this.importSizers);
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(EntryOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Object type = null;
        String code = null;
        if (!(node.getLeftParameter() instanceof BinaryOperator) || !"?".equals(((BinaryOperator)node.getLeftParameter()).getName())) {
            type = Map.Entry.class;
            code = "new " + MapEntry.class.getName() + "(" + leftCode + ", " + rightCode + ")";
        } else {
            type = leftType;
            code = leftCode + " " + name + " " + rightCode;
        }
        this.typeStack.push((Type)type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(InstanceofOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        String name = node.getName();
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Boolean> type = Boolean.TYPE;
        String code = leftCode + " " + name + " " + rightCode;
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(IndexOperator node) throws IOException, ParseException {
        void var7_19;
        Type rightType = this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        if (node.getLeftParameter() instanceof Operator) {
            leftCode = "(" + leftCode + ")";
        }
        Object var7_7 = null;
        String code = null;
        if (Map.class.isAssignableFrom(leftClass)) {
            String var = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
            if (var != null && this.types.containsKey(var + ":1")) {
                Class<?> varType;
                Class<?> clazz = varType = this.types.get(var + ":1");
                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, clazz, "((" + varType.getCanonicalName() + ")" + leftCode + ".get(" + rightCode + "))");
            } else {
                Class<Object> clazz = Object.class;
                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)clazz), leftCode + ".get(" + rightCode + ")");
            }
        } else if (List.class.isAssignableFrom(leftClass)) {
            if (int[].class == rightType) {
                Class<List> clazz = List.class;
                code = CollectionUtils.class.getName() + ".subList(" + leftCode + ", " + rightCode + ")";
            } else if (rightType instanceof ParameterizedType && ((ParameterizedType)rightType).getActualTypeArguments()[0] == Integer.TYPE) {
                Class<List> clazz = List.class;
                code = CollectionUtils.class.getName() + ".subList(" + leftCode + ", new int[] {" + rightCode + "})";
            } else {
                String var;
                Class<?> varType;
                if (!Integer.TYPE.equals(rightType)) throw new ParseException("The \"[]\" index type: " + rightType + " must be int!", node.getOffset());
                Class<Object> clazz = Object.class;
                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)clazz), leftCode + ".get(" + rightCode + ")");
                if (node.getLeftParameter() instanceof Variable && (varType = this.types.get((var = ((Variable)node.getLeftParameter()).getName()) + ":0")) != null) {
                    Class<?> clazz2 = varType;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, clazz2, "((" + varType.getCanonicalName() + ")" + leftCode + ".get(" + rightCode + "))");
                }
            }
        } else {
            if (!leftClass.isArray()) throw new ParseException("Unsuptorted \"[]\" for non-array type: " + leftClass, node.getOffset());
            if (int[].class == rightType) {
                Class clazz = leftClass;
                code = CollectionUtils.class.getName() + ".subArray(" + leftCode + ", " + rightCode + ")";
            } else if (rightType instanceof ParameterizedType && ((ParameterizedType)rightType).getActualTypeArguments()[0] == Integer.TYPE) {
                Class clazz = leftClass;
                code = CollectionUtils.class.getName() + ".subArray(" + leftCode + ", new int[] {" + rightCode + "})";
            } else {
                if (!Integer.TYPE.equals(rightType)) throw new ParseException("The \"[]\" index type: " + rightType + " must be int!", node.getOffset());
                Class<?> clazz = leftClass.getComponentType();
                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, clazz, leftCode + "[" + rightCode + "]");
            }
        }
        this.typeStack.push((Type)var7_19);
        this.codeStack.push(code);
    }

    @Override
    public void visit(SequenceOperator node) throws IOException, ParseException {
        this.typeStack.pop();
        String rightCode = this.codeStack.pop();
        Type leftType = this.typeStack.pop();
        String leftCode = this.codeStack.pop();
        Class leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
            leftCode = "(" + leftCode + ")";
        }
        Class<Object> type = null;
        String code = null;
        if (leftClass == Integer.TYPE || leftClass == Integer.class || leftClass == Short.TYPE || leftClass == Short.class || leftClass == Long.TYPE || leftClass == Long.class || leftClass == Character.TYPE || leftClass == Character.class) {
            type = Array.newInstance(leftClass, 0).getClass();
            code = CollectionUtils.class.getName() + ".createSequence(" + leftCode + ", " + rightCode + ")";
        } else if (leftClass == String.class && leftCode.length() >= 2 && rightCode.length() >= 2 && (leftCode.startsWith("\"") || leftCode.startsWith("'")) && (leftCode.endsWith("\"") || leftCode.endsWith("'")) && (rightCode.startsWith("\"") || rightCode.startsWith("'")) && (rightCode.endsWith("\"") || rightCode.endsWith("'"))) {
            type = String[].class;
            StringBuilder buf = new StringBuilder();
            for (String s : this.getSequence(leftCode.substring(1, leftCode.length() - 1), rightCode.substring(1, rightCode.length() - 1))) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append("\"");
                buf.append(s);
                buf.append("\"");
            }
            code = "new String[] {" + buf.toString() + "}";
        } else {
            throw new ParseException("The operator \"..\" unsupported parameter type " + leftClass, node.getOffset());
        }
        this.typeStack.push(type);
        this.codeStack.push(code);
    }

    @Override
    public void visit(MethodOperator node) throws IOException, ParseException {
        String code;
        Class type;
        block44: {
            Method method;
            Class[] rightTypes;
            String name;
            Class leftClass;
            String leftCode;
            String rightCode;
            block46: {
                block47: {
                    Class<?> t;
                    block45: {
                        Class<?> varType;
                        String var;
                        Type rightType = this.typeStack.pop();
                        rightCode = this.codeStack.pop();
                        Type leftType = this.typeStack.pop();
                        leftCode = this.codeStack.pop();
                        Class rightClass = (Class)(rightType instanceof ParameterizedType ? ((ParameterizedType)rightType).getRawType() : rightType);
                        leftClass = (Class)(leftType instanceof ParameterizedType ? ((ParameterizedType)leftType).getRawType() : leftType);
                        name = node.getName();
                        if (node.getLeftParameter() instanceof Operator && ((Operator)node.getLeftParameter()).getPriority() < node.getPriority()) {
                            leftCode = "(" + leftCode + ")";
                        }
                        type = null;
                        code = null;
                        if ("to".equals(name) && node.getRightParameter() instanceof Constant && rightType == String.class && rightCode.length() > 2 && rightCode.startsWith("\"") && rightCode.endsWith("\"")) {
                            code = "((" + rightCode.substring(1, rightCode.length() - 1) + ")" + leftCode + ")";
                            type = ClassUtils.forName(this.importPackages, rightCode.substring(1, rightCode.length() - 1));
                        } else if ("class".equals(name)) {
                            type = Class.class;
                            code = leftClass.isPrimitive() ? leftClass.getCanonicalName() + ".class" : this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + ".getClass()");
                        } else if (Map.Entry.class.isAssignableFrom(leftClass) && ("key".equals(name) || "value".equals(name))) {
                            var = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
                            if (var != null) {
                                Class<?> keyType = this.types.get(var + ":0");
                                Class<?> valueType = this.types.get(var + ":1");
                                if ("key".equals(name) && keyType != null) {
                                    type = keyType;
                                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), "((" + keyType.getCanonicalName() + ")" + leftCode + ".getKey(" + rightCode + "))");
                                } else if ("value".equals(name) && valueType != null) {
                                    type = valueType;
                                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), "((" + valueType.getCanonicalName() + ")" + leftCode + ".getValue(" + rightCode + "))");
                                }
                            }
                        } else if (Map.class.isAssignableFrom(leftClass) && "get".equals(name)) {
                            var = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
                            if (var != null && (varType = this.types.get(var + ":1")) != null) {
                                type = varType;
                                if (rightClass.isPrimitive()) {
                                    rightCode = ClassUtils.class.getName() + ".boxed(" + rightCode + ")";
                                }
                                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), "((" + varType.getCanonicalName() + ")" + leftCode + ".get(" + rightCode + "))");
                            }
                        } else if (List.class.isAssignableFrom(leftClass) && "get".equals(name) && (Integer.TYPE.equals(rightType) || Integer.class.equals((Object)rightType)) && (var = CompiledVisitor.getGenericVariableName(node.getLeftParameter())) != null && (varType = this.types.get(var + ":0")) != null) {
                            type = varType;
                            if (!rightClass.isPrimitive()) {
                                rightCode = ClassUtils.class.getName() + ".unboxed(" + rightCode + ")";
                            }
                            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), "((" + varType.getCanonicalName() + ")" + leftCode + ".get(" + rightCode + "))");
                        }
                        if (code != null) break block44;
                        rightTypes = rightType instanceof ParameterizedType ? (Class[])((ParameterizedType)rightType).getActualTypeArguments() : (rightClass == Void.TYPE ? new Class[]{} : new Class[]{rightClass});
                        if (!Template.class.isAssignableFrom(leftClass) || this.hasMethod(Template.class, name, rightTypes)) break block45;
                        type = Object.class;
                        code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), CompiledVisitor.class.getName() + ".getMacro(" + leftCode + ", \"" + name + "\").evaluate(new Object" + (rightCode.length() == 0 ? "[0]" : "[] { " + rightCode + " }") + ")");
                        break block46;
                    }
                    if (!Map.class.isAssignableFrom(leftClass) || rightTypes.length != 0 || this.hasMethod(Map.class, name, rightTypes)) break block47;
                    type = Object.class;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + ".get(\"" + name + "\")");
                    String var = CompiledVisitor.getGenericVariableName(node.getLeftParameter());
                    if (var == null || (t = this.types.get(var + ":1")) == null) break block46;
                    type = t;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), "((" + t.getCanonicalName() + ")" + leftCode + ".get(\"" + name + "\"))");
                    break block46;
                }
                if (this.importGetters != null && this.importGetters.length > 0 && rightTypes.length == 0 && !this.hasMethod(leftClass, name, rightTypes)) {
                    for (String getter : this.importGetters) {
                        if (!this.hasMethod(leftClass, getter, new Class[]{String.class}) && !this.hasMethod(leftClass, getter, new Class[]{Object.class})) continue;
                        type = Object.class;
                        code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + "." + getter + "(\"" + name + "\")");
                        break;
                    }
                }
            }
            name = ClassUtils.filterJavaKeyword(name);
            if (this.functions != null && this.functions.size() > 0) {
                String allCode;
                Class[] allTypes;
                if (rightTypes == null || rightTypes.length == 0) {
                    allTypes = new Class[]{leftClass};
                    allCode = leftCode;
                } else {
                    allTypes = new Class[rightTypes.length + 1];
                    allTypes[0] = leftClass;
                    System.arraycopy(rightTypes, 0, allTypes, 1, rightTypes.length);
                    allCode = leftCode + ", " + rightCode;
                }
                for (Class<?> function : this.functions.keySet()) {
                    try {
                        method = ClassUtils.searchMethod(function, name, allTypes, allTypes.length == 2);
                        if (Object.class.equals(method.getDeclaringClass())) continue;
                        type = method.getReturnType();
                        if (type == Void.TYPE) {
                            throw new ParseException("Can not call void method " + method.getName() + " in class " + function.getName(), node.getOffset());
                        }
                        Class<?>[] pts = method.getParameterTypes();
                        if (allTypes.length == 2 && allTypes[1].isPrimitive() && pts[1].isAssignableFrom(ClassUtils.getBoxedClass(allTypes[1]))) {
                            allCode = leftCode + ", " + ClassUtils.class.getName() + ".boxed(" + rightCode + ")";
                        }
                        if (Modifier.isStatic(method.getModifiers())) {
                            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), function.getName() + "." + method.getName() + "(" + allCode + ")");
                            break;
                        }
                        code = "$" + function.getName().replace('.', '_') + "." + method.getName() + "(" + allCode + ")";
                        break;
                    }
                    catch (NoSuchMethodException e) {
                    }
                }
            }
            if (code == null) {
                if (leftClass.isArray() && "length".equals(name)) {
                    type = Integer.TYPE;
                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + ".length");
                } else {
                    try {
                        Method method2 = ClassUtils.searchMethod(leftClass, name, rightTypes);
                        type = method2.getReturnType();
                        code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + "." + method2.getName() + "(" + rightCode + ")");
                        if (type == Void.TYPE) {
                            throw new ParseException("Can not call void method " + method2.getName() + " in class " + leftClass.getName(), node.getOffset());
                        }
                    }
                    catch (NoSuchMethodException e) {
                        String def = "";
                        if (StringUtils.isNamed(leftCode) && leftClass.equals(this.defaultVariableType)) {
                            def = "Can not resolve the " + leftCode + " variable type. Please explicit define the variable type #set(Xxx " + leftCode + ") in your template.";
                        }
                        if (rightTypes != null && rightTypes.length > 0) {
                            throw new ParseException("No such method " + ClassUtils.getMethodFullName(name, rightTypes) + " in class " + leftClass.getName() + "." + def, node.getOffset());
                        }
                        try {
                            String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                            Method method3 = leftClass.getMethod(getter, new Class[0]);
                            type = method3.getReturnType();
                            code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + "." + method3.getName() + "()");
                            if (type == Void.TYPE) {
                                throw new ParseException("Can not call void method " + method3.getName() + " in class " + leftClass.getName(), node.getOffset());
                            }
                        }
                        catch (NoSuchMethodException e2) {
                            try {
                                String getter;
                                getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                                method = leftClass.getMethod(getter, new Class[0]);
                                type = method.getReturnType();
                                code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + "." + method.getName() + "()");
                                if (type == Void.TYPE) {
                                    throw new ParseException("Can not call void method " + method.getName() + " in class " + leftClass.getName(), node.getOffset());
                                }
                            }
                            catch (NoSuchMethodException e3) {
                                try {
                                    Field field = leftClass.getField(name);
                                    type = field.getType();
                                    code = this.getNotNullCode(node.getLeftParameter(), leftClass, leftCode, (Type)((Object)type), leftCode + "." + field.getName());
                                }
                                catch (NoSuchFieldException e4) {
                                    throw new ParseException("No such property " + name + " in class " + leftClass.getName() + ", because no such method get" + name.substring(0, 1).toUpperCase() + name.substring(1) + "() or method is" + name.substring(0, 1).toUpperCase() + name.substring(1) + "() or method " + name + "() or filed " + name + "." + def, node.getOffset());
                                }
                            }
                        }
                    }
                }
            }
        }
        this.typeStack.push((Type)((Object)type));
        this.codeStack.push(code);
    }

    private static String getGenericVariableName(Expression node) {
        if (node instanceof Variable) {
            return ((Variable)node).getName();
        }
        while (node instanceof BinaryOperator) {
            String name = ((BinaryOperator)node).getName();
            if ("+".equals(name) || "||".equals(name) || "&&".equals(name) || ".entrySet".equals(name)) {
                if (!((node = ((BinaryOperator)node).getLeftParameter()) instanceof Variable)) continue;
                return ((Variable)node).getName();
            }
            return null;
        }
        return null;
    }

    private List<String> getSequence(String begin, String end) {
        if (this.sequences != null) {
            for (StringSequence sequence : this.sequences) {
                if (!sequence.containSequence(begin, end)) continue;
                return sequence.getSequence(begin, end);
            }
        }
        throw new IllegalStateException("No such sequence from \"" + begin + "\" to \"" + end + "\".");
    }

    public static Template getMacro(Template template, String name) {
        Template macro = template.getMacros().get(name);
        if (macro == null) {
            throw new IllegalStateException("No such macro " + name + "in template " + template.getName());
        }
        return macro;
    }

    private String getNotNullCode(Node leftParameter, Class<?> leftClass, String leftCode, Type type, String code) throws IOException, ParseException {
        Class clazz = (Class)(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
        return this.getNotNullCode(leftParameter, leftClass, leftCode, type, code, ClassUtils.getInitCodeWithType(clazz));
    }

    private String getNotNullCode(Node leftParameter, Class<?> leftClass, String leftCode, Type type, String code, String nullCode) throws IOException, ParseException {
        if (leftParameter instanceof Constant || leftClass != null && leftClass.isPrimitive()) {
            return code;
        }
        return "(" + leftCode + " == null ? " + nullCode + " : " + code + ")";
    }

    private boolean hasMethod(Class<?> leftClass, String name, Class<?>[] rightTypes) {
        if (leftClass == null) {
            return false;
        }
        if (leftClass.isArray() && "length".equals(name)) {
            return true;
        }
        try {
            Method method = ClassUtils.searchMethod(leftClass, name, rightTypes, false);
            return method != null;
        }
        catch (NoSuchMethodException e) {
            if (rightTypes != null && rightTypes.length > 0) {
                return false;
            }
            try {
                String getter = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = leftClass.getMethod(getter, new Class[0]);
                return method != null;
            }
            catch (NoSuchMethodException e2) {
                try {
                    String getter = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    Method method = leftClass.getMethod(getter, new Class[0]);
                    return method != null;
                }
                catch (NoSuchMethodException e3) {
                    try {
                        Field field = leftClass.getField(name);
                        return field != null;
                    }
                    catch (NoSuchFieldException e4) {
                        return false;
                    }
                }
            }
        }
    }
}

