/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Engine;
import httl.Node;
import httl.Template;
import httl.Visitor;
import httl.spi.Converter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveTemplate
implements Template,
Serializable {
    private static final long serialVersionUID = 3094907176375413567L;
    private final Template writerTemplate;
    private final Template streamTemplate;
    private final Converter<Object, Object> outConverter;
    private Map<String, Template> macros;

    public AdaptiveTemplate(Template writerTemplate, Template streamTemplate, Converter<Object, Object> outConverter) {
        if (writerTemplate == null) {
            throw new IllegalArgumentException("writer template == null");
        }
        if (streamTemplate == null) {
            throw new IllegalArgumentException("stream template == null");
        }
        this.writerTemplate = writerTemplate;
        this.streamTemplate = streamTemplate;
        this.outConverter = outConverter;
    }

    @Override
    public String getName() {
        return this.writerTemplate.getName();
    }

    @Override
    public String getEncoding() {
        return this.writerTemplate.getEncoding();
    }

    @Override
    public Locale getLocale() {
        return this.writerTemplate.getLocale();
    }

    @Override
    public long getLastModified() {
        return this.writerTemplate.getLastModified();
    }

    @Override
    public long getLength() {
        return this.writerTemplate.getLength();
    }

    @Override
    public String getSource() throws IOException {
        return this.writerTemplate.getSource();
    }

    @Override
    public Reader openReader() throws IOException {
        return this.writerTemplate.openReader();
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.streamTemplate.openStream();
    }

    @Override
    public Engine getEngine() {
        return this.writerTemplate.getEngine();
    }

    @Override
    public Object evaluate() throws ParseException {
        if (Context.getContext().getOut() instanceof OutputStream) {
            return this.streamTemplate.evaluate();
        }
        return this.writerTemplate.evaluate();
    }

    @Override
    public Object evaluate(Object context) throws ParseException {
        if (Context.getContext().getOut() instanceof OutputStream) {
            return this.streamTemplate.evaluate(context);
        }
        return this.writerTemplate.evaluate(context);
    }

    @Override
    public void render() throws IOException, ParseException {
        this.render(Context.getContext().getOut());
    }

    @Override
    public void render(Object out) throws IOException, ParseException {
        if (out instanceof OutputStream) {
            this.streamTemplate.render(out);
        } else if (out instanceof Writer) {
            this.writerTemplate.render(out);
        } else if ((out = this.outConverter.convert(out, this.getVariables())) instanceof OutputStream) {
            this.streamTemplate.render(out);
        } else {
            this.writerTemplate.render(out);
        }
    }

    @Override
    public void render(Object context, Object out) throws IOException, ParseException {
        if (out instanceof OutputStream) {
            this.streamTemplate.render(context, out);
        } else if (out instanceof Writer) {
            this.writerTemplate.render(context, out);
        } else if ((out = this.outConverter.convert(out, this.getVariables())) instanceof OutputStream) {
            this.streamTemplate.render(context, out);
        } else {
            this.writerTemplate.render(context, out);
        }
    }

    @Override
    public Map<String, Class<?>> getVariables() {
        return this.writerTemplate.getVariables();
    }

    @Override
    public Map<String, Template> getMacros() {
        if (this.macros == null) {
            HashMap<String, AdaptiveTemplate> map = new HashMap<String, AdaptiveTemplate>();
            Map<String, Template> writerMacros = this.writerTemplate.getMacros();
            Map<String, Template> streamMacros = this.streamTemplate.getMacros();
            for (Map.Entry<String, Template> entry : writerMacros.entrySet()) {
                map.put(entry.getKey(), new AdaptiveTemplate(entry.getValue(), streamMacros.get(entry.getKey()), this.outConverter));
            }
            this.macros = Collections.unmodifiableMap(map);
        }
        return this.macros;
    }

    @Override
    public int getOffset() {
        return this.writerTemplate.getOffset();
    }

    @Override
    public boolean isMacro() {
        return this.writerTemplate.isMacro();
    }

    @Override
    public void accept(Visitor visitor) throws IOException, ParseException {
        this.writerTemplate.accept(visitor);
    }

    @Override
    public Template getParent() {
        return this.writerTemplate.getParent();
    }

    @Override
    public List<Node> getChildren() {
        return this.writerTemplate.getChildren();
    }

    public String toString() {
        return this.writerTemplate.toString();
    }
}

