/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators.templates;

import httl.Context;
import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.Visitor;
import httl.ast.BlockDirective;
import httl.ast.MacroDirective;
import httl.spi.Converter;
import httl.spi.Interceptor;
import httl.spi.Listener;
import httl.util.ClassUtils;
import httl.util.StringUtils;
import httl.util.UnsafeStringWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplate
implements Template {
    private final Resource resource;
    private final Node root;
    private final Template parent;
    private final String name;
    private final String encoding;
    private final Locale locale;
    private final long lastModified;
    private final long length;
    private Converter<Object, Object> mapConverter;
    private Converter<Object, Object> outConverter;
    private Interceptor interceptor;

    public AbstractTemplate(Resource resource, Node root, Template parent) {
        this.resource = resource;
        this.root = root;
        this.parent = parent;
        this.name = AbstractTemplate.buildName(resource, root);
        this.encoding = resource.getEncoding();
        this.locale = resource.getLocale();
        this.lastModified = resource.getLastModified();
        this.length = resource.getLength();
    }

    private static String buildName(Resource resource, Node root) {
        StringBuilder builder = new StringBuilder();
        builder.append(resource.getName());
        while (root instanceof MacroDirective) {
            builder.append("#");
            builder.append(((MacroDirective)root).getName());
            root = root.getParent();
        }
        return builder.toString();
    }

    private Object convertOut(Object out) throws IOException, ParseException {
        if (this.outConverter != null && out != null && !(out instanceof OutputStream) && !(out instanceof Writer)) {
            return this.outConverter.convert(out, this.getVariables());
        }
        return out;
    }

    private Map<String, Object> convertMap(Object context) throws ParseException {
        if (this.mapConverter != null && context != null && !(context instanceof Map)) {
            try {
                context = this.mapConverter.convert(context, this.getVariables());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (context == null || context instanceof Map) {
            return (Map)context;
        }
        throw new IllegalArgumentException("No such Converter to convert the " + context.getClass().getName() + " to Map.");
    }

    @Override
    public void render(Object parameters, Object out) throws IOException, ParseException {
        Map<String, Object> map = this.convertMap(parameters);
        out = this.convertOut(out);
        Context context = Context.pushContext(map);
        try {
            context.setTemplate(this);
            if (out instanceof OutputStream) {
                context.setOut((OutputStream)out);
            } else if (out instanceof Writer) {
                context.setOut((Writer)out);
            } else {
                throw new IllegalArgumentException("No such Converter to convert the " + out.getClass().getName() + " to OutputStream or Writer.");
            }
            if (this.interceptor != null) {
                this.interceptor.render(context, new Listener(){

                    public void render(Context context) throws IOException, ParseException {
                        AbstractTemplate.this._render(context);
                    }
                });
            } else {
                this._render(context);
            }
        }
        catch (ParseException e) {
            throw AbstractTemplate.toLocatedParseException(e, this);
        }
        finally {
            Context.popContext();
        }
    }

    private void _render(Context context) throws IOException, ParseException {
        try {
            this.doRender(context);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(ClassUtils.toString(e), e);
        }
    }

    protected abstract void doRender(Context var1) throws Exception;

    protected Resource getResource() {
        return this.resource;
    }

    protected Node getRoot() {
        return this.root;
    }

    protected Converter<Object, Object> getMapConverter() {
        return this.mapConverter;
    }

    protected Converter<Object, Object> getOutConverter() {
        return this.outConverter;
    }

    protected Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setMapConverter(Converter<Object, Object> mapConverter) {
        this.mapConverter = mapConverter;
    }

    public void setOutConverter(Converter<Object, Object> outConverter) {
        this.outConverter = outConverter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String getSource() throws IOException {
        return this.resource.getSource();
    }

    @Override
    public Reader openReader() throws IOException {
        return this.resource.openReader();
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.resource.openStream();
    }

    @Override
    public Engine getEngine() {
        return this.resource.getEngine();
    }

    @Override
    public int getOffset() {
        return this.root.getOffset();
    }

    @Override
    public Template getParent() {
        return this.parent;
    }

    @Override
    public List<Node> getChildren() {
        return ((BlockDirective)this.root).getChildren();
    }

    @Override
    public boolean isMacro() {
        return this.root instanceof MacroDirective;
    }

    @Override
    public void accept(Visitor visitor) throws IOException, ParseException {
        if (visitor.visit(this)) {
            for (Node node : this.getChildren()) {
                node.accept(visitor);
            }
        }
    }

    @Override
    public Object evaluate() throws ParseException {
        return this.evaluate(null);
    }

    @Override
    public void render(Object out) throws IOException, ParseException {
        this.render(null, out);
    }

    @Override
    public void render() throws IOException, ParseException {
        this.render(null, Context.getContext().getOut());
    }

    @Override
    public Object evaluate(Object context) throws ParseException {
        UnsafeStringWriter writer = new UnsafeStringWriter();
        try {
            this.render(context, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseException toLocatedParseException(ParseException e, Resource resource) {
        if (e.getMessage() != null && e.getMessage().contains("Occur to offset:")) {
            return e;
        }
        int offset = e.getErrorOffset();
        if (offset <= 0) {
            return e;
        }
        String location = null;
        try {
            Reader reader = resource.openReader();
            try {
                location = StringUtils.getLocationMessage(resource.getName(), reader, offset);
            }
            finally {
                reader.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return new ParseException(e.getMessage() + "\nOccur to offset: " + offset + (StringUtils.isEmpty(location) ? "" : ", " + location) + ", stack: " + ClassUtils.toString(e), offset);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String name = this.getName();
        result = 31 * result + (name == null ? 0 : name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTemplate other = (AbstractTemplate)obj;
        String name = this.getName();
        String otherName = other.getName();
        return !(name == null ? otherName != null : !name.equals(otherName));
    }

    public String toString() {
        return this.getName();
    }
}

