/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.translators;

import httl.Engine;
import httl.Node;
import httl.Resource;
import httl.Template;
import httl.spi.Compiler;
import httl.spi.Converter;
import httl.spi.Filter;
import httl.spi.Formatter;
import httl.spi.Interceptor;
import httl.spi.Logger;
import httl.spi.Switcher;
import httl.spi.Translator;
import httl.spi.translators.templates.AdaptiveTemplate;
import httl.spi.translators.templates.CompiledTemplate;
import httl.spi.translators.templates.CompiledVisitor;
import httl.util.ClassUtils;
import httl.util.StringSequence;
import httl.util.StringUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledTranslator
implements Translator {
    private String[] forVariable;
    private String filterVariable;
    private String formatterVariable;
    private String defaultFilterVariable;
    private String defaultFormatterVariable;
    private Engine engine;
    private Compiler compiler;
    private Interceptor interceptor;
    private Logger logger;
    private Switcher<Filter> textFilterSwitcher;
    private Switcher<Filter> valueFilterSwitcher;
    private Switcher<Formatter<Object>> formatterSwitcher;
    private Filter textFilter;
    private Filter valueFilter;
    private Converter<Object, Object> mapConverter;
    private Converter<Object, Object> outConverter;
    private Formatter<Object> formatter;
    private String[] importMacros;
    private final Map<String, Template> importMacroTemplates = new ConcurrentHashMap<String, Template>();
    private String[] importPackages;
    private Set<String> importPackageSet;
    private String[] importVariables;
    private Map<String, Class<?>> importTypes;
    private final Map<Class<?>, Object> functions = new ConcurrentHashMap();
    private final List<StringSequence> sequences = new CopyOnWriteArrayList<StringSequence>();
    private static final String TEMPLATE_CLASS_PREFIX = CompiledTemplate.class.getPackage().getName() + ".Template_";
    private boolean isOutputStream;
    private boolean isOutputWriter;
    private boolean sourceInClass;
    private boolean textInClass;
    private String outputEncoding;
    private Class<?> defaultVariableType;
    private String engineName;
    private String[] importSizers;
    private String[] importGetters;
    private static final String HTTL_DEFAULT = "httl.properties";
    private static final String HTTL_PREFIX = "httl-";
    private static final String PROPERTIES_SUFFIX = ".properties";

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setImportSizers(String[] importSizers) {
        this.importSizers = importSizers;
    }

    public void setImportGetters(String[] importGetters) {
        this.importGetters = importGetters;
    }

    public void setDefaultVariableType(String defaultVariableType) {
        this.defaultVariableType = ClassUtils.forName(defaultVariableType);
    }

    public void setImportMacros(String[] importMacros) {
        this.importMacros = importMacros;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setEngineName(String name) {
        if (HTTL_DEFAULT.equals(name)) {
            name = "";
        } else {
            if (name.startsWith(HTTL_PREFIX)) {
                name = name.substring(HTTL_PREFIX.length());
            }
            if (name.endsWith(PROPERTIES_SUFFIX)) {
                name = name.substring(0, name.length() - PROPERTIES_SUFFIX.length());
            }
        }
        this.engineName = name;
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setTextFilterSwitcher(Switcher<Filter> textFilterSwitcher) {
        this.textFilterSwitcher = textFilterSwitcher;
    }

    public void setValueFilterSwitcher(Switcher<Filter> valueFilterSwitcher) {
        this.valueFilterSwitcher = valueFilterSwitcher;
    }

    public void setFormatterSwitcher(Switcher<Formatter<Object>> formatterSwitcher) {
        this.formatterSwitcher = formatterSwitcher;
    }

    public void setTextFilter(Filter filter) {
        this.textFilter = filter;
    }

    public void setValueFilter(Filter filter) {
        this.valueFilter = filter;
    }

    public void setMapConverter(Converter<Object, Object> mapConverter) {
        this.mapConverter = mapConverter;
    }

    public void setOutConverter(Converter<Object, Object> outConverter) {
        this.outConverter = outConverter;
    }

    public void setFormatter(Formatter<Object> formatter) {
        this.formatter = formatter;
    }

    public void setOutputStream(boolean outputStream) {
        this.isOutputStream = outputStream;
    }

    public void setOutputWriter(boolean outputWriter) {
        this.isOutputWriter = outputWriter;
    }

    public void setSourceInClass(boolean sourceInClass) {
        this.sourceInClass = sourceInClass;
    }

    public void setTextInClass(boolean textInClass) {
        this.textInClass = textInClass;
    }

    public void setForVariable(String[] forVariable) {
        this.forVariable = forVariable;
    }

    public void setFilterVariable(String filterVariable) {
        this.filterVariable = filterVariable;
    }

    public void setFormatterVariable(String formatterVariable) {
        this.formatterVariable = formatterVariable;
    }

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
        this.importPackageSet = new HashSet<String>(Arrays.asList(importPackages));
    }

    public void setImportVariables(String[] importVariables) {
        this.importVariables = importVariables;
    }

    public void setImportMethods(Object[] importMethods) {
        for (Object function : importMethods) {
            if (function instanceof Class) {
                this.functions.put((Class)function, function);
                continue;
            }
            this.functions.put(function.getClass(), function);
        }
    }

    public void setImportSequences(String[] sequences) {
        for (String s : sequences) {
            if ((s = s.trim()).length() <= 0) continue;
            String[] ts = s.split("\\s+");
            ArrayList<String> sequence = new ArrayList<String>();
            for (String t : ts) {
                if ((t = t.trim()).length() <= 0) continue;
                sequence.add(t);
            }
            this.sequences.add(new StringSequence(sequence));
        }
    }

    public void init() {
        this.defaultFilterVariable = "$" + this.filterVariable;
        this.defaultFormatterVariable = "$" + this.formatterVariable;
        if (this.importVariables != null && this.importVariables.length > 0) {
            this.importTypes = new HashMap();
            for (String var : this.importVariables) {
                int i = var.lastIndexOf(32);
                if (i < 0) {
                    throw new IllegalArgumentException("Illegal config import.setVariables");
                }
                this.importTypes.put(var.substring(i + 1), ClassUtils.forName(this.importPackages, var.substring(0, i)));
            }
        }
    }

    public void inited() {
        if (this.importMacros != null && this.importMacros.length > 0) {
            for (String importMacro : this.importMacros) {
                try {
                    Template importMacroTemplate = this.engine.getTemplate(importMacro);
                    this.importMacroTemplates.putAll(importMacroTemplate.getMacros());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public Template translate(Resource resource, Node root, Map<String, Class<?>> defVariableTypes) throws IOException, ParseException {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Compile template " + resource.getName());
        }
        try {
            Class<?> clazz;
            Template writerTemplate = null;
            Template streamTemplate = null;
            if (this.isOutputWriter || !this.isOutputStream) {
                clazz = this.parseClass(resource, root, defVariableTypes, false, 0);
                writerTemplate = (Template)clazz.getConstructor(Engine.class, Interceptor.class, Compiler.class, Switcher.class, Switcher.class, Filter.class, Formatter.class, Converter.class, Converter.class, Map.class, Map.class, Resource.class, Template.class, Node.class).newInstance(this.engine, this.interceptor, this.compiler, this.valueFilterSwitcher, this.formatterSwitcher, this.valueFilter, this.formatter, this.mapConverter, this.outConverter, this.functions, this.importMacroTemplates, resource, null, root);
            }
            if (this.isOutputStream) {
                clazz = this.parseClass(resource, root, defVariableTypes, true, 0);
                streamTemplate = (Template)clazz.getConstructor(Engine.class, Interceptor.class, Compiler.class, Switcher.class, Switcher.class, Filter.class, Formatter.class, Converter.class, Converter.class, Map.class, Map.class, Resource.class, Template.class, Node.class).newInstance(this.engine, this.interceptor, this.compiler, this.valueFilterSwitcher, this.formatterSwitcher, this.valueFilter, this.formatter, this.mapConverter, this.outConverter, this.functions, this.importMacroTemplates, resource, null, root);
            }
            if (writerTemplate != null && streamTemplate != null) {
                return new AdaptiveTemplate(writerTemplate, streamTemplate, this.outConverter);
            }
            if (streamTemplate != null) {
                return streamTemplate;
            }
            return writerTemplate;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("Failed to translate template: " + resource.getName() + ", cause: " + ClassUtils.toString(e), 0);
        }
    }

    private String getTemplateClassName(Resource resource, boolean stream) {
        String name = resource.getName();
        String encoding = resource.getEncoding();
        Locale locale = resource.getLocale();
        long lastModified = resource.getLastModified();
        StringBuilder buf = new StringBuilder(name.length() + 40);
        buf.append(name);
        if (this.engineName != null) {
            buf.append("_");
            buf.append(this.engineName);
        }
        if (encoding != null) {
            buf.append("_");
            buf.append(encoding);
        }
        if (locale != null) {
            buf.append("_");
            buf.append(locale);
        }
        if (lastModified > 0L) {
            buf.append("_");
            buf.append(lastModified);
        }
        buf.append(stream ? "_stream" : "_writer");
        return TEMPLATE_CLASS_PREFIX + StringUtils.getVaildName(buf.toString());
    }

    private Class<?> parseClass(Resource resource, Node root, Map<String, Class<?>> types, boolean stream, int offset) throws IOException, ParseException {
        String name = this.getTemplateClassName(resource, stream);
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (types == null) {
                types = new HashMap();
            }
            CompiledVisitor visitor = new CompiledVisitor();
            visitor.setResource(resource);
            visitor.setNode(root);
            visitor.setTypes(types);
            visitor.setStream(stream);
            visitor.setOffset(offset);
            visitor.setDefaultFilterVariable(this.defaultFilterVariable);
            visitor.setDefaultFormatterVariable(this.defaultFormatterVariable);
            visitor.setDefaultVariableType(this.defaultVariableType);
            visitor.setEngineName(this.engineName);
            visitor.setFilterVariable(this.filterVariable);
            visitor.setFormatterSwitcher(this.formatterSwitcher);
            visitor.setFormatterVariable(this.formatterVariable);
            visitor.setForVariable(this.forVariable);
            visitor.setImportMacroTemplates(this.importMacroTemplates);
            visitor.setImportPackages(this.importPackages);
            visitor.setImportPackageSet(this.importPackageSet);
            visitor.setImportSizers(this.importSizers);
            visitor.setImportGetters(this.importGetters);
            visitor.setImportTypes(this.importTypes);
            visitor.setImportMethods(this.functions);
            visitor.setImportSequences(this.sequences);
            visitor.setOutputEncoding(this.outputEncoding);
            visitor.setSourceInClass(this.sourceInClass);
            visitor.setTextFilter(this.textFilter);
            visitor.setTextFilterSwitcher(this.textFilterSwitcher);
            visitor.setTextInClass(this.textInClass);
            visitor.setValueFilterSwitcher(this.valueFilterSwitcher);
            visitor.setCompiler(this.compiler);
            visitor.init();
            root.accept(visitor);
            return visitor.compile();
        }
    }
}

