/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.parsers;

import httl.Node;
import httl.ast.AddOperator;
import httl.ast.AndOperator;
import httl.ast.ArrayOperator;
import httl.ast.BinaryOperator;
import httl.ast.BitAndOperator;
import httl.ast.BitNotOperator;
import httl.ast.BitOrOperator;
import httl.ast.BitXorOperator;
import httl.ast.CastOperator;
import httl.ast.ConditionOperator;
import httl.ast.Constant;
import httl.ast.DivOperator;
import httl.ast.EntryOperator;
import httl.ast.EqualsOperator;
import httl.ast.Expression;
import httl.ast.GreaterEqualsOperator;
import httl.ast.GreaterOperator;
import httl.ast.IndexOperator;
import httl.ast.InstanceofOperator;
import httl.ast.LeftShiftOperator;
import httl.ast.LessEqualsOperator;
import httl.ast.LessOperator;
import httl.ast.ListOperator;
import httl.ast.MethodOperator;
import httl.ast.ModOperator;
import httl.ast.MulOperator;
import httl.ast.NegativeOperator;
import httl.ast.NewOperator;
import httl.ast.NotEqualsOperator;
import httl.ast.NotOperator;
import httl.ast.Operator;
import httl.ast.OrOperator;
import httl.ast.PositiveOperator;
import httl.ast.RightShiftOperator;
import httl.ast.SequenceOperator;
import httl.ast.StaticMethodOperator;
import httl.ast.SubOperator;
import httl.ast.UnaryOperator;
import httl.ast.UnsignShiftOperator;
import httl.ast.Variable;
import httl.spi.Filter;
import httl.spi.Parser;
import httl.util.ClassUtils;
import httl.util.DfaScanner;
import httl.util.LinkedStack;
import httl.util.StringUtils;
import httl.util.Token;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionParser
implements Parser {
    private Filter expressionFilter;
    private List<String> forbidEqualsMethods;
    private List<String> forbidStartsMethods;
    private List<String> forbidEndsMethods;
    private String[] importPackages;
    private static final int B = -1;
    private static final int B1 = -2;
    private static final int B2 = -3;
    private static final int E = -100000000;
    static final int[][] states = new int[][]{{0, 1, 2, 5, 7, 9, 11, 4, 6, 4}, {-2, 1, 1, -2, -100000000, -100000000, -100000000, -2, -2, -2}, {-2, 2, 2, 13, -100000000, -100000000, -100000000, -2, -2, -2}, {-2, 3, 3, -2, -100000000, -100000000, -100000000, -2, -2, -2}, {-2, -2, -2, 4, -2, -2, -2, 4, -2, 4}, {-2, 1, 3, -1, -2, -2, -2, -2, -2, 4}, {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2}, {7, 7, 7, 7, -1, 7, 7, 8, 7, 7}, {7, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {9, 9, 9, 9, 9, -1, 9, 10, 9, 9}, {9, 9, 9, 9, 9, 9, 9, 9, 9, 9}, {11, 11, 11, 11, 11, 11, -1, 12, 11, 11}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, {-3, -3, 3, -3, -3, -3, -3, -3, -3, -3}};
    private static DfaScanner scanner = new DfaScanner(){

        public int next(int state, char ch) {
            return states[state][ExpressionParser.getCharType(ch)];
        }
    };
    private static final Set<String> BINARY_OPERATORS = new HashSet<String>(Arrays.asList("+", "-", "*", "/", "%", "==", "!=", ">", ">=", "<", "<=", "gt", "ge", "lt", "le", "&&", "||", "&", "|", "^", ">>", "<<", ">>>", ",", "?", ":", "instanceof", "is", "[", ".."));
    private static final Set<String> UNARY_OPERATORS = new HashSet<String>(Arrays.asList("+", "-", "!", "~", "new", "["));
    private static final Pattern BLANK_PATTERN = Pattern.compile("^(\\s+)");

    public void setImportPackages(String[] importPackages) {
        this.importPackages = importPackages;
    }

    public void setExpressionFilter(Filter expressionFilter) {
        this.expressionFilter = expressionFilter;
    }

    public void setForbidMethods(String[] forbidMethods) {
        for (String method : forbidMethods) {
            if (method.startsWith("*")) {
                if (this.forbidEndsMethods == null) {
                    this.forbidEndsMethods = new ArrayList<String>();
                }
                this.forbidEndsMethods.add(method.substring(1));
                continue;
            }
            if (method.endsWith("*")) {
                if (this.forbidStartsMethods == null) {
                    this.forbidStartsMethods = new ArrayList<String>();
                }
                this.forbidStartsMethods.add(method.substring(0, method.length() - 1));
                continue;
            }
            if (this.forbidEqualsMethods == null) {
                this.forbidEqualsMethods = new ArrayList<String>();
            }
            this.forbidEqualsMethods.add(method);
        }
    }

    static int getCharType(char ch) {
        switch (ch) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return 0;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return 1;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return 2;
            }
            case '.': {
                return 3;
            }
            case '\"': {
                return 4;
            }
            case '\'': {
                return 5;
            }
            case '`': {
                return 6;
            }
            case '\\': {
                return 7;
            }
            case '(': 
            case ')': 
            case '[': 
            case ']': {
                return 8;
            }
        }
        return 9;
    }

    private int getTokenOffset(Token token) {
        int offset = token.getOffset();
        String msg = token.getMessage();
        Matcher matcher = BLANK_PATTERN.matcher(msg);
        if (matcher.find()) {
            return offset + matcher.group(1).length();
        }
        if (offset < 0) {
            offset = 0;
        }
        return offset;
    }

    private UnaryOperator createUnaryOperator(String name, int priority, int offset) {
        if ("+".equals(name)) {
            return new PositiveOperator(name, priority, offset);
        }
        if ("-".equals(name)) {
            return new NegativeOperator(name, priority, offset);
        }
        if ("!".equals(name)) {
            return new NotOperator(name, priority, offset);
        }
        if ("~".equals(name)) {
            return new BitNotOperator(name, priority, offset);
        }
        if ("[".equals(name)) {
            return new ListOperator(name, priority, offset);
        }
        if (name.startsWith("new ")) {
            return new NewOperator(name.substring(4), priority, offset);
        }
        if (StringUtils.isFunction(name)) {
            return new StaticMethodOperator(name.substring(1), priority, offset);
        }
        if (StringUtils.isTyped(name)) {
            return new CastOperator(name, priority, offset);
        }
        throw new UnsupportedOperationException("Unsupported unary operator " + name);
    }

    private BinaryOperator createBinaryOperator(String name, int priority, int offset) {
        if ("+".equals(name)) {
            return new AddOperator(name, priority, offset);
        }
        if ("-".equals(name)) {
            return new SubOperator(name, priority, offset);
        }
        if ("*".equals(name)) {
            return new MulOperator(name, priority, offset);
        }
        if ("/".equals(name)) {
            return new DivOperator(name, priority, offset);
        }
        if ("%".equals(name)) {
            return new ModOperator(name, priority, offset);
        }
        if ("==".equals(name)) {
            return new EqualsOperator(name, priority, offset);
        }
        if ("!=".equals(name)) {
            return new NotEqualsOperator(name, priority, offset);
        }
        if (">".equals(name)) {
            return new GreaterOperator(name, priority, offset);
        }
        if (">=".equals(name)) {
            return new GreaterEqualsOperator(name, priority, offset);
        }
        if ("<".equals(name)) {
            return new LessOperator(name, priority, offset);
        }
        if ("<=".equals(name)) {
            return new LessEqualsOperator(name, priority, offset);
        }
        if ("&&".equals(name)) {
            return new AndOperator(name, priority, offset);
        }
        if ("||".equals(name)) {
            return new OrOperator(name, priority, offset);
        }
        if ("&".equals(name)) {
            return new BitAndOperator(name, priority, offset);
        }
        if ("|".equals(name)) {
            return new BitOrOperator(name, priority, offset);
        }
        if ("^".equals(name)) {
            return new BitXorOperator(name, priority, offset);
        }
        if (">>".equals(name)) {
            return new RightShiftOperator(name, priority, offset);
        }
        if ("<<".equals(name)) {
            return new LeftShiftOperator(name, priority, offset);
        }
        if (">>>".equals(name)) {
            return new UnsignShiftOperator(name, priority, offset);
        }
        if (",".equals(name)) {
            return new ArrayOperator(name, priority, offset);
        }
        if ("?".equals(name)) {
            return new ConditionOperator(name, priority, offset);
        }
        if (":".equals(name)) {
            return new EntryOperator(name, priority, offset);
        }
        if ("instanceof".equals(name)) {
            return new InstanceofOperator(name, priority, offset);
        }
        if ("[".equals(name)) {
            return new IndexOperator(name, priority, offset);
        }
        if ("..".equals(name)) {
            return new SequenceOperator(name, priority, offset);
        }
        if (StringUtils.isFunction(name)) {
            return new MethodOperator(name.substring(1), priority, offset);
        }
        throw new UnsupportedOperationException("Unsupported binary operator " + name);
    }

    private int getPriority(String operator, boolean unary) {
        int priority = 1000;
        if (unary && operator.startsWith("new ")) {
            return priority;
        }
        --priority;
        if (StringUtils.isFunction(operator) || operator.equals("[")) {
            return priority;
        }
        --priority;
        if (unary) {
            return priority;
        }
        --priority;
        if ("*".equals(operator) || "/".equals(operator) || "%".equals(operator)) {
            return priority;
        }
        --priority;
        if ("+".equals(operator) || "-".equals(operator)) {
            return priority;
        }
        --priority;
        if (">>".equals(operator) || "<<".equals(operator) || ">>>".equals(operator)) {
            return priority;
        }
        --priority;
        if ("..".equals(operator)) {
            return priority;
        }
        --priority;
        if (">".equals(operator) || "<".equals(operator) || ">=".equals(operator) || "<=".equals(operator) || "instanceof".equals(operator)) {
            return priority;
        }
        --priority;
        if ("==".equals(operator) || "!=".equals(operator)) {
            return priority;
        }
        --priority;
        if ("&".equals(operator)) {
            return priority;
        }
        --priority;
        if ("^".equals(operator)) {
            return priority;
        }
        --priority;
        if ("|".equals(operator)) {
            return priority;
        }
        --priority;
        if ("&&".equals(operator)) {
            return priority;
        }
        --priority;
        if ("||".equals(operator)) {
            return priority;
        }
        --priority;
        if ("?".equals(operator) || ":".equals(operator)) {
            return priority;
        }
        --priority;
        if (",".equals(operator)) {
            return priority;
        }
        return priority;
    }

    private boolean isPackageName(String msg) {
        return StringUtils.isNamed(msg) || StringUtils.isFunction(msg);
    }

    @Override
    public Expression parse(String source, int offset) throws ParseException {
        if (this.expressionFilter != null) {
            source = this.expressionFilter.filter(source, source);
        }
        LinkedStack<Expression> parameterStack = new LinkedStack<Expression>();
        LinkedStack<Operator> operatorStack = new LinkedStack<Operator>();
        HashMap<Operator, Token> operatorTokens = new HashMap<Operator, Token>();
        List<Token> tokens = scanner.scan(source, offset, true);
        boolean beforeOperator = true;
        for (int i = 0; i < tokens.size(); ++i) {
            boolean empty;
            Operator operator;
            Object value;
            Token token = tokens.get(i);
            String msg = token.getMessage().trim();
            if (msg.length() == 0) continue;
            if ("new".equals(msg)) {
                StringBuilder buf = new StringBuilder();
                while (i + 1 < tokens.size() && this.isPackageName(tokens.get(i + 1).getMessage().trim())) {
                    buf.append(tokens.get(i + 1).getMessage().trim());
                    ++i;
                }
                try {
                    msg = "new " + buf.toString();
                }
                catch (Exception e) {
                    throw new ParseException(e.getMessage(), token.getOffset());
                }
            } else if ("@".equals(msg)) {
                StringBuilder buf = new StringBuilder();
                buf.append(msg);
                while (i + 2 < tokens.size() && this.isPackageName(tokens.get(i + 1).getMessage().trim()) && this.isPackageName(tokens.get(i + 2).getMessage().trim())) {
                    buf.append(tokens.get(i + 1).getMessage().trim());
                    ++i;
                }
                try {
                    msg = buf.toString();
                }
                catch (Exception e) {
                    throw new ParseException(e.getMessage(), token.getOffset());
                }
            } else if ("gt".equals(msg)) {
                msg = ">";
            } else if ("ge".equals(msg)) {
                msg = ">=";
            } else if ("lt".equals(msg)) {
                msg = ">";
            } else if ("le".equals(msg)) {
                msg = "<=";
            } else if ("is".equals(msg)) {
                msg = "instanceof";
            } else if (!"null".equals(msg) && !"true".equals(msg) && !"false".equals(msg) && StringUtils.isNamed(msg)) {
                String pre;
                if (i < tokens.size() - 1) {
                    String next = tokens.get(i + 1).getMessage().trim();
                    if ("(".equals(next)) {
                        msg = "." + msg;
                    } else if (")".equals(next) && i > 0 && i < tokens.size() - 2) {
                        String prev = tokens.get(i - 1).getMessage().trim();
                        String after = tokens.get(i + 2).getMessage().trim();
                        if ("(".equals(prev) && ("(".equals(after) || StringUtils.isNamed(after))) {
                            Operator left = operatorStack.pop();
                            if (left != Bracket.ROUND) {
                                throw new ParseException("Miss left parenthesis", token.getOffset());
                            }
                            UnaryOperator operator2 = this.createUnaryOperator(msg, this.getPriority(msg, true), this.getTokenOffset(token));
                            operatorTokens.put(operator2, token);
                            operatorStack.push(operator2);
                            beforeOperator = true;
                            ++i;
                            continue;
                        }
                    }
                }
                if (i > 0 && ("is".equals(pre = tokens.get(i - 1).getMessage().trim()) || "instanceof".equals(pre))) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("@");
                    buf.append(msg);
                    while (i + 1 < tokens.size() && this.isPackageName(tokens.get(i + 1).getMessage().trim())) {
                        buf.append(tokens.get(i + 1).getMessage().trim());
                        ++i;
                    }
                    msg = buf.toString();
                }
            }
            if (msg.length() >= 2 && (msg.startsWith("\"") && msg.endsWith("\"") || msg.startsWith("'") && msg.endsWith("'") || msg.startsWith("`") && msg.endsWith("`"))) {
                value = StringUtils.unescapeString(msg.substring(1, msg.length() - 1));
                if (msg.startsWith("`") && ((String)value).length() == 1) {
                    parameterStack.push(new Constant(Character.valueOf(((String)value).charAt(0)), false, token.getOffset()));
                } else if (msg.startsWith("`") && ((String)value).length() == 2 && ((String)value).charAt(0) == '\\') {
                    parameterStack.push(new Constant(Character.valueOf(((String)value).charAt(1)), true, token.getOffset()));
                } else {
                    parameterStack.push(new Constant(StringUtils.unescapeString((String)value), false, token.getOffset()));
                }
                beforeOperator = false;
                continue;
            }
            if (StringUtils.isNumber(msg)) {
                boolean boxed = false;
                if (msg.endsWith("b") || msg.endsWith("B")) {
                    value = Byte.valueOf(msg.substring(0, msg.length() - 1));
                    boxed = msg.endsWith("B");
                } else if (msg.endsWith("s") || msg.endsWith("S")) {
                    value = Short.valueOf(msg.substring(0, msg.length() - 1));
                    boxed = msg.endsWith("S");
                } else if (msg.endsWith("i") || msg.endsWith("I")) {
                    value = Integer.valueOf(msg.substring(0, msg.length() - 1));
                    boxed = msg.endsWith("I");
                } else if (msg.endsWith("l") || msg.endsWith("L")) {
                    value = Long.valueOf(msg.substring(0, msg.length() - 1));
                    boxed = msg.endsWith("L");
                } else if (msg.endsWith("f") || msg.endsWith("F")) {
                    value = Float.valueOf(msg.substring(0, msg.length() - 1));
                    boxed = msg.endsWith("F");
                } else if (msg.endsWith("d") || msg.endsWith("D")) {
                    value = Double.valueOf(msg.substring(0, msg.length() - 1));
                    boxed = msg.endsWith("D");
                } else {
                    value = msg.indexOf(46) >= 0 ? (Number)Double.valueOf(msg) : (Number)Integer.valueOf(msg);
                }
                parameterStack.push(new Constant(value, boxed, token.getOffset()));
                beforeOperator = false;
                continue;
            }
            if ("null".equals(msg)) {
                parameterStack.push(new Constant(null, false, token.getOffset()));
                beforeOperator = false;
                continue;
            }
            if ("true".equals(msg) || "false".equals(msg)) {
                parameterStack.push(new Constant("true".equals(msg) ? Boolean.TRUE : Boolean.FALSE, false, token.getOffset()));
                beforeOperator = false;
                continue;
            }
            if ("TRUE".equals(msg) || "FALSE".equals(msg)) {
                parameterStack.push(new Constant("TRUE".equals(msg) ? Boolean.TRUE : Boolean.FALSE, true, token.getOffset()));
                beforeOperator = false;
                continue;
            }
            if (msg.length() > 1 && msg.startsWith("@")) {
                parameterStack.push(new Constant(ClassUtils.forName(this.importPackages, msg.substring(1).trim()), false, token.getOffset()));
                beforeOperator = false;
                continue;
            }
            if (StringUtils.isNamed(msg) && !"instanceof".equals(msg)) {
                parameterStack.push(new Variable(msg, this.getTokenOffset(token)));
                beforeOperator = false;
                continue;
            }
            if ("(".equals(msg)) {
                operatorStack.push(Bracket.ROUND);
                beforeOperator = true;
                continue;
            }
            if (")".equals(msg)) {
                while (this.popOperator(parameterStack, operatorStack, operatorTokens, offset) != Bracket.ROUND) {
                }
                beforeOperator = false;
                continue;
            }
            if ("]".equals(msg)) {
                while (this.popOperator(parameterStack, operatorStack, operatorTokens, offset) != Bracket.SQUARE) {
                }
                beforeOperator = false;
                continue;
            }
            if (StringUtils.isFunction(msg)) {
                String method = msg.substring(1);
                if (this.forbidEqualsMethods != null) {
                    for (String forbid : this.forbidEqualsMethods) {
                        if (!method.equals(forbid)) continue;
                        throw new ParseException("Forbid call method " + method + " by forbid.method=" + forbid + " config.", offset);
                    }
                }
                if (this.forbidStartsMethods != null) {
                    for (String forbid : this.forbidStartsMethods) {
                        if (!method.startsWith(forbid)) continue;
                        throw new ParseException("Forbid call method " + method + " by forbid.method=" + forbid + "* config.", offset);
                    }
                }
                if (this.forbidEndsMethods != null) {
                    for (String forbid : this.forbidEndsMethods) {
                        if (!method.endsWith(forbid)) continue;
                        throw new ParseException("Forbid call method " + method + " by forbid.method=*" + forbid + " config.", offset);
                    }
                }
            }
            if (beforeOperator) {
                if (!(msg.startsWith("new ") || StringUtils.isFunction(msg) || UNARY_OPERATORS.contains(msg))) {
                    throw new ParseException("Unsupported binary operator " + msg, this.getTokenOffset(token));
                }
                operator = this.createUnaryOperator(msg, this.getPriority(msg, true), this.getTokenOffset(token));
                operatorTokens.put(operator, token);
                operatorStack.push(operator);
            } else {
                if (!StringUtils.isFunction(msg) && !BINARY_OPERATORS.contains(msg)) {
                    throw new ParseException("Unsupported binary operator " + msg, this.getTokenOffset(token));
                }
                operator = this.createBinaryOperator(msg, this.getPriority(msg, false), this.getTokenOffset(token));
                operatorTokens.put(operator, token);
                while (!operatorStack.isEmpty() && !(operatorStack.peek() instanceof Bracket) && operatorStack.peek().getPriority() >= operator.getPriority()) {
                    this.popOperator(parameterStack, operatorStack, operatorTokens, offset);
                }
                operatorStack.push(operator);
            }
            if ("[".equals(msg)) {
                operatorStack.push(Bracket.SQUARE);
            }
            beforeOperator = true;
            if (!msg.startsWith("new ") && !StringUtils.isFunction(msg)) continue;
            boolean miss = i == tokens.size() - 1 || !"(".equals(tokens.get(i + 1).getMessage().trim());
            boolean bl = empty = i < tokens.size() - 2 && "(".equals(tokens.get(i + 1).getMessage().trim()) && ")".equals(tokens.get(i + 2).getMessage().trim());
            if (miss || empty) {
                parameterStack.push(new Constant(null, true, token.getOffset()));
                beforeOperator = false;
            }
            if (!empty) continue;
            i += 2;
        }
        while (!operatorStack.isEmpty()) {
            Operator operator = this.popOperator(parameterStack, operatorStack, operatorTokens, offset);
            if (operator != Bracket.ROUND && operator != Bracket.SQUARE) continue;
            throw new ParseException("Miss right parenthesis", offset);
        }
        Expression result = (Expression)parameterStack.pop();
        if (!parameterStack.isEmpty()) {
            Expression parent = parameterStack.pop();
            throw new ParseException("Miss parameter in the operator " + parent, parent.getOffset());
        }
        return result;
    }

    private Operator popOperator(LinkedStack<Expression> parameterStack, LinkedStack<Operator> operatorStack, Map<Operator, Token> operatorTokens, int offset) throws ParseException {
        if (operatorStack.isEmpty()) {
            throw new ParseException("Miss left parenthesis", offset);
        }
        Operator operator = operatorStack.pop();
        if (operator instanceof BinaryOperator) {
            Token token = operatorTokens.get(operator);
            BinaryOperator binaryOperator = (BinaryOperator)operator;
            if (parameterStack.isEmpty()) {
                throw new ParseException("Binary operator " + binaryOperator.getName() + " miss parameter", token == null ? offset : this.getTokenOffset(token));
            }
            binaryOperator.setRightParameter(parameterStack.pop());
            if (parameterStack.isEmpty()) {
                throw new ParseException("Binary operator " + binaryOperator.getName() + " miss parameter", token == null ? offset : this.getTokenOffset(token));
            }
            binaryOperator.setLeftParameter(parameterStack.pop());
            parameterStack.push(operator);
        } else if (operator instanceof UnaryOperator) {
            Token token = operatorTokens.get(operator);
            UnaryOperator unaryOperator = (UnaryOperator)operator;
            if (parameterStack.isEmpty()) {
                throw new ParseException("Unary operator " + unaryOperator.getName() + "miss parameter", token == null ? offset : this.getTokenOffset(token));
            }
            unaryOperator.setParameter(parameterStack.pop());
            parameterStack.push(operator);
        }
        return operator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bracket
    extends Operator {
        public static final Bracket ROUND = new Bracket("(");
        public static final Bracket SQUARE = new Bracket("[");

        private Bracket(String name) {
            super(name, Integer.MAX_VALUE, 0);
        }

        @Override
        public List<Node> getChildren() {
            return Collections.EMPTY_LIST;
        }
    }
}

