/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.methods;

import httl.util.Base64;
import httl.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class EscapeMethod {
    private EscapeMethod() {
    }

    public static String escapeString(String value) {
        return StringUtils.escapeString(value);
    }

    public static String unescapeString(String value) {
        return StringUtils.unescapeString(value);
    }

    public static String escapeXml(String value) {
        return StringUtils.escapeXml(value);
    }

    public static String unescapeXml(String value) {
        return StringUtils.unescapeXml(value);
    }

    public static String escapeUrl(String value) {
        return EscapeMethod.escapeUrl(value, "UTF-8");
    }

    public static String escapeUrl(String value, String encoding) {
        try {
            return value == null ? null : URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String unescapeUrl(String value) {
        return EscapeMethod.unescapeUrl(value, "UTF-8");
    }

    public static String unescapeUrl(String value, String encoding) {
        try {
            return value == null ? null : URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String escapeBase64(String value) {
        return value == null ? null : Base64.encodeBytes(value.getBytes());
    }

    public static String unescapeBase64(String value) {
        try {
            return value == null ? null : new String(Base64.decode(value));
        }
        catch (IOException e) {
            return value;
        }
    }
}

