/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loggers;

import httl.spi.Logger;
import httl.spi.loggers.JclLogger;
import httl.spi.loggers.JdkLogger;
import httl.spi.loggers.Log4jLogger;
import httl.spi.loggers.SimpleLogger;
import httl.spi.loggers.Slf4jLogger;
import httl.util.Version;

public class MultiLogger
implements Logger {
    private Logger[] loggers;

    public void setLoggers(Logger[] loggers) {
        this.loggers = loggers;
    }

    public void init() {
        if (this.loggers == null) {
            try {
                this.setLoggers(new Logger[]{new Slf4jLogger()});
                this.info("Using slf4j logger for httl.");
            }
            catch (Throwable e1) {
                try {
                    this.setLoggers(new Logger[]{new JclLogger()});
                    this.info("Using jcl logger for httl.");
                }
                catch (Throwable e2) {
                    try {
                        this.setLoggers(new Logger[]{new Log4jLogger()});
                        this.info("Using log4j logger for httl.");
                    }
                    catch (Throwable e3) {
                        try {
                            this.setLoggers(new Logger[]{new JdkLogger()});
                            this.info("Using jdk logger for httl.");
                        }
                        catch (Throwable e4) {
                            this.setLoggers(new Logger[]{new SimpleLogger()});
                        }
                    }
                }
            }
        }
    }

    private String appendEnvInfo(Throwable e) {
        return this.appendEnvInfo(e == null ? "" : e.getMessage());
    }

    private String appendEnvInfo(String msg) {
        return msg + ", httl: " + Version.getVersion() + ", jvm: " + System.getProperty("java.version") + ", os: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
    }

    public void trace(String msg, Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.trace(this.appendEnvInfo(msg), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void trace(Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.trace(this.appendEnvInfo(e), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void trace(String msg) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.trace(this.appendEnvInfo(msg));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void debug(String msg, Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.debug(this.appendEnvInfo(msg), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void debug(Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.debug(this.appendEnvInfo(e), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void debug(String msg) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.debug(this.appendEnvInfo(msg));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void info(String msg, Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.info(this.appendEnvInfo(msg), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void info(Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.info(this.appendEnvInfo(e), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void info(String msg) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.info(this.appendEnvInfo(msg));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void warn(String msg, Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.warn(this.appendEnvInfo(msg), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void warn(Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.warn(this.appendEnvInfo(e), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void warn(String msg) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.warn(this.appendEnvInfo(msg));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void error(String msg, Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.error(this.appendEnvInfo(msg), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void error(Throwable e) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.error(this.appendEnvInfo(e), e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void error(String msg) {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    logger.error(this.appendEnvInfo(msg));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isTraceEnabled() {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    if (!logger.isTraceEnabled()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isDebugEnabled() {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    if (!logger.isDebugEnabled()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isInfoEnabled() {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    if (!logger.isInfoEnabled()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isWarnEnabled() {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    if (!logger.isWarnEnabled()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isErrorEnabled() {
        try {
            if (this.loggers != null) {
                for (Logger logger : this.loggers) {
                    if (!logger.isErrorEnabled()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

