/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders.resources;

import httl.Engine;
import httl.spi.loaders.resources.AbstractResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;

public class StringResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private final String source;

    public StringResource(Engine engine, String name, Locale locale, String encoding, String source) {
        super(engine, name, locale, encoding);
        this.source = source;
    }

    public StringResource(Engine engine, String name, Locale locale, String encoding, long lastModified, String source) {
        super(engine, name, locale, encoding, lastModified);
        this.source = source;
    }

    public long getLength() {
        return this.source.length();
    }

    public Reader openReader() throws IOException {
        return new StringReader(this.source);
    }

    public InputStream openStream() throws IOException {
        return new ByteArrayInputStream(this.source.getBytes(this.getEncoding()));
    }
}

