/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders.resources;

import httl.Engine;
import httl.spi.loaders.resources.InputStreamResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.jar.JarFile;

public class JarResource
extends InputStreamResource {
    private static final long serialVersionUID = 1L;
    private final File file;

    public JarResource(Engine engine, String name, Locale locale, String encoding, File file) {
        super(engine, name, locale, encoding);
        this.file = file;
    }

    public InputStream openStream() throws IOException {
        JarFile jarFile = new JarFile(this.file);
        return jarFile.getInputStream(jarFile.getEntry(this.getName()));
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        long l;
        JarFile jarFile = new JarFile(this.file);
        try {
            l = jarFile.getEntry(this.getName()).getSize();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                return super.getLength();
            }
        }
        jarFile.close();
        return l;
    }
}

