/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.loaders;

import httl.Resource;
import httl.spi.Loader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLoader
implements Loader {
    private Loader[] loaders;

    public void setLoaders(Loader[] loaders) {
        this.loaders = loaders;
    }

    @Override
    public Resource load(String name, Locale locale, String encoding) throws IOException {
        if (this.loaders.length == 1) {
            return this.loaders[0].load(name, locale, encoding);
        }
        for (Loader loader : this.loaders) {
            try {
                if (!loader.exists(name, locale)) continue;
                return loader.load(name, locale, encoding);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new FileNotFoundException("No such template file: " + name);
    }

    @Override
    public List<String> list(String suffix) throws IOException {
        if (this.loaders.length == 1) {
            return this.loaders[0].list(suffix);
        }
        ArrayList<String> all = new ArrayList<String>();
        for (Loader loader : this.loaders) {
            try {
                List<String> list = loader.list(suffix);
                if (list == null || list.size() <= 0) continue;
                all.addAll(list);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return all;
    }

    @Override
    public boolean exists(String name, Locale locale) {
        if (this.loaders.length == 1) {
            return this.loaders[0].exists(name, locale);
        }
        for (Loader loader : this.loaders) {
            try {
                if (!loader.exists(name, locale)) continue;
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }
}

