/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.formatters;

import httl.Resource;
import httl.Template;
import httl.ast.Expression;
import httl.spi.Formatter;
import httl.util.ClassComparator;
import httl.util.ClassUtils;
import httl.util.DateUtils;
import httl.util.IOUtils;
import httl.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFormatter
implements Formatter<Object> {
    private final Map<Class<?>, Formatter<?>> formatters = new ConcurrentHashMap();
    private Map<Class<?>, Formatter<?>> sortedFormatters;
    private Formatter<Object> formatter;
    private Formatter<Boolean> booleanFormatter;
    private Formatter<Number> byteFormatter;
    private Formatter<Character> charFormatter;
    private Formatter<Number> shortFormatter;
    private Formatter<Number> intFormatter;
    private Formatter<Number> longFormatter;
    private Formatter<Number> floatFormatter;
    private Formatter<Number> doubleFormatter;
    private Formatter<Number> numberFormatter;
    private Formatter<Date> dateFormatter;
    private String nullValue;
    private String trueValue;
    private String falseValue;
    private char[] nullValueChars;
    private char[] trueValueChars;
    private char[] falseValueChars;
    private byte[] nullValueBytes;
    private byte[] trueValueBytes;
    private byte[] falseValueBytes;
    private String outputEncoding;

    public MultiFormatter() {
    }

    public MultiFormatter(Formatter<?> formatter) {
        this.setFormatters(new Formatter[]{formatter});
        this.init();
    }

    public void init() {
        if (this.nullValue == null) {
            this.setNullValue("");
        }
        if (this.trueValue == null) {
            this.setTrueValue("true");
        }
        if (this.falseValue == null) {
            this.setFalseValue("false");
        }
        this.numberFormatter = this.get(Number.class);
        this.booleanFormatter = this.get(Boolean.class);
        this.byteFormatter = this.getFormatter(Byte.class, this.numberFormatter);
        this.charFormatter = this.get(Character.class);
        this.shortFormatter = this.getFormatter(Short.class, this.numberFormatter);
        this.intFormatter = this.getFormatter(Integer.class, this.numberFormatter);
        this.longFormatter = this.getFormatter(Long.class, this.numberFormatter);
        this.floatFormatter = this.getFormatter(Float.class, this.numberFormatter);
        this.doubleFormatter = this.getFormatter(Double.class, this.numberFormatter);
        this.dateFormatter = this.get(Date.class);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
        this.nullValueChars = nullValue.toCharArray();
        this.nullValueBytes = this.toBytes(nullValue, nullValue);
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
        this.trueValueChars = trueValue.toCharArray();
        this.trueValueBytes = this.toBytes(trueValue, trueValue);
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
        this.falseValueChars = falseValue.toCharArray();
        this.falseValueBytes = this.toBytes(falseValue, falseValue);
    }

    public MultiFormatter add(Formatter<?> ... formatters) {
        if (this.formatter != null) {
            MultiFormatter copy = new MultiFormatter();
            copy.formatters.putAll(this.formatters);
            copy.setFormatters(formatters);
            return copy;
        }
        return this;
    }

    public MultiFormatter remove(Formatter<?> ... formatters) {
        if (this.formatter != null) {
            MultiFormatter copy = new MultiFormatter();
            copy.formatters.putAll(this.formatters);
            if (formatters != null && formatters.length > 0) {
                for (Formatter<?> formatter : formatters) {
                    Class<?> type;
                    if (formatter == null || (type = ClassUtils.getGenericClass(formatter.getClass())) == null) continue;
                    this.formatters.remove(type);
                }
            }
            return copy;
        }
        return this;
    }

    public void setFormatters(Formatter<?>[] formatters) {
        if (formatters != null && formatters.length > 0) {
            for (Formatter<?> formatter : formatters) {
                Class<?> type;
                if (formatter == null || (type = ClassUtils.getGenericClass(formatter.getClass())) == null) continue;
                this.formatters.put(type, formatter);
            }
            TreeMap sorted = new TreeMap(ClassComparator.COMPARATOR);
            sorted.putAll(this.formatters);
            this.sortedFormatters = Collections.unmodifiableMap(sorted);
        }
    }

    private <T> Formatter<T> get(Class<T> type) {
        return this.formatters.get(type);
    }

    private Formatter<Number> getFormatter(Class<? extends Number> type, Formatter<Number> defaultFormatter) {
        Formatter<Number> formatter = this.get(type);
        if (formatter == null) {
            return defaultFormatter;
        }
        return formatter;
    }

    @Override
    public String toString(String key, boolean value) {
        if (this.booleanFormatter != null) {
            return this.booleanFormatter.toString(key, value);
        }
        return value ? this.trueValue : this.falseValue;
    }

    @Override
    public String toString(String key, byte value) {
        if (this.byteFormatter != null) {
            return this.byteFormatter.toString(key, value);
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, char value) {
        if (this.charFormatter != null) {
            return this.charFormatter.toString(key, Character.valueOf(value));
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, short value) {
        if (this.shortFormatter != null) {
            return this.shortFormatter.toString(key, value);
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, int value) {
        if (this.intFormatter != null) {
            return this.intFormatter.toString(key, value);
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, long value) {
        if (this.longFormatter != null) {
            return this.longFormatter.toString(key, value);
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, float value) {
        if (this.floatFormatter != null) {
            return this.floatFormatter.toString(key, Float.valueOf(value));
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, double value) {
        if (this.doubleFormatter != null) {
            return this.doubleFormatter.toString(key, value);
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, Boolean value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.booleanFormatter != null) {
            return this.booleanFormatter.toString(key, value);
        }
        return value != false ? this.trueValue : this.falseValue;
    }

    @Override
    public String toString(String key, Byte value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.byteFormatter != null) {
            return this.byteFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Character value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.charFormatter != null) {
            return this.charFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Short value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.shortFormatter != null) {
            return this.shortFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Integer value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.intFormatter != null) {
            return this.intFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Long value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.longFormatter != null) {
            return this.longFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Float value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.floatFormatter != null) {
            return this.floatFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Double value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.doubleFormatter != null) {
            return this.doubleFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Number value) {
        if (value == null) {
            return this.nullValue;
        }
        if (value instanceof Byte) {
            return this.toString(key, (Byte)value);
        }
        if (value instanceof Short) {
            return this.toString(key, (Short)value);
        }
        if (value instanceof Integer) {
            return this.toString(key, (Integer)value);
        }
        if (value instanceof Long) {
            return this.toString(key, (Long)value);
        }
        if (value instanceof Float) {
            return this.toString(key, (Float)value);
        }
        if (value instanceof Double) {
            return this.toString(key, (Double)value);
        }
        if (this.numberFormatter != null) {
            return this.numberFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, Date value) {
        if (value == null) {
            return this.nullValue;
        }
        if (this.dateFormatter != null) {
            return this.dateFormatter.toString(key, value);
        }
        return value.toString();
    }

    @Override
    public String toString(String key, byte[] value) {
        if (value == null) {
            return this.nullValue;
        }
        if (value.length == 0) {
            return "";
        }
        if (this.outputEncoding == null) {
            return new String(value);
        }
        try {
            return new String(value, this.outputEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(value);
        }
    }

    @Override
    public String toString(String key, char[] value) {
        if (value == null) {
            return this.nullValue;
        }
        return String.valueOf(value);
    }

    @Override
    public String toString(String key, String value) {
        if (value == null) {
            return this.nullValue;
        }
        return value;
    }

    @Override
    public String toString(String key, Template value) {
        try {
            return this.toString(key, value.evaluate());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String toString(String key, Resource value) {
        try {
            return IOUtils.readToString(value.openReader());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String toString(String key, Object value) {
        if (value == null) {
            return this.nullValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return this.toString(key, (Boolean)value);
        }
        if (value instanceof Character) {
            return this.toString(key, (Character)value);
        }
        if (value instanceof Number) {
            return this.toString(key, (Number)value);
        }
        if (value instanceof Date) {
            return this.toString(key, (Date)value);
        }
        if (value instanceof byte[]) {
            return this.toString(key, (byte[])value);
        }
        if (value instanceof Template) {
            return this.toString(key, (Template)value);
        }
        if (value instanceof Resource) {
            return this.toString(key, (Resource)value);
        }
        if (this.formatter != null) {
            return this.formatter.toString(key, value);
        }
        Class<?> cls = value.getClass();
        Formatter<?> formatter = this.formatters.get(cls);
        if (formatter != null) {
            return formatter.toString(key, value);
        }
        if (this.sortedFormatters != null) {
            for (Map.Entry<Class<?>, Formatter<?>> entry : this.sortedFormatters.entrySet()) {
                if (!entry.getKey().isAssignableFrom(cls)) continue;
                formatter = entry.getValue();
                this.formatters.put(cls, formatter);
                return formatter.toString(key, value);
            }
        }
        return StringUtils.toString(value);
    }

    @Override
    public char[] toChars(String key, boolean value) {
        if (this.booleanFormatter != null) {
            return this.booleanFormatter.toChars(key, value);
        }
        return value ? this.trueValueChars : this.falseValueChars;
    }

    @Override
    public char[] toChars(String key, byte value) {
        if (this.byteFormatter != null) {
            return this.byteFormatter.toChars(key, value);
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, char value) {
        if (this.charFormatter != null) {
            return this.charFormatter.toChars(key, Character.valueOf(value));
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, short value) {
        if (this.shortFormatter != null) {
            return this.shortFormatter.toChars(key, value);
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, int value) {
        if (this.intFormatter != null) {
            return this.intFormatter.toChars(key, value);
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, long value) {
        if (this.longFormatter != null) {
            return this.longFormatter.toChars(key, value);
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, float value) {
        if (this.floatFormatter != null) {
            return this.floatFormatter.toChars(key, Float.valueOf(value));
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, double value) {
        if (this.doubleFormatter != null) {
            return this.doubleFormatter.toChars(key, value);
        }
        return String.valueOf(value).toCharArray();
    }

    @Override
    public char[] toChars(String key, Boolean value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.booleanFormatter != null) {
            return this.booleanFormatter.toChars(key, value);
        }
        return value != false ? this.trueValueChars : this.falseValueChars;
    }

    @Override
    public char[] toChars(String key, Byte value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.byteFormatter != null) {
            return this.byteFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Character value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.charFormatter != null) {
            return this.charFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Short value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.shortFormatter != null) {
            return this.shortFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Integer value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.intFormatter != null) {
            return this.intFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Long value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.longFormatter != null) {
            return this.longFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Float value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.floatFormatter != null) {
            return this.floatFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Double value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.doubleFormatter != null) {
            return this.doubleFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Number value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (value instanceof Byte) {
            return this.toChars(key, (Byte)value);
        }
        if (value instanceof Short) {
            return this.toChars(key, (Short)value);
        }
        if (value instanceof Integer) {
            return this.toChars(key, (Integer)value);
        }
        if (value instanceof Long) {
            return this.toChars(key, (Long)value);
        }
        if (value instanceof Float) {
            return this.toChars(key, (Float)value);
        }
        if (value instanceof Double) {
            return this.toChars(key, (Double)value);
        }
        if (this.numberFormatter != null) {
            return this.numberFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, Date value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (this.dateFormatter != null) {
            return this.dateFormatter.toChars(key, value);
        }
        return value.toString().toCharArray();
    }

    @Override
    public char[] toChars(String key, byte[] value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (value.length == 0) {
            return new char[0];
        }
        if (this.outputEncoding == null) {
            return new String(value).toCharArray();
        }
        try {
            return new String(value, this.outputEncoding).toCharArray();
        }
        catch (UnsupportedEncodingException e) {
            return new String(value).toCharArray();
        }
    }

    @Override
    public char[] toChars(String key, char[] value) {
        if (value == null) {
            return this.nullValueChars;
        }
        return value;
    }

    @Override
    public char[] toChars(String key, String value) {
        if (value == null) {
            return this.nullValueChars;
        }
        return value.toCharArray();
    }

    @Override
    public char[] toChars(String key, Template value) {
        try {
            return this.toChars(key, value.evaluate());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public char[] toChars(String key, Resource value) {
        try {
            return IOUtils.readToChars(value.openReader());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public char[] toChars(String key, Object value) {
        if (value == null) {
            return this.nullValueChars;
        }
        if (value instanceof char[]) {
            return (char[])value;
        }
        if (value instanceof Boolean) {
            return this.toChars(key, (Boolean)value);
        }
        if (value instanceof Character) {
            return this.toChars(key, (Character)value);
        }
        if (value instanceof Number) {
            return this.toChars(key, (Number)value);
        }
        if (value instanceof Date) {
            return this.toChars(key, (Date)value);
        }
        if (value instanceof String) {
            return this.toChars(key, (String)value);
        }
        if (value instanceof Template) {
            return this.toChars(key, (Template)value);
        }
        if (value instanceof Expression) {
            return this.toChars(key, (Expression)value);
        }
        if (value instanceof Resource) {
            return this.toChars(key, (Resource)value);
        }
        if (this.formatter != null) {
            return this.formatter.toChars(key, value);
        }
        Class<?> cls = value.getClass();
        Formatter<?> formatter = this.formatters.get(cls);
        if (formatter != null) {
            return formatter.toChars(key, value);
        }
        if (this.sortedFormatters != null) {
            for (Map.Entry<Class<?>, Formatter<?>> entry : this.sortedFormatters.entrySet()) {
                if (!entry.getKey().isAssignableFrom(cls)) continue;
                formatter = entry.getValue();
                this.formatters.put(cls, formatter);
                return formatter.toChars(key, value);
            }
        }
        return this.toChars(key, StringUtils.toString(value));
    }

    @Override
    public byte[] toBytes(String key, boolean value) {
        if (this.booleanFormatter != null) {
            return this.booleanFormatter.toBytes(key, value);
        }
        return value ? this.trueValueBytes : this.falseValueBytes;
    }

    @Override
    public byte[] toBytes(String key, byte value) {
        if (this.byteFormatter != null) {
            return this.byteFormatter.toBytes(key, value);
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, char value) {
        if (this.charFormatter != null) {
            return this.charFormatter.toBytes(key, Character.valueOf(value));
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, short value) {
        if (this.shortFormatter != null) {
            return this.shortFormatter.toBytes(key, value);
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, int value) {
        if (this.intFormatter != null) {
            return this.intFormatter.toBytes(key, value);
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, long value) {
        if (this.longFormatter != null) {
            return this.longFormatter.toBytes(key, value);
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, float value) {
        if (this.floatFormatter != null) {
            return this.floatFormatter.toBytes(key, Float.valueOf(value));
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, double value) {
        if (this.doubleFormatter != null) {
            return this.doubleFormatter.toBytes(key, value);
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, Boolean value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.booleanFormatter != null) {
            return this.booleanFormatter.toBytes(key, value);
        }
        return value != false ? this.trueValueBytes : this.falseValueBytes;
    }

    @Override
    public byte[] toBytes(String key, Byte value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.byteFormatter != null) {
            return this.byteFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Character value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.charFormatter != null) {
            return this.charFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Short value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.shortFormatter != null) {
            return this.shortFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Integer value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.intFormatter != null) {
            return this.intFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Long value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.longFormatter != null) {
            return this.longFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Float value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.floatFormatter != null) {
            return this.floatFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Double value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.doubleFormatter != null) {
            return this.doubleFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Number value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (value instanceof Byte) {
            return this.toBytes(key, (Byte)value);
        }
        if (value instanceof Short) {
            return this.toBytes(key, (Short)value);
        }
        if (value instanceof Integer) {
            return this.toBytes(key, (Integer)value);
        }
        if (value instanceof Long) {
            return this.toBytes(key, (Long)value);
        }
        if (value instanceof Float) {
            return this.toBytes(key, (Float)value);
        }
        if (value instanceof Double) {
            return this.toBytes(key, (Double)value);
        }
        if (this.numberFormatter != null) {
            return this.numberFormatter.toBytes(key, value);
        }
        return this.toBytes(key, value.toString());
    }

    @Override
    public byte[] toBytes(String key, Date value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (this.dateFormatter != null) {
            return this.dateFormatter.toBytes(key, value);
        }
        return this.toBytes(key, DateUtils.format(value));
    }

    @Override
    public byte[] toBytes(String key, byte[] value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        return value;
    }

    @Override
    public byte[] toBytes(String key, char[] value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        return this.toBytes(key, String.valueOf(value));
    }

    @Override
    public byte[] toBytes(String key, String value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (value.length() == 0) {
            return new byte[0];
        }
        if (this.outputEncoding == null) {
            return value.getBytes();
        }
        try {
            return value.getBytes(this.outputEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return value.getBytes();
        }
    }

    @Override
    public byte[] toBytes(String key, Template value) {
        try {
            return this.toBytes(key, value.evaluate());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] toBytes(String key, Resource value) {
        try {
            return IOUtils.readToBytes(value.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] toBytes(String key, Object value) {
        if (value == null) {
            return this.nullValueBytes;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Boolean) {
            return this.toBytes(key, (Boolean)value);
        }
        if (value instanceof Character) {
            return this.toBytes(key, (Character)value);
        }
        if (value instanceof Number) {
            return this.toBytes(key, (Number)value);
        }
        if (value instanceof Date) {
            return this.toBytes(key, (Date)value);
        }
        if (value instanceof String) {
            return this.toBytes(key, (String)value);
        }
        if (value instanceof Template) {
            return this.toBytes(key, (Template)value);
        }
        if (value instanceof Expression) {
            return this.toBytes(key, (Expression)value);
        }
        if (value instanceof Resource) {
            return this.toBytes(key, (Resource)value);
        }
        if (this.formatter != null) {
            return this.formatter.toBytes(key, value);
        }
        Class<?> cls = value.getClass();
        Formatter<?> formatter = this.formatters.get(cls);
        if (formatter != null) {
            return formatter.toBytes(key, value);
        }
        if (this.sortedFormatters != null) {
            for (Map.Entry<Class<?>, Formatter<?>> entry : this.sortedFormatters.entrySet()) {
                if (!entry.getKey().isAssignableFrom(cls)) continue;
                formatter = entry.getValue();
                this.formatters.put(cls, formatter);
                return formatter.toBytes(key, value);
            }
        }
        return this.toBytes(key, StringUtils.toString(value));
    }
}

