/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.filters;

import httl.spi.filters.AbstractFilter;
import httl.util.DfaScanner;
import httl.util.Token;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class VelocitySyntaxFilter
extends AbstractFilter {
    private static final int E = -1;
    private static final int B = -2;
    private static final int S = -51;
    private static final int P = -104;
    private static final int O = -1000004;
    private static final int P2 = -107;
    private static final int O2 = -1000007;
    private static final int P3 = -128;
    private static final int O3 = -30000028;
    static final int[][] states = new int[][]{{1, 1, 2, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1}, {1, 1, -2, -2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1}, {1, 3, 9, -2, 6, 10, 1, 1, 12, 1, 26, 1, 1, 1, 1, 1, 1, 1, 1}, {30, 3, -2, -2, -2, -2, -104, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2}, {4, 4, 4, 4, 4, 4, -104, -1000004, 4, 4, 4, 4, 14, 16, 18, 4, 4, 4, 4}, {1, 27, -2, -2, 6, 1, 1, 1, 1, 1, -107, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, -2, -2, 1, 1, 1, 1, 1, 1, -107, 1, 1, 1, 1, 1, 1, 1, 1}, {7, 7, 7, 7, 7, 7, 7, 7, 7, 7, -107, -1000007, 20, 22, 24, 7, 7, 7, 7}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, -2, 9, 9}, {10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {10, 10, -1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12, 12, 12, 12, 12, 12}, {12, 12, -1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 14, 14, 15, 14, 14, 14}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 4, 16, 17, 16, 16, 16}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}, {18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 4, 19, 18, 18, 18}, {18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18}, {20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 7, 20, 20, 21, 20, 20, 20}, {20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20}, {22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 7, 22, 23, 22, 22, 22}, {22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22}, {24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 7, 25, 24, 24, 24}, {24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24}, {-2, 26, -2, -2, -2, -2, -104, -2, -2, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2}, {-2, 27, -2, -2, -2, -2, -128, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, 27, -2}, {28, 28, 28, 28, 28, 28, -128, -30000028, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28}, {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, 28, -2}, {30, -51, -51, -51, -51, -51, -104, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51}};
    private static DfaScanner scanner = new DfaScanner(){

        public int next(int state, char ch) {
            return states[state][VelocitySyntaxFilter.getCharType(ch)];
        }
    };
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$\\{?(\\w+)\\}?");
    private final AtomicInteger seq = new AtomicInteger();

    static int getCharType(char ch) {
        switch (ch) {
            case '\b': 
            case '\t': 
            case '\f': 
            case ' ': {
                return 0;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return 1;
            }
            case '#': {
                return 2;
            }
            case '$': {
                return 3;
            }
            case '!': {
                return 4;
            }
            case '*': {
                return 5;
            }
            case '(': {
                return 6;
            }
            case ')': {
                return 7;
            }
            case '[': {
                return 8;
            }
            case ']': {
                return 9;
            }
            case '{': {
                return 10;
            }
            case '}': {
                return 11;
            }
            case '\"': {
                return 12;
            }
            case '\'': {
                return 13;
            }
            case '`': {
                return 14;
            }
            case '\\': {
                return 15;
            }
            case '\n': 
            case '\r': {
                return 16;
            }
            case '.': {
                return 17;
            }
        }
        return 18;
    }

    public String filter(String key, String value) {
        try {
            StringBuilder buf = new StringBuilder();
            List<Token> tokens = scanner.scan(value, 0);
            for (Token token : tokens) {
                String message = token.getMessage();
                if (message.length() > 1) {
                    if (message.charAt(0) == '#') {
                        boolean isDirective = false;
                        if (message.charAt(1) >= 'a' && message.charAt(1) <= 'z') {
                            message = REFERENCE_PATTERN.matcher(message).replaceAll("$1");
                            isDirective = true;
                        } else if (message.length() > 2 && message.charAt(1) == '{' && message.charAt(message.length() - 1) == '}' && message.charAt(2) >= 'a' && message.charAt(2) <= 'z') {
                            message = "#" + message.substring(2, message.length() - 1) + "()";
                            isDirective = true;
                        } else if (message.startsWith("#[[") && message.endsWith("]]#")) {
                            message = "#[" + message.substring(3, message.length() - 3) + "]#";
                        }
                        if (isDirective) {
                            String expression;
                            int i = message.indexOf(40);
                            String name = i < 0 ? message.substring(1) : message.substring(1, i);
                            String string = expression = i < 0 ? "" : message.substring(i + 1, message.length() - 1).trim();
                            if ("include".equals(name)) {
                                message = "${read(" + expression + ")}";
                            } else if ("parse".equals(name)) {
                                message = "${include(" + expression + ")}";
                            } else if ("evaluate".equals(name)) {
                                message = "${render(" + expression + ")}";
                            } else if ("foreach".equals(name)) {
                                message = "#for(" + expression + ")#set(int velocityCount = for.count)";
                            } else if ("macro".equals(name)) {
                                String[] args = expression.split("\\s+");
                                StringBuilder sb = new StringBuilder();
                                if (args.length > 1) {
                                    for (String arg : args) {
                                        if (sb.length() > 0) {
                                            sb.append(",");
                                        }
                                        sb.append("Object ");
                                        sb.append(arg);
                                    }
                                    message = "#macro(" + args[0] + (sb.length() == 0 ? "" : "(" + sb + ")") + ")";
                                }
                            } else if ("define".equals(name)) {
                                message = "#macro(" + expression + " := _macro_" + expression + ")";
                            } else if ("stop".equals(name)) {
                                message = "#break";
                            } else if (name.startsWith("@")) {
                                name = name.substring(1);
                                String tmp = name + "_" + this.seq.incrementAndGet();
                                message = "#set(String bodyContent = " + tmp + ".evaluate())${" + name + "(" + expression + ")}#macro(" + tmp + ")";
                            } else if (!("set".equals(name) || "if".equals(name) || "elseif".equals(name) || "else".equals(name) || "break".equals(name) || "end".equals(name))) {
                                message = "${" + name + "(" + expression + ")}";
                            }
                        }
                    } else if (message.charAt(0) == '$') {
                        if (message.charAt(1) >= 'a' && message.charAt(1) <= 'z' || message.charAt(1) >= 'A' && message.charAt(1) <= 'Z') {
                            message = message.substring(1);
                        } else if (message.length() > 2 && message.charAt(1) == '!' && (message.charAt(2) >= 'a' && message.charAt(2) <= 'z' || message.charAt(2) >= 'A' && message.charAt(2) <= 'Z')) {
                            message = message.substring(2);
                        } else if (message.length() > 3 && message.charAt(0) == '$' && message.charAt(1) == '!' && message.charAt(2) == '{' && message.charAt(message.length() - 1) == '}') {
                            message = message.substring(2, message.length() - 1);
                        } else if (message.length() > 4 && message.charAt(0) == '$' && message.charAt(1) == '!' && message.charAt(2) == '{' && message.charAt(message.length() - 1) == '}') {
                            message = message.substring(3, message.length() - 1);
                        }
                        message = "${" + REFERENCE_PATTERN.matcher(message).replaceAll("$1") + "}";
                    }
                }
                buf.append(message);
            }
            return buf.toString();
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

