/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.filters;

import httl.spi.Filter;

public abstract class MultiFilter
implements Filter {
    private Filter[] filters;

    public void setFilters(Filter[] filters) {
        if (filters != null && filters.length > 0 && this.filters != null && this.filters.length > 0) {
            Filter[] oldFilters = this.filters;
            this.filters = new Filter[oldFilters.length + filters.length];
            System.arraycopy(oldFilters, 0, this.filters, 0, oldFilters.length);
            System.arraycopy(filters, 0, this.filters, oldFilters.length, filters.length);
        } else {
            this.filters = filters;
        }
    }

    public String filter(String key, String value) {
        if (this.filters == null || this.filters.length == 0) {
            return value;
        }
        if (this.filters.length == 1) {
            return this.filters[0].filter(key, value);
        }
        for (Filter filter : this.filters) {
            value = filter.filter(key, value);
        }
        return value;
    }

    public char[] filter(String key, char[] value) {
        if (this.filters == null || this.filters.length == 0) {
            return value;
        }
        if (this.filters.length == 1) {
            return this.filters[0].filter(key, value);
        }
        for (Filter filter : this.filters) {
            value = filter.filter(key, value);
        }
        return value;
    }

    public byte[] filter(String key, byte[] value) {
        if (this.filters == null || this.filters.length == 0) {
            return value;
        }
        if (this.filters.length == 1) {
            return this.filters[0].filter(key, value);
        }
        for (Filter filter : this.filters) {
            value = filter.filter(key, value);
        }
        return value;
    }
}

