/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.compilers;

import httl.spi.compilers.AbstractCompiler;
import httl.util.ClassUtils;
import httl.util.StringUtils;
import httl.util.UnsafeByteArrayInputStream;
import httl.util.UnsafeByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkCompiler
extends AbstractCompiler {
    private final JavaCompiler compiler;
    private final DiagnosticCollector<JavaFileObject> diagnosticCollector;
    private final StandardJavaFileManager standardJavaFileManager;
    private final ClassLoaderImpl classLoader;
    private final JavaFileManagerImpl javaFileManager;
    private final List<String> options = new ArrayList<String>();
    private final List<String> lintOptions = new ArrayList<String>();
    private boolean lintUnchecked;

    public JdkCompiler() {
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (this.compiler == null) {
            throw new IllegalStateException("Can not get system java compiler. Please run with JDK (NOT JVM), or configure the httl.properties: compiler=httl.spi.compilers.JavassistCompiler, and add javassist.jar.");
        }
        this.diagnosticCollector = new DiagnosticCollector();
        this.standardJavaFileManager = this.compiler.getStandardFileManager(this.diagnosticCollector, null, null);
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            contextLoader.loadClass(JdkCompiler.class.getName());
        }
        catch (ClassNotFoundException e) {
            contextLoader = JdkCompiler.class.getClassLoader();
        }
        ClassLoader loader = contextLoader;
        HashSet<File> files = new HashSet<File>();
        while (loader instanceof URLClassLoader && !loader.getClass().getName().equals("sun.misc.Launcher$AppClassLoader")) {
            URLClassLoader urlClassLoader = (URLClassLoader)loader;
            for (URL url : urlClassLoader.getURLs()) {
                files.add(new File(url.getFile()));
            }
            loader = loader.getParent();
        }
        if (files.size() > 0) {
            try {
                Iterable<? extends File> list = this.standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH);
                for (File file : list) {
                    files.add(file);
                }
                this.standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, files);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        final ClassLoader parentLoader = contextLoader;
        this.classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderImpl>(){

            @Override
            public ClassLoaderImpl run() {
                return new ClassLoaderImpl(parentLoader);
            }
        });
        this.javaFileManager = new JavaFileManagerImpl(this.standardJavaFileManager, this.classLoader);
        this.lintOptions.add("-Xlint:unchecked");
    }

    public void init() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(320);
            buf.append("JDK Compiler classpath locations:\n");
            buf.append("================\n");
            for (File file : this.standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) {
                buf.append(file.getAbsolutePath());
                buf.append("\n");
            }
            buf.append("================\n");
            this.logger.debug(buf.toString());
        }
    }

    public void setCompileVersion(String version) {
        if (StringUtils.isNotEmpty(version) && !version.equals(ClassUtils.getJavaVersion())) {
            this.options.add("-target");
            this.options.add(version);
            this.lintOptions.add("-target");
            this.lintOptions.add(version);
        }
    }

    public void setLintUnchecked(boolean lintUnchecked) {
        this.lintUnchecked = lintUnchecked;
    }

    @Override
    protected Class<?> doCompile(String name, String sourceCode) throws Exception {
        try {
            return this.doCompile(name, sourceCode, this.options);
        }
        catch (Exception e) {
            if (this.lintUnchecked && e.getMessage() != null && e.getMessage().contains("-Xlint:unchecked")) {
                return this.doCompile(name, sourceCode, this.lintOptions);
            }
            throw e;
        }
    }

    private Class<?> doCompile(String name, String sourceCode, List<String> options) throws Exception {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            int i = name.lastIndexOf(46);
            String packageName = i < 0 ? "" : name.substring(0, i);
            String className = i < 0 ? name : name.substring(i + 1);
            JavaFileObjectImpl javaFileObject = new JavaFileObjectImpl(className, sourceCode);
            this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + ".java", javaFileObject);
            Boolean result = this.compiler.getTask(null, this.javaFileManager, this.diagnosticCollector, options, null, Arrays.asList(javaFileObject)).call();
            if (result == null || !result.booleanValue()) {
                throw new IllegalStateException("Compilation failed. class: " + name + ", diagnostics: " + this.diagnosticCollector.getDiagnostics());
            }
            return this.classLoader.loadClass(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavaFileManagerImpl
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final ClassLoaderImpl classLoader;
        private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

        public JavaFileManagerImpl(JavaFileManager fileManager, ClassLoaderImpl classLoader) {
            super(fileManager);
            this.classLoader = classLoader;
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            FileObject o = this.fileObjects.get(this.uri(location, packageName, relativeName));
            if (o != null) {
                return o;
            }
            return super.getFileForInput(location, packageName, relativeName);
        }

        public void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObject file) {
            this.fileObjects.put(this.uri(location, packageName, relativeName), file);
        }

        private URI uri(JavaFileManager.Location location, String packageName, String relativeName) {
            return ClassUtils.toURI(location.getName() + '/' + packageName + '/' + relativeName);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
            JavaFileObjectImpl file = new JavaFileObjectImpl(qualifiedName, kind);
            this.classLoader.add(qualifiedName, file);
            return file;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
            if (file instanceof JavaFileObjectImpl) {
                return file.getName();
            }
            return super.inferBinaryName(loc, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                for (JavaFileObject file : this.fileObjects.values()) {
                    if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                    files.add(file);
                }
                files.addAll(this.classLoader.files());
            } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
                for (JavaFileObject file : this.fileObjects.values()) {
                    if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                    files.add(file);
                }
            }
            Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
            for (JavaFileObject file : result) {
                files.add(file);
            }
            return files;
        }
    }

    private static final class JavaFileObjectImpl
    extends SimpleJavaFileObject {
        private UnsafeByteArrayOutputStream bytecode;
        private final CharSequence source;

        public JavaFileObjectImpl(String baseName, CharSequence source) {
            super(ClassUtils.toURI(baseName + ".java"), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        JavaFileObjectImpl(String name, JavaFileObject.Kind kind) {
            super(ClassUtils.toURI(name), kind);
            this.source = null;
        }

        public JavaFileObjectImpl(URI uri, JavaFileObject.Kind kind) {
            super(uri, kind);
            this.source = null;
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
            if (this.source == null) {
                throw new UnsupportedOperationException("source == null");
            }
            return this.source;
        }

        public InputStream openInputStream() {
            return new UnsafeByteArrayInputStream(this.getByteCode());
        }

        public OutputStream openOutputStream() {
            this.bytecode = new UnsafeByteArrayOutputStream();
            return this.bytecode;
        }

        public byte[] getByteCode() {
            return this.bytecode.toByteArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassLoaderImpl
    extends ClassLoader {
        private final Map<String, JavaFileObject> classes;

        ClassLoaderImpl(ClassLoader parentClassLoader) {
            super(parentClassLoader);
            this.classes = new HashMap<String, JavaFileObject>();
        }

        Collection<JavaFileObject> files() {
            return Collections.unmodifiableCollection(this.classes.values());
        }

        @Override
        protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
            try {
                return super.findClass(qualifiedClassName);
            }
            catch (ClassNotFoundException e) {
                JavaFileObject file = this.classes.get(qualifiedClassName);
                if (file != null) {
                    byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
                    try {
                        JdkCompiler.this.saveBytecode(qualifiedClassName, bytes);
                    }
                    catch (IOException e2) {
                        throw new IllegalStateException(e2.getMessage(), e2);
                    }
                    return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
                }
                throw e;
            }
        }

        void add(String qualifiedClassName, JavaFileObject javaFile) {
            this.classes.put(qualifiedClassName, javaFile);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            String qualifiedClassName;
            JavaFileObjectImpl file;
            if (name.endsWith(".class") && (file = (JavaFileObjectImpl)this.classes.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
                return new UnsafeByteArrayInputStream(file.getByteCode());
            }
            return super.getResourceAsStream(name);
        }
    }
}

