/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.compilers;

import httl.spi.Compiler;
import httl.spi.Logger;
import httl.spi.compilers.AbstractCompiler;
import httl.spi.compilers.JavassistCompiler;
import httl.spi.compilers.JdkCompiler;
import httl.util.ClassUtils;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveCompiler
implements Compiler {
    private Compiler compiler;
    private Logger logger;
    private String codeDirectory;

    public void setLogger(Logger logger) {
        this.logger = logger;
        if (this.compiler instanceof AbstractCompiler) {
            ((AbstractCompiler)this.compiler).setLogger(logger);
        }
    }

    public void setCodeDirectory(String codeDirectory) {
        this.codeDirectory = codeDirectory;
        if (this.compiler instanceof AbstractCompiler) {
            ((AbstractCompiler)this.compiler).setCodeDirectory(codeDirectory);
        }
    }

    public void setLintUnchecked(boolean unchecked) {
        if (this.compiler instanceof JdkCompiler) {
            ((JdkCompiler)this.compiler).setLintUnchecked(unchecked);
        }
    }

    public void setCompileVersion(String version) {
        if (version == null || ClassUtils.isBeforeJava6(version)) {
            JavassistCompiler javassistCompiler = new JavassistCompiler();
            javassistCompiler.setLogger(this.logger);
            javassistCompiler.setCodeDirectory(this.codeDirectory);
            this.compiler = javassistCompiler;
        } else {
            JdkCompiler jdkCompiler = new JdkCompiler();
            jdkCompiler.setCompileVersion(version);
            jdkCompiler.setLogger(this.logger);
            jdkCompiler.setCodeDirectory(this.codeDirectory);
            this.compiler = jdkCompiler;
        }
    }

    public void init() {
        if (this.compiler == null) {
            this.setCompileVersion(ClassUtils.getJavaVersion());
        }
        if (this.compiler instanceof JdkCompiler) {
            ((JdkCompiler)this.compiler).init();
        }
    }

    @Override
    public Class<?> compile(String code) throws ParseException {
        return this.compiler.compile(code);
    }
}

