/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.codecs.json;

import httl.spi.codecs.json.JSONNode;
import httl.spi.codecs.json.JSONObject;
import httl.spi.codecs.json.JSONValue;
import httl.spi.codecs.json.JSONWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArray
implements JSONNode {
    private List<Object> mArray = new ArrayList<Object>();

    public Object get(int index) {
        return this.mArray.get(index);
    }

    public boolean getBoolean(int index, boolean def) {
        Object tmp = this.mArray.get(index);
        return tmp != null && tmp instanceof Boolean ? (Boolean)tmp : def;
    }

    public int getInt(int index, int def) {
        Object tmp = this.mArray.get(index);
        return tmp != null && tmp instanceof Number ? ((Number)tmp).intValue() : def;
    }

    public long getLong(int index, long def) {
        Object tmp = this.mArray.get(index);
        return tmp != null && tmp instanceof Number ? ((Number)tmp).longValue() : def;
    }

    public float getFloat(int index, float def) {
        Object tmp = this.mArray.get(index);
        return tmp != null && tmp instanceof Number ? ((Number)tmp).floatValue() : def;
    }

    public double getDouble(int index, double def) {
        Object tmp = this.mArray.get(index);
        return tmp != null && tmp instanceof Number ? ((Number)tmp).doubleValue() : def;
    }

    public String getString(int index) {
        Object tmp = this.mArray.get(index);
        return tmp == null ? null : tmp.toString();
    }

    public JSONArray getArray(int index) {
        Object tmp = this.mArray.get(index);
        return tmp == null ? null : (tmp instanceof JSONArray ? (JSONArray)tmp : null);
    }

    public JSONObject getObject(int index) {
        Object tmp = this.mArray.get(index);
        return tmp == null ? null : (tmp instanceof JSONObject ? (JSONObject)tmp : null);
    }

    public int length() {
        return this.mArray.size();
    }

    public void add(Object ele) {
        this.mArray.add(ele);
    }

    public void addAll(Object[] eles) {
        for (Object ele : eles) {
            this.mArray.add(ele);
        }
    }

    public void addAll(Collection<?> c) {
        this.mArray.addAll(c);
    }

    @Override
    public void writeJSON(JSONValue jc, JSONWriter jb, boolean writeClass) throws IOException {
        jb.arrayBegin();
        for (Object item : this.mArray) {
            if (item == null) {
                jb.valueNull();
                continue;
            }
            jc.writeValue(item, jb, writeClass);
        }
        jb.arrayEnd();
    }
}

