/*
 * Decompiled with CFR 0.152.
 */
package httl.spi.codecs;

import httl.spi.codecs.AbstractCodec;
import httl.util.StringUtils;
import java.util.Arrays;

public abstract class AbstractJsonCodec
extends AbstractCodec {
    private static final char[] NULL_CHARS = "null".toCharArray();
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();
    private static final byte[] NULL_BYTES = "null".getBytes();
    private static final byte[] TRUE_BYTES = "true".getBytes();
    private static final byte[] FALSE_BYTES = "false".getBytes();
    private boolean jsonWithClass;

    protected boolean isJsonWithClass() {
        return this.jsonWithClass;
    }

    public void setJsonWithClass(boolean jsonWithClass) {
        this.jsonWithClass = jsonWithClass;
    }

    public String getFormat() {
        return "json";
    }

    public boolean isValueOf(String str) {
        return StringUtils.isNotEmpty(str) && (str.startsWith("{") || str.startsWith("[") || str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'") || StringUtils.isNumber(str) || "null".equals(str) || "true".equals(str) || "false".equals(str));
    }

    public boolean isValueOf(char[] str) {
        return StringUtils.isNotEmpty(str) && (str[0] == '{' || str[0] == '[' || str.length > 1 && str[0] == '\"' && str[str.length - 1] == '\"' || str.length > 1 && str[0] == '\'' && str[str.length - 1] == '\'' || StringUtils.isNumber(str) || Arrays.equals(NULL_CHARS, str) || Arrays.equals(TRUE_CHARS, str) || Arrays.equals(FALSE_CHARS, str));
    }

    public boolean isValueOf(byte[] str) {
        return StringUtils.isNotEmpty(str) && (str[0] == 123 || str[0] == 91 || str.length > 1 && str[0] == 34 && str[str.length - 1] == 34 || str.length > 1 && str[0] == 39 && str[str.length - 1] == 39 || StringUtils.isNumber(str) || Arrays.equals(NULL_BYTES, str) || Arrays.equals(TRUE_BYTES, str) || Arrays.equals(FALSE_BYTES, str));
    }
}

