/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.Node;
import httl.Visitor;
import httl.ast.Directive;
import httl.ast.EndDirective;
import httl.ast.Expression;
import httl.ast.Statement;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockDirective
extends Directive {
    private List<Node> children;
    private EndDirective end;

    public BlockDirective(int offset) {
        super(offset);
    }

    @Override
    public void accept(Visitor visitor) throws IOException, ParseException {
        Expression expression = this.getExpression();
        if (expression != null) {
            expression.accept(visitor);
        }
        if (visitor.visit(this)) {
            if (this.children != null) {
                for (Node node : this.children) {
                    node.accept(visitor);
                }
            }
            if (this.end != null) {
                this.end.accept(visitor);
            }
        }
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public void setChildren(List<Node> children) throws ParseException {
        if (this.children != null) {
            throw new ParseException("Can not modify children.", this.getOffset());
        }
        this.children = children;
        for (Node node : children) {
            ((Statement)node).setParent(this);
        }
    }

    public EndDirective getEnd() {
        return this.end;
    }

    public void setEnd(EndDirective end) throws ParseException {
        if (this.end != null) {
            throw new ParseException("Can not modify end.", this.end.getOffset());
        }
        this.end = end;
        end.setStart(this);
    }
}

