/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.Node;
import httl.Visitor;
import httl.ast.Expression;
import httl.ast.Operator;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryOperator
extends Operator {
    private Expression leftParameter;
    private Expression rightParameter;

    public BinaryOperator(String name, int priority, int offset) {
        super(name, priority, offset);
    }

    @Override
    public void accept(Visitor visitor) throws IOException, ParseException {
        this.leftParameter.accept(visitor);
        this.rightParameter.accept(visitor);
        visitor.visit(this);
    }

    public Expression getLeftParameter() {
        return this.leftParameter;
    }

    public void setLeftParameter(Expression leftParameter) {
        if (this.leftParameter != null) {
            throw new IllegalStateException("Can not modify left parameter.");
        }
        this.leftParameter = leftParameter;
    }

    public Expression getRightParameter() {
        return this.rightParameter;
    }

    public void setRightParameter(Expression rightParameter) {
        if (this.rightParameter != null) {
            throw new IllegalStateException("Can not modify right parameter.");
        }
        this.rightParameter = rightParameter;
    }

    @Override
    public List<Node> getChildren() {
        return Arrays.asList(this.leftParameter, this.rightParameter);
    }

    @Override
    public String toString() {
        if (this.getParent() instanceof Operator && ((Operator)this.getParent()).getPriority() < this.getPriority()) {
            return "(" + this.leftParameter + " " + this.getName() + " " + this.rightParameter + ")";
        }
        return this.leftParameter + " " + this.getName() + " " + this.rightParameter;
    }
}

