/*
 * Decompiled with CFR 0.152.
 */
package httl.ast;

import httl.Node;
import httl.Template;
import httl.Visitor;
import httl.ast.AddOperator;
import httl.ast.AndOperator;
import httl.ast.ArrayOperator;
import httl.ast.BinaryOperator;
import httl.ast.BitAndOperator;
import httl.ast.BitNotOperator;
import httl.ast.BitOrOperator;
import httl.ast.BitXorOperator;
import httl.ast.BlockDirective;
import httl.ast.BreakDirective;
import httl.ast.CastOperator;
import httl.ast.Comment;
import httl.ast.ConditionOperator;
import httl.ast.Constant;
import httl.ast.DivOperator;
import httl.ast.ElseDirective;
import httl.ast.EndDirective;
import httl.ast.EntryOperator;
import httl.ast.EqualsOperator;
import httl.ast.Expression;
import httl.ast.ForDirective;
import httl.ast.GreaterEqualsOperator;
import httl.ast.GreaterOperator;
import httl.ast.IfDirective;
import httl.ast.IndexOperator;
import httl.ast.InstanceofOperator;
import httl.ast.LeftShiftOperator;
import httl.ast.LessEqualsOperator;
import httl.ast.LessOperator;
import httl.ast.LineDirective;
import httl.ast.ListOperator;
import httl.ast.MacroDirective;
import httl.ast.MethodOperator;
import httl.ast.ModOperator;
import httl.ast.MulOperator;
import httl.ast.NegativeOperator;
import httl.ast.NewOperator;
import httl.ast.NotEqualsOperator;
import httl.ast.NotOperator;
import httl.ast.OrOperator;
import httl.ast.PositiveOperator;
import httl.ast.RightShiftOperator;
import httl.ast.SequenceOperator;
import httl.ast.SetDirective;
import httl.ast.Statement;
import httl.ast.StaticMethodOperator;
import httl.ast.SubOperator;
import httl.ast.Text;
import httl.ast.UnaryOperator;
import httl.ast.UnsignShiftOperator;
import httl.ast.ValueDirective;
import httl.ast.Variable;
import httl.util.ClassUtils;
import java.io.IOException;
import java.text.ParseException;

public abstract class AstVisitor
implements Visitor {
    public boolean visit(Node node) throws IOException, ParseException {
        try {
            if (node instanceof Expression) {
                this.visit((Expression)node);
            } else {
                if (node instanceof Statement) {
                    return this.visit((Statement)node);
                }
                if (node instanceof Template) {
                    return this.visit((Template)node);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(ClassUtils.toString(e), node.getOffset());
        }
        return true;
    }

    public boolean visit(Statement node) throws IOException, ParseException {
        if (node instanceof Text) {
            this.visit((Text)node);
        } else if (node instanceof Comment) {
            this.visit((Comment)node);
        } else if (node instanceof LineDirective) {
            this.visit((LineDirective)node);
        } else {
            if (node instanceof BlockDirective) {
                return this.visit((BlockDirective)node);
            }
            if (node instanceof EndDirective) {
                this.visit((EndDirective)node);
            }
        }
        return true;
    }

    public void visit(LineDirective node) throws IOException, ParseException {
        if (node instanceof ValueDirective) {
            this.visit((ValueDirective)node);
        } else if (node instanceof SetDirective) {
            this.visit((SetDirective)node);
        } else if (node instanceof BreakDirective) {
            this.visit((BreakDirective)node);
        }
    }

    public boolean visit(BlockDirective node) throws IOException, ParseException {
        if (node instanceof IfDirective) {
            return this.visit((IfDirective)node);
        }
        if (node instanceof ElseDirective) {
            return this.visit((ElseDirective)node);
        }
        if (node instanceof ForDirective) {
            return this.visit((ForDirective)node);
        }
        if (node instanceof MacroDirective) {
            return this.visit((MacroDirective)node);
        }
        return true;
    }

    public void visit(EndDirective node) throws IOException, ParseException {
        BlockDirective start = node.getStart();
        if (start instanceof IfDirective) {
            this.end((IfDirective)start);
        } else if (start instanceof ElseDirective) {
            this.end((ElseDirective)start);
        } else if (start instanceof ForDirective) {
            this.end((ForDirective)start);
        } else if (start instanceof MacroDirective) {
            this.end((MacroDirective)start);
        }
    }

    public void visit(Expression node) throws IOException, ParseException {
        if (node instanceof Constant) {
            this.visit((Constant)node);
        } else if (node instanceof Variable) {
            this.visit((Variable)node);
        } else if (node instanceof UnaryOperator) {
            this.visit((UnaryOperator)node);
        } else if (node instanceof BinaryOperator) {
            this.visit((BinaryOperator)node);
        }
    }

    public void visit(UnaryOperator node) throws IOException, ParseException {
        if (node instanceof PositiveOperator) {
            this.visit((PositiveOperator)node);
        } else if (node instanceof NegativeOperator) {
            this.visit((NegativeOperator)node);
        } else if (node instanceof NotOperator) {
            this.visit((NotOperator)node);
        } else if (node instanceof BitNotOperator) {
            this.visit((BitNotOperator)node);
        } else if (node instanceof ListOperator) {
            this.visit((ListOperator)node);
        } else if (node instanceof NewOperator) {
            this.visit((NewOperator)node);
        } else if (node instanceof StaticMethodOperator) {
            this.visit((StaticMethodOperator)node);
        } else if (node instanceof CastOperator) {
            this.visit((CastOperator)node);
        }
    }

    public void visit(BinaryOperator node) throws IOException, ParseException {
        if (node instanceof AddOperator) {
            this.visit((AddOperator)node);
        } else if (node instanceof SubOperator) {
            this.visit((SubOperator)node);
        } else if (node instanceof MulOperator) {
            this.visit((MulOperator)node);
        } else if (node instanceof DivOperator) {
            this.visit((DivOperator)node);
        } else if (node instanceof ModOperator) {
            this.visit((ModOperator)node);
        } else if (node instanceof EqualsOperator) {
            this.visit((EqualsOperator)node);
        } else if (node instanceof NotEqualsOperator) {
            this.visit((NotEqualsOperator)node);
        } else if (node instanceof GreaterOperator) {
            this.visit((GreaterOperator)node);
        } else if (node instanceof GreaterEqualsOperator) {
            this.visit((GreaterEqualsOperator)node);
        } else if (node instanceof LessOperator) {
            this.visit((LessOperator)node);
        } else if (node instanceof LessEqualsOperator) {
            this.visit((LessEqualsOperator)node);
        } else if (node instanceof AndOperator) {
            this.visit((AndOperator)node);
        } else if (node instanceof OrOperator) {
            this.visit((OrOperator)node);
        } else if (node instanceof BitAndOperator) {
            this.visit((BitAndOperator)node);
        } else if (node instanceof BitOrOperator) {
            this.visit((BitOrOperator)node);
        } else if (node instanceof BitXorOperator) {
            this.visit((BitXorOperator)node);
        } else if (node instanceof RightShiftOperator) {
            this.visit((RightShiftOperator)node);
        } else if (node instanceof LeftShiftOperator) {
            this.visit((LeftShiftOperator)node);
        } else if (node instanceof UnsignShiftOperator) {
            this.visit((UnsignShiftOperator)node);
        } else if (node instanceof ArrayOperator) {
            this.visit((ArrayOperator)node);
        } else if (node instanceof ConditionOperator) {
            this.visit((ConditionOperator)node);
        } else if (node instanceof EntryOperator) {
            this.visit((EntryOperator)node);
        } else if (node instanceof InstanceofOperator) {
            this.visit((InstanceofOperator)node);
        } else if (node instanceof IndexOperator) {
            this.visit((IndexOperator)node);
        } else if (node instanceof SequenceOperator) {
            this.visit((SequenceOperator)node);
        } else if (node instanceof MethodOperator) {
            this.visit((MethodOperator)node);
        }
    }

    public void visit(Constant node) throws IOException, ParseException {
    }

    public void visit(Variable node) throws IOException, ParseException {
    }

    public void visit(PositiveOperator node) throws IOException, ParseException {
    }

    public void visit(NegativeOperator node) throws IOException, ParseException {
    }

    public void visit(NotOperator node) throws IOException, ParseException {
    }

    public void visit(BitNotOperator node) throws IOException, ParseException {
    }

    public void visit(ListOperator node) throws IOException, ParseException {
    }

    public void visit(NewOperator node) throws IOException, ParseException {
    }

    public void visit(StaticMethodOperator node) throws IOException, ParseException {
    }

    public void visit(CastOperator node) throws IOException, ParseException {
    }

    public void visit(AddOperator node) throws IOException, ParseException {
    }

    public void visit(SubOperator node) throws IOException, ParseException {
    }

    public void visit(MulOperator node) throws IOException, ParseException {
    }

    public void visit(DivOperator node) throws IOException, ParseException {
    }

    public void visit(ModOperator node) throws IOException, ParseException {
    }

    public void visit(EqualsOperator node) throws IOException, ParseException {
    }

    public void visit(NotEqualsOperator node) throws IOException, ParseException {
    }

    public void visit(GreaterOperator node) throws IOException, ParseException {
    }

    public void visit(GreaterEqualsOperator node) throws IOException, ParseException {
    }

    public void visit(LessOperator node) throws IOException, ParseException {
    }

    public void visit(LessEqualsOperator node) throws IOException, ParseException {
    }

    public void visit(AndOperator node) throws IOException, ParseException {
    }

    public void visit(OrOperator node) throws IOException, ParseException {
    }

    public void visit(BitAndOperator node) throws IOException, ParseException {
    }

    public void visit(BitOrOperator node) throws IOException, ParseException {
    }

    public void visit(BitXorOperator node) throws IOException, ParseException {
    }

    public void visit(RightShiftOperator node) throws IOException, ParseException {
    }

    public void visit(LeftShiftOperator node) throws IOException, ParseException {
    }

    public void visit(UnsignShiftOperator node) throws IOException, ParseException {
    }

    public void visit(ArrayOperator node) throws IOException, ParseException {
    }

    public void visit(ConditionOperator node) throws IOException, ParseException {
    }

    public void visit(EntryOperator node) throws IOException, ParseException {
    }

    public void visit(InstanceofOperator node) throws IOException, ParseException {
    }

    public void visit(IndexOperator node) throws IOException, ParseException {
    }

    public void visit(SequenceOperator node) throws IOException, ParseException {
    }

    public void visit(MethodOperator node) throws IOException, ParseException {
    }

    public void visit(Text node) throws IOException, ParseException {
    }

    public void visit(ValueDirective node) throws IOException, ParseException {
    }

    public void visit(Comment node) throws IOException, ParseException {
    }

    public void visit(SetDirective node) throws IOException, ParseException {
    }

    public void visit(BreakDirective node) throws IOException, ParseException {
    }

    public boolean visit(Template node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(IfDirective node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(ElseDirective node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(ForDirective node) throws IOException, ParseException {
        return true;
    }

    public boolean visit(MacroDirective node) throws IOException, ParseException {
        return true;
    }

    public void end(IfDirective node) throws IOException, ParseException {
    }

    public void end(ElseDirective node) throws IOException, ParseException {
    }

    public void end(ForDirective node) throws IOException, ParseException {
    }

    public void end(MacroDirective node) throws IOException, ParseException {
    }
}

