/*
 * Decompiled with CFR 0.152.
 */
package httl;

import httl.Resource;
import httl.Template;
import httl.util.BeanFactory;
import httl.util.CollectionUtils;
import httl.util.ConfigUtils;
import httl.util.StringUtils;
import httl.util.Version;
import httl.util.VolatileReference;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Engine {
    private static final String HTTL_DEFAULT_PROPERTIES = "httl-default.properties";
    private static final String HTTL_PROPERTIES = "httl.properties";
    private static final String HTTL_PREFIX = "httl-";
    private static final String HTTL_KEY_PREFIX = "httl.";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String MODES_KEY = "modes";
    private static final String ENGINE_NAME = "engine.name";
    private static final ConcurrentMap<String, VolatileReference<Engine>> ENGINES = new ConcurrentHashMap<String, VolatileReference<Engine>>();

    public static Engine getEngine() {
        return Engine.getEngine(null, new Properties());
    }

    public static Engine getEngine(String configPath) {
        return Engine.getEngine(configPath, null);
    }

    public static Engine getEngine(Properties configProperties) {
        return Engine.getEngine(null, configProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Engine getEngine(String configPath, Properties configProperties) {
        VolatileReference old;
        VolatileReference<Engine> reference;
        if (StringUtils.isEmpty(configPath)) {
            configPath = HTTL_PROPERTIES;
        }
        if ((reference = (VolatileReference<Engine>)ENGINES.get(configPath)) == null && (old = ENGINES.putIfAbsent(configPath, reference = new VolatileReference<Engine>())) != null) {
            reference = old;
        }
        assert (reference != null);
        Engine engine = (Engine)reference.get();
        if (engine == null) {
            VolatileReference<Engine> volatileReference = reference;
            synchronized (volatileReference) {
                engine = (Engine)reference.get();
                if (engine == null) {
                    engine = BeanFactory.createBean(Engine.class, Engine.initProperties(configPath, configProperties));
                    reference.set(engine);
                }
            }
        }
        assert (engine != null);
        return engine;
    }

    private static Properties initProperties(String configPath, Properties configProperties) {
        Map<String, String> systemProperties = ConfigUtils.filterWithPrefix(HTTL_KEY_PREFIX, System.getProperties(), false);
        Map<String, String> systemEnv = ConfigUtils.filterWithPrefix(HTTL_KEY_PREFIX, System.getenv(), true);
        Properties properties = ConfigUtils.mergeProperties(HTTL_DEFAULT_PROPERTIES, configPath, configProperties, systemProperties, systemEnv);
        Object[] modes = StringUtils.splitByComma(properties.getProperty(MODES_KEY));
        if (CollectionUtils.isNotEmpty(modes)) {
            Object[] configs = new Object[modes.length + 5];
            configs[0] = HTTL_DEFAULT_PROPERTIES;
            for (int i = 0; i < modes.length; ++i) {
                configs[i + 1] = HTTL_PREFIX + (String)modes[i] + PROPERTIES_SUFFIX;
            }
            configs[modes.length + 1] = configPath;
            configs[modes.length + 2] = configProperties;
            configs[modes.length + 3] = systemProperties;
            configs[modes.length + 4] = systemEnv;
            properties = ConfigUtils.mergeProperties(configs);
        }
        properties.setProperty(ENGINE_NAME, configPath);
        return properties;
    }

    public abstract String getName();

    public String getVersion() {
        return Version.getVersion(this.getClass());
    }

    public Object getProperty(String key) {
        return this.getProperty(key, Object.class);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key, String.class);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public String[] getProperty(String key, String[] defaultValue) {
        String value = this.getProperty(key, String.class);
        return StringUtils.isEmpty(value) ? defaultValue : StringUtils.splitByComma(value);
    }

    public int getProperty(String key, int defaultValue) {
        String value = this.getProperty(key, String.class);
        return StringUtils.isEmpty(value) ? defaultValue : Integer.parseInt(value);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key, String.class);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public abstract <T> T getProperty(String var1, Class<T> var2);

    public Resource getResource(String name) throws IOException {
        return this.getResource(name, null, null);
    }

    public Resource getResource(String name, String encoding) throws IOException {
        return this.getResource(name, null, encoding);
    }

    public Resource getResource(String name, Locale locale) throws IOException {
        return this.getResource(name, locale, null);
    }

    public abstract Resource getResource(String var1, Locale var2, String var3) throws IOException;

    public boolean hasResource(String name) {
        return this.hasResource(name, null);
    }

    public abstract boolean hasResource(String var1, Locale var2);

    public Template getTemplate(String name) throws IOException, ParseException {
        return this.getTemplate(name, null, null, null);
    }

    public Template getTemplate(String name, String encoding) throws IOException, ParseException {
        return this.getTemplate(name, null, encoding, null);
    }

    public Template getTemplate(String name, Locale locale) throws IOException, ParseException {
        return this.getTemplate(name, locale, null, null);
    }

    public Template getTemplate(String name, Object args) throws IOException, ParseException {
        if (args instanceof String) {
            return this.getTemplate(name, (String)args);
        }
        if (args instanceof Locale) {
            return this.getTemplate(name, (Locale)args);
        }
        return this.getTemplate(name, null, null, args);
    }

    public Template getTemplate(String name, String encoding, Object args) throws IOException, ParseException {
        return this.getTemplate(name, null, encoding, args);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws IOException, ParseException {
        return this.getTemplate(name, locale, encoding, null);
    }

    public Template getTemplate(String name, Locale locale, Object args) throws IOException, ParseException {
        if (args instanceof String) {
            return this.getTemplate(name, locale, (String)args);
        }
        return this.getTemplate(name, locale, null, args);
    }

    public abstract Template getTemplate(String var1, Locale var2, String var3, Object var4) throws IOException, ParseException;

    public Template parseTemplate(String source) throws ParseException {
        return this.parseTemplate(source, null);
    }

    public abstract Template parseTemplate(String var1, Object var2) throws ParseException;

    public abstract Map<String, Object> createContext(Map<String, Object> var1, Map<String, Object> var2);
}

