/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.ObjectUtils;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.render.TableTotaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableWriterTemplate {
    public static final short GROUP_START = -2;
    public static final short GROUP_END = 5;
    public static final short GROUP_START_AND_END = 3;
    public static final short GROUP_NO_CHANGE = 0;
    protected static final int NO_RESET_GROUP = 42000;
    private static Logger log = LoggerFactory.getLogger(TableWriterTemplate.class);
    private String id;
    int lowestEndedGroup;
    int lowestStartedGroup;

    public void writeTable(TableModel model, String id) throws JspException {
        try {
            boolean noItems;
            this.id = id;
            TableProperties properties = model.getProperties();
            if (log.isDebugEnabled()) {
                log.debug("[" + this.id + "] writeTable called for table [" + this.id + "]");
            }
            if ((noItems = model.getRowListPage().isEmpty()) && !properties.getEmptyListShowTable()) {
                this.writeEmptyListMessage(properties.getEmptyListMessage());
                return;
            }
            this.writeTopBanner(model);
            this.writeTableOpener(model);
            if (model.getCaption() != null) {
                this.writeCaption(model);
            }
            if (model.getProperties().getShowHeader()) {
                this.writeTableHeader(model);
            }
            if (model.getFooter() != null) {
                this.writePreBodyFooter(model);
            }
            this.writeTableBodyOpener(model);
            this.writeTableBody(model);
            this.writeTableBodyCloser(model);
            if (model.getFooter() != null) {
                this.writePostBodyFooter(model);
            }
            this.writeTableCloser(model);
            if (model.getTableDecorator() != null) {
                this.writeDecoratedTableFinish(model);
            }
            this.writeBottomBanner(model);
            if (log.isDebugEnabled()) {
                log.debug("[" + this.id + "] writeTable end");
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    protected abstract void writeEmptyListMessage(String var1) throws Exception;

    protected abstract void writeTopBanner(TableModel var1) throws Exception;

    protected abstract void writeTableOpener(TableModel var1) throws Exception;

    protected abstract void writeCaption(TableModel var1) throws Exception;

    protected abstract void writeTableHeader(TableModel var1) throws Exception;

    protected abstract void writePreBodyFooter(TableModel var1) throws Exception;

    protected abstract void writeTableBodyOpener(TableModel var1) throws Exception;

    protected abstract void writeTableBodyCloser(TableModel var1) throws Exception;

    protected abstract void writePostBodyFooter(TableModel var1) throws Exception;

    protected abstract void writeTableCloser(TableModel var1) throws Exception;

    protected abstract void writeDecoratedTableFinish(TableModel var1) throws Exception;

    protected abstract void writeBottomBanner(TableModel var1) throws Exception;

    protected void writeTableBody(TableModel model) throws Exception {
        boolean fullList = false;
        if (!MediaTypeEnum.HTML.equals(model.getMedia()) && model.getProperties().getExportFullList()) {
            fullList = true;
        }
        RowIterator rowIterator = model.getRowIterator(fullList);
        TableTotaler totalsTableDecorator = model.getTotaler();
        if (totalsTableDecorator == null) {
            totalsTableDecorator = TableTotaler.NULL;
        }
        TableDecorator tableDecorator = model.getTableDecorator();
        Row previousRow = null;
        Row currentRow = null;
        Row nextRow = null;
        HashMap previousRowValues = new HashMap(10);
        HashMap currentRowValues = new HashMap(10);
        HashMap<Integer, CellStruct> nextRowValues = new HashMap<Integer, CellStruct>(10);
        while (nextRow != null || rowIterator.hasNext()) {
            CellStruct struct;
            String cellvalue;
            Column column;
            ColumnIterator columnIterator;
            if (currentRow == null) {
                currentRow = rowIterator.next();
            } else {
                previousRow = currentRow;
                currentRow = nextRow;
            }
            if (previousRow != null) {
                previousRowValues.putAll(currentRowValues);
            }
            if (!nextRowValues.isEmpty()) {
                currentRowValues.putAll(nextRowValues);
            } else {
                columnIterator = currentRow.getColumnIterator(model.getHeaderCellList());
                if (log.isDebugEnabled()) {
                    log.debug(" creating ColumnIterator on " + model.getHeaderCellList());
                }
                while (columnIterator.hasNext()) {
                    column = columnIterator.nextColumn();
                    column.initialize();
                    cellvalue = MediaTypeEnum.HTML.equals(model.getMedia()) ? column.getChoppedAndLinkedValue() : ObjectUtils.toString((Object)column.getValue(true));
                    struct = new CellStruct(column, cellvalue);
                    currentRowValues.put(column.getHeaderCell().getColumnNumber(), struct);
                }
            }
            nextRowValues.clear();
            Row row = nextRow = rowIterator.hasNext() ? rowIterator.next() : null;
            if (nextRow != null) {
                columnIterator = nextRow.getColumnIterator(model.getHeaderCellList());
                if (log.isDebugEnabled()) {
                    log.debug(" creating ColumnIterator on " + model.getHeaderCellList());
                }
                while (columnIterator.hasNext()) {
                    column = columnIterator.nextColumn();
                    column.initialize();
                    cellvalue = MediaTypeEnum.HTML.equals(model.getMedia()) ? column.getChoppedAndLinkedValue() : ObjectUtils.toString((Object)column.getValue(true));
                    struct = new CellStruct(column, cellvalue);
                    nextRowValues.put(column.getHeaderCell().getColumnNumber(), struct);
                }
            }
            if (tableDecorator != null) {
                tableDecorator.initRow(currentRow.getObject(), currentRow.getRowNumber(), currentRow.getRowNumber() + rowIterator.getPageOffset());
            }
            if (totalsTableDecorator != null) {
                totalsTableDecorator.initRow(currentRow.getRowNumber(), currentRow.getRowNumber() + rowIterator.getPageOffset());
            }
            ArrayList<CellStruct> structsForRow = new ArrayList<CellStruct>(model.getHeaderCellList().size());
            this.lowestEndedGroup = 42000;
            this.lowestStartedGroup = 42000;
            for (HeaderCell header : model.getHeaderCellList()) {
                struct = (CellStruct)currentRowValues.get(header.getColumnNumber());
                struct.decoratedValue = struct.bodyValue;
                if (header.getGroup() != -1) {
                    CellStruct prior = (CellStruct)previousRowValues.get(header.getColumnNumber());
                    CellStruct next = (CellStruct)nextRowValues.get(header.getColumnNumber());
                    String priorBodyValue = prior != null ? prior.bodyValue : null;
                    String nextBodyValue = next != null ? next.bodyValue : null;
                    short groupingValue = this.groupColumns(struct.bodyValue, priorBodyValue, nextBodyValue, header.getGroup());
                    if (tableDecorator != null || totalsTableDecorator != null) {
                        switch (groupingValue) {
                            case -2: {
                                totalsTableDecorator.startGroup(struct.bodyValue, header.getGroup());
                                if (tableDecorator == null) break;
                                tableDecorator.startOfGroup(struct.bodyValue, header.getGroup());
                                break;
                            }
                            case 5: {
                                totalsTableDecorator.stopGroup(struct.bodyValue, header.getGroup());
                                if (tableDecorator == null) break;
                                tableDecorator.endOfGroup(struct.bodyValue, header.getGroup());
                                break;
                            }
                            case 3: {
                                totalsTableDecorator.startGroup(struct.bodyValue, header.getGroup());
                                if (tableDecorator != null) {
                                    tableDecorator.startOfGroup(struct.bodyValue, header.getGroup());
                                }
                                totalsTableDecorator.stopGroup(struct.bodyValue, header.getGroup());
                                if (tableDecorator == null) break;
                                tableDecorator.endOfGroup(struct.bodyValue, header.getGroup());
                                break;
                            }
                        }
                    }
                    if (tableDecorator != null) {
                        struct.decoratedValue = tableDecorator.displayGroupedValue(struct.bodyValue, groupingValue, header.getColumnNumber());
                    } else if (groupingValue == 5 || groupingValue == 0) {
                        struct.decoratedValue = "";
                    }
                }
                structsForRow.add(struct);
            }
            if (totalsTableDecorator != null) {
                this.writeSubgroupStart(model);
            }
            if (tableDecorator != null) {
                this.writeDecoratedRowStart(model);
            }
            this.writeRowOpener(currentRow);
            for (CellStruct struct2 : structsForRow) {
                this.writeColumnOpener(struct2.column);
                this.writeColumnValue(struct2.decoratedValue, struct2.column);
                this.writeColumnCloser(struct2.column);
            }
            if (model.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("[" + this.id + "] table has no columns");
                }
                this.writeRowWithNoColumns(currentRow.getObject().toString());
            }
            this.writeRowCloser(currentRow);
            if (model.getTableDecorator() != null) {
                this.writeDecoratedRowFinish(model);
            }
            if (model.getTotaler() == null) continue;
            this.writeSubgroupStop(model);
        }
        if (model.getRowListPage().isEmpty()) {
            this.writeEmptyListRowMessage(new MessageFormat(model.getProperties().getEmptyListRowMessage(), model.getProperties().getLocale()).format(new Object[]{model.getNumberOfColumns()}));
        }
    }

    protected abstract void writeDecoratedRowStart(TableModel var1) throws Exception;

    protected void writeSubgroupStart(TableModel model) throws Exception {
    }

    protected void writeSubgroupStop(TableModel model) throws Exception {
    }

    protected abstract void writeRowOpener(Row var1) throws Exception;

    protected abstract void writeColumnOpener(Column var1) throws Exception;

    protected abstract void writeColumnValue(Object var1, Column var2) throws Exception;

    protected abstract void writeColumnCloser(Column var1) throws Exception;

    protected abstract void writeRowWithNoColumns(String var1) throws Exception;

    protected abstract void writeRowCloser(Row var1) throws Exception;

    protected abstract void writeDecoratedRowFinish(TableModel var1) throws Exception;

    protected abstract void writeEmptyListRowMessage(String var1) throws Exception;

    protected short groupColumns(String value, String previous, String next, int currentGroup) {
        short groupingKey = 0;
        if (this.lowestEndedGroup < currentGroup) {
            groupingKey = (short)(groupingKey + 5);
        } else if (next == null || !ObjectUtils.equals((Object)value, (Object)next)) {
            groupingKey = (short)(groupingKey + 5);
            this.lowestEndedGroup = currentGroup;
        }
        if (this.lowestStartedGroup < currentGroup) {
            groupingKey = (short)(groupingKey - 2);
        } else if (previous == null || !ObjectUtils.equals((Object)value, (Object)previous)) {
            groupingKey = (short)(groupingKey - 2);
            this.lowestStartedGroup = currentGroup;
        }
        return groupingKey;
    }

    static class CellStruct {
        Column column;
        String bodyValue;
        String decoratedValue;

        public CellStruct(Column theColumn, String bodyValueParam) {
            this.column = theColumn;
            this.bodyValue = bodyValueParam;
        }
    }
}

