/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.render.TableWriterAdapter;
import org.displaytag.tags.CaptionTag;
import org.displaytag.util.Anchor;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.ParamEncoder;
import org.displaytag.util.PostHref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTableWriter
extends TableWriterAdapter {
    private static Logger log = LoggerFactory.getLogger(HtmlTableWriter.class);
    private TableProperties properties;
    private JspWriter out;
    private ParamEncoder paramEncoder;
    private Href baseHref;
    private boolean export;
    private CaptionTag captionTag;
    private PaginatedList paginatedList;
    private SmartListHelper listHelper;
    private int pagesize;
    private HtmlAttributeMap attributeMap;
    private String uid;

    public HtmlTableWriter(TableProperties tableProperties, Href baseHref, boolean export, JspWriter out, CaptionTag captionTag, PaginatedList paginatedList, SmartListHelper listHelper, int pagesize, HtmlAttributeMap attributeMap, String uid) {
        this.properties = tableProperties;
        this.baseHref = baseHref;
        this.export = export;
        this.out = out;
        this.captionTag = captionTag;
        this.paginatedList = paginatedList;
        this.listHelper = listHelper;
        this.pagesize = pagesize;
        this.attributeMap = attributeMap;
        this.uid = uid;
    }

    @Override
    protected void writeTopBanner(TableModel model) {
        if (model.getForm() != null) {
            String js = "<script type=\"text/javascript\">\nfunction displaytagform(formname, fields){\n    var objfrm = document.forms[formname];\n    for (j=fields.length-1;j>=0;j--){var f= objfrm.elements[fields[j].f];if (f){f.value=fields[j].v};}\n    objfrm.submit();\n}\n</script>";
            this.writeFormFields(model);
            this.write(js);
        }
        if (this.properties.getAddPagingBannerTop()) {
            this.writeSearchResultAndNavigation(model);
        }
        if (this.export && this.properties.getAddExportBannerTop() && !model.getRowListPage().isEmpty()) {
            this.writeExportLinks(model);
        }
    }

    @Override
    protected void writeTableOpener(TableModel model) {
        this.write(this.getOpenTag());
    }

    private void writeFormFields(TableModel model) {
        Map<String, String[]> parameters = this.baseHref.getParameterMap();
        ParamEncoder pe = new ParamEncoder(model.getId());
        this.addIfMissing(parameters, pe.encodeParameterName("o"));
        this.addIfMissing(parameters, pe.encodeParameterName("p"));
        this.addIfMissing(parameters, pe.encodeParameterName("s"));
        for (String key : parameters.keySet()) {
            String[] value = parameters.get(key);
            if (value != null && value.getClass().isArray()) {
                Object[] arr = value;
                for (int j = 0; j < arr.length; ++j) {
                    this.writeField(key, arr[j]);
                }
                continue;
            }
            this.writeField(key, value);
        }
    }

    private void writeField(String key, Object value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<input type=\"hidden\" name=\"");
        buffer.append(this.esc(key));
        buffer.append("\" value=\"");
        buffer.append(value);
        buffer.append("\"/>");
        this.write(buffer.toString());
    }

    private String esc(Object value) {
        return StringUtils.replace((String)(value != null ? value.toString() : ""), (String)"\"", (String)"\\\"");
    }

    private void addIfMissing(Map<String, String[]> parameters, String key) {
        if (!parameters.containsKey(key)) {
            parameters.put(key, new String[]{""});
        }
    }

    @Override
    protected void writeCaption(TableModel model) {
        this.write(this.captionTag.getOpenTag() + model.getCaption() + this.captionTag.getCloseTag());
    }

    @Override
    protected void writePreBodyFooter(TableModel model) {
        this.write("\n<tfoot>");
        this.write(model.getFooter());
        this.write("</tfoot>");
    }

    @Override
    protected void writeTableBodyOpener(TableModel model) {
        this.write("\n<tbody>");
    }

    @Override
    protected void writeTableBodyCloser(TableModel model) {
        this.write("</tbody>");
    }

    @Override
    protected void writeTableCloser(TableModel model) {
        this.write("</");
        this.write("table");
        this.write(">");
    }

    @Override
    protected void writeBottomBanner(TableModel model) {
        this.writeNavigationAndExportLinks(model);
    }

    @Override
    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    @Override
    protected void writeDecoratedRowStart(TableModel model) {
        this.write(model.getTableDecorator().startRow());
    }

    @Override
    protected void writeRowOpener(Row row) {
        this.write(row.getOpenTag());
    }

    @Override
    protected void writeColumnOpener(Column column) throws ObjectLookupException, DecoratorException {
        this.write(column.getOpenTag());
    }

    @Override
    protected void writeColumnCloser(Column column) {
        this.write(column.getCloseTag());
    }

    @Override
    protected void writeRowWithNoColumns(String rowValue) {
        this.write("\n<td>");
        this.write(rowValue);
        this.write("</td>");
    }

    @Override
    protected void writeRowCloser(Row row) {
        this.write(row.getCloseTag());
    }

    @Override
    protected void writeDecoratedRowFinish(TableModel model) {
        this.write(model.getTableDecorator().finishRow());
    }

    @Override
    protected void writeEmptyListMessage(String emptyListMessage) {
        this.write(emptyListMessage);
    }

    @Override
    protected void writeColumnValue(Object value, Column column) {
        this.write(value);
    }

    @Override
    protected void writeEmptyListRowMessage(String message) {
        this.write(message);
    }

    @Override
    protected void writeTableHeader(TableModel model) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] getTableHeader called", (Object)model.getId());
        }
        this.write("\n<thead>");
        this.write("\n<tr>");
        if (model.isEmpty()) {
            this.write("\n<th>");
            this.write("</th>");
        }
        for (HeaderCell headerCell : model.getHeaderCellList()) {
            if (headerCell.getSortable()) {
                String cssSortable = this.properties.getCssSortable();
                headerCell.addHeaderClass(cssSortable);
            }
            if (headerCell.isAlreadySorted()) {
                headerCell.addHeaderClass(this.properties.getCssSorted());
                headerCell.addHeaderClass(this.properties.getCssOrder(model.isSortOrderAscending()));
            }
            this.write(headerCell.getHeaderOpenTag());
            String header = headerCell.getTitle();
            if (headerCell.getSortable()) {
                Anchor anchor = new Anchor(this.getSortingHref(headerCell, model), header);
                header = anchor.toString();
            }
            this.write(header);
            this.write(headerCell.getHeaderCloseTag());
        }
        this.write("</tr>");
        this.write("</thead>");
        if (log.isDebugEnabled()) {
            log.debug("[{}] getTableHeader end", (Object)model.getId());
        }
    }

    private Href getSortingHref(HeaderCell headerCell, TableModel model) {
        Href href = (Href)this.baseHref.clone();
        if (model.getForm() != null) {
            href = new PostHref(href, model.getForm());
        }
        if (this.paginatedList == null) {
            if (!model.isLocalSort() && headerCell.getSortName() != null) {
                href.addParameter(this.encodeParameter("s", model), headerCell.getSortName());
                href.addParameter(this.encodeParameter("n", model), "1");
            } else {
                href.addParameter(this.encodeParameter("s", model), headerCell.getColumnNumber());
            }
            boolean nowOrderAscending = true;
            if (headerCell.getDefaultSortOrder() != null) {
                boolean sortAscending = SortOrderEnum.ASCENDING.equals(headerCell.getDefaultSortOrder());
                nowOrderAscending = headerCell.isAlreadySorted() ? !model.isSortOrderAscending() : sortAscending;
            } else {
                nowOrderAscending = !headerCell.isAlreadySorted() || !model.isSortOrderAscending();
            }
            int sortOrderParam = nowOrderAscending ? SortOrderEnum.ASCENDING.getCode() : SortOrderEnum.DESCENDING.getCode();
            href.addParameter(this.encodeParameter("o", model), sortOrderParam);
            if (model.isSortFullTable() || !model.isLocalSort()) {
                href.addParameter(this.encodeParameter("p", model), 1);
            }
        } else {
            String sortProperty;
            if (this.properties.getPaginationSkipPageNumberInSort()) {
                href.removeParameter(this.properties.getPaginationPageNumberParam());
            }
            if ((sortProperty = headerCell.getSortProperty()) == null) {
                sortProperty = headerCell.getBeanPropertyName();
            }
            href.addParameter(this.properties.getPaginationSortParam(), sortProperty);
            String dirParam = headerCell.isAlreadySorted() ? (model.isSortOrderAscending() ? this.properties.getPaginationDescValue() : this.properties.getPaginationAscValue()) : this.properties.getPaginationAscValue();
            href.addParameter(this.properties.getPaginationSortDirectionParam(), dirParam);
            if (this.paginatedList.getSearchId() != null) {
                href.addParameter(this.properties.getPaginationSearchIdParam(), this.paginatedList.getSearchId());
            }
        }
        return href;
    }

    private String encodeParameter(String parameterName, TableModel model) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(model.getId());
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }

    protected void writeNavigationAndExportLinks(TableModel model) {
        if (this.properties.getAddPagingBannerBottom()) {
            this.writeSearchResultAndNavigation(model);
        }
        if (this.export && this.properties.getAddExportBannerBottom() && !model.getRowListPage().isEmpty()) {
            this.writeExportLinks(model);
        }
    }

    protected void writeSearchResultAndNavigation(TableModel model) {
        if (this.paginatedList == null && this.pagesize != 0 && this.listHelper != null || this.paginatedList != null) {
            String pageParameter;
            Href navigationHref = (Href)this.baseHref.clone();
            if (model.getForm() != null) {
                navigationHref = new PostHref(navigationHref, model.getForm());
            }
            this.write(this.listHelper.getSearchResultsSummary());
            if (this.paginatedList == null) {
                pageParameter = this.encodeParameter("p", model);
            } else {
                pageParameter = this.properties.getPaginationPageNumberParam();
                if (this.paginatedList.getSearchId() != null && !navigationHref.getParameterMap().containsKey(this.properties.getPaginationSearchIdParam())) {
                    navigationHref.addParameter(this.properties.getPaginationSearchIdParam(), this.paginatedList.getSearchId());
                }
            }
            this.write(this.listHelper.getPageNavigationBar(navigationHref, pageParameter));
        }
    }

    private void writeExportLinks(TableModel model) {
        Href exportHref = (Href)this.baseHref.clone();
        StringBuilder buffer = new StringBuilder(200);
        Iterator<MediaTypeEnum> iterator = MediaTypeEnum.iterator();
        while (iterator.hasNext()) {
            MediaTypeEnum currentExportType = iterator.next();
            if (!this.properties.getAddExport(currentExportType)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.properties.getExportBannerSeparator());
            }
            exportHref.addParameter(this.encodeParameter("e", model), currentExportType.getCode());
            exportHref.addParameter("6578706f7274", "1");
            String exportBannerItem = StringUtils.defaultString((String)this.properties.getExportBannerItem(), (String)"<a href=\"{0}\">{1}</a>");
            buffer.append(MessageFormat.format(exportBannerItem, exportHref, this.properties.getExportLabel(currentExportType)));
        }
        Object[] exportOptions = new Object[]{buffer.toString()};
        this.write(new MessageFormat(this.properties.getExportBanner(), this.properties.getLocale()).format(exportOptions));
    }

    public String getOpenTag() {
        if (this.uid != null && this.attributeMap.get("id") == null) {
            Map localAttributeMap = (Map)this.attributeMap.clone();
            localAttributeMap.put("id", this.uid);
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n<").append("table");
            buffer.append(localAttributeMap);
            buffer.append(">");
            return buffer.toString();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n<").append("table");
        buffer.append(this.attributeMap);
        buffer.append(">");
        return buffer.toString();
    }

    public void write(String string) {
        if (string != null) {
            try {
                this.out.write(string);
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
            }
        }
    }

    public void write(Object string) {
        if (string != null) {
            try {
                this.out.write(string.toString());
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
            }
        }
    }
}

