/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.Iterator;
import java.util.List;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowIterator {
    private static Logger log = LoggerFactory.getLogger(RowIterator.class);
    private Iterator<Row> iterator;
    private int rowNumber;
    private TableDecorator decorator;
    private String id;
    private int pageOffset;

    protected RowIterator(List<Row> rowList, List<HeaderCell> columnList, TableDecorator tableDecorator, int offset) {
        this.iterator = rowList.iterator();
        this.rowNumber = 0;
        this.decorator = tableDecorator;
        this.pageOffset = offset;
    }

    public void setId(String tableId) {
        this.id = tableId;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public Row next() {
        int currentRowNumber = this.rowNumber++;
        if (log.isDebugEnabled()) {
            log.debug("[{}] rowIterator.next() row number=", (Object)this.id, (Object)currentRowNumber);
        }
        Row row = this.iterator.next();
        row.setRowNumber(currentRowNumber);
        if (this.decorator != null) {
            this.decorator.initRow(row.getObject(), currentRowNumber, currentRowNumber + this.getPageOffset());
        }
        return row;
    }
}

