/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.model.Cell;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.TableModel;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.MultipleHtmlAttribute;

public class Row {
    private Object rowObject;
    private List<Cell> staticCells;
    private int rowNumber;
    private TableModel tableModel;

    public Row(Object object, int number) {
        this.rowObject = object;
        this.rowNumber = number;
        this.staticCells = new ArrayList<Cell>();
    }

    public void setRowNumber(int number) {
        this.rowNumber = number;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void addCell(Cell cell) {
        this.staticCells.add(cell);
    }

    public List<Cell> getCellList() {
        return this.staticCells;
    }

    public Object getObject() {
        return this.rowObject;
    }

    public ColumnIterator getColumnIterator(List<HeaderCell> columns) {
        return new ColumnIterator(columns, this);
    }

    protected void setParentTable(TableModel table) {
        this.tableModel = table;
    }

    protected TableModel getParentTable() {
        return this.tableModel;
    }

    public String getOpenTag() {
        HtmlAttributeMap rowAttributes = new HtmlAttributeMap();
        MultipleHtmlAttribute cssAttribute = new MultipleHtmlAttribute(this.tableModel.getProperties().getCssRow(this.rowNumber));
        if (this.tableModel.getTableDecorator() != null) {
            try {
                String id;
                String addStyle = this.tableModel.getTableDecorator().addRowClass();
                if (StringUtils.isNotBlank((CharSequence)addStyle)) {
                    cssAttribute.addAttributeValue(addStyle);
                }
                if (StringUtils.isNotBlank((CharSequence)(id = this.tableModel.getTableDecorator().addRowId()))) {
                    rowAttributes.put("id", id);
                }
            }
            catch (NoSuchMethodError addStyle) {
                // empty catch block
            }
        }
        if (!cssAttribute.isEmpty()) {
            rowAttributes.put("class", cssAttribute);
        }
        StringBuilder tag = new StringBuilder();
        tag.append("\n<");
        tag.append("tr");
        tag.append(((Object)rowAttributes).toString());
        tag.append(">");
        return tag.toString();
    }

    public String getCloseTag() {
        return "</tr>";
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("rowNumber", this.rowNumber).append("rowObject", this.rowObject).toString();
    }
}

