/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.filter.BufferedResponseWrapper;
import org.displaytag.filter.SimpleServletOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedResponseWrapper13Impl
extends HttpServletResponseWrapper
implements BufferedResponseWrapper {
    private static Logger log = LoggerFactory.getLogger(BufferedResponseWrapper13Impl.class);
    private CharArrayWriter outputWriter = new CharArrayWriter();
    private SimpleServletOutputStream servletOutputStream = new SimpleServletOutputStream();
    private String contentType;
    private String characterEncoding;
    private boolean charEncSet;
    private boolean state;
    private boolean outRequested;

    public BufferedResponseWrapper13Impl(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    @Override
    public String getContentType() {
        StringBuilder ret = new StringBuilder(this.contentType);
        if (this.characterEncoding != null && this.charEncSet) {
            ret.append("; charset=").append(this.characterEncoding);
        }
        return this.contentType;
    }

    public void setContentType(String type) {
        if (this.state) {
            log.debug("Allowing content type");
            this.getResponse().setContentType(type);
        }
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharEnc = false;
        String charEnc = StringUtils.trim((String)StringUtils.substringAfter((String)type, (String)"charset="));
        if (StringUtils.isNotEmpty((CharSequence)charEnc)) {
            hasCharEnc = true;
        }
        if (!hasCharEnc) {
            this.contentType = type;
            return;
        }
        this.contentType = StringUtils.substringBefore((String)type, (String)";");
        if (StringUtils.isNotEmpty((CharSequence)charEnc)) {
            this.characterEncoding = charEnc;
            this.charEncSet = true;
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        if (characterEncoding == null) {
            return;
        }
        if (this.state) {
            log.debug("Allowing character encoding");
            this.getResponse().setCharacterEncoding(characterEncoding);
        }
        this.characterEncoding = characterEncoding;
        this.charEncSet = true;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.state && !this.outRequested) {
            log.debug("getWriter() returned");
            this.servletOutputStream.reset();
            this.outputWriter.reset();
            this.outRequested = true;
            return ((HttpServletResponse)this.getResponse()).getWriter();
        }
        return new PrintWriter(this.outputWriter);
    }

    public void flushBuffer() throws IOException {
        if (this.outputWriter != null) {
            this.outputWriter.flush();
            this.servletOutputStream.outputStream.reset();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.state && !this.outRequested) {
            log.debug("getOutputStream() returned");
            this.servletOutputStream.reset();
            this.outputWriter.reset();
            this.outRequested = true;
            return ((HttpServletResponse)this.getResponse()).getOutputStream();
        }
        return this.servletOutputStream;
    }

    public void addHeader(String name, String value) {
        if ("6578706f7274".equals(name)) {
            log.debug("Magic header received, real response is now accessible");
            this.state = true;
        } else if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addHeader(name, value);
        }
    }

    @Override
    public boolean isOutRequested() {
        return this.outRequested;
    }

    @Override
    public String getContentAsString() {
        return this.outputWriter.toString() + this.servletOutputStream.toString();
    }

    public void setDateHeader(String name, long date) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).setDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addDateHeader(name, date);
        }
    }

    public void setHeader(String name, String value) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addIntHeader(name, value);
        }
    }
}

