/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export.excel;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.excel.ExcelHssfView;
import org.displaytag.properties.TableProperties;

public class ExcelUtils {
    public static final String EXCEL_SHEET_NAME = "export.excel.sheetname";
    public static final String EXCEL_FORMAT_INTEGER = "export.excel.format.integer";
    public static final String EXCEL_FORMAT_DATE = "export.excel.format.date";
    public static final String EXCEL_FORMAT_NUMBER = "export.excel.format.number";
    public static final String EXCEL_WRAPAT = "export.excel.wraptextlength";
    private Map<String, HSSFCellStyle> cellStyles = new HashMap<String, HSSFCellStyle>();
    private int wrapAt;
    public static final String STYLE_INTEGER = "integer";
    public static final String STYLE_NUMBER = "number";
    public static final String STYLE_DATE = "date";
    public static final String STYLE_STRING = "string";
    public static final String STYLE_LONGSTRING = "longstring";
    public static final String STYLE_PCT = "pct";
    private HSSFWorkbook wb;

    public ExcelUtils(HSSFWorkbook book) {
        this.wb = book;
    }

    public HSSFWorkbook getWb() {
        return this.wb;
    }

    public void setWb(HSSFWorkbook wb) {
        this.wb = wb;
    }

    public void initCellStyles(TableProperties properties) {
        HSSFCellStyle style = this.getNewCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)properties.getProperty(EXCEL_FORMAT_INTEGER)));
        this.cellStyles.put(STYLE_INTEGER, style);
        style = this.getNewCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)properties.getProperty(EXCEL_FORMAT_NUMBER)));
        this.cellStyles.put(STYLE_NUMBER, style);
        style = this.getNewCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)properties.getProperty(EXCEL_FORMAT_DATE)));
        style.setAlignment(HorizontalAlignment.RIGHT);
        this.cellStyles.put(STYLE_DATE, style);
        style = this.getNewCellStyle();
        style.setWrapText(true);
        this.cellStyles.put(STYLE_LONGSTRING, style);
        this.cellStyles.put(STYLE_STRING, this.getNewCellStyle());
        this.wrapAt = Integer.valueOf(properties.getProperty(EXCEL_WRAPAT));
    }

    public void addCellStyle(String key, HSSFCellStyle st) {
        this.cellStyles.put(key, st);
    }

    public HSSFCellStyle getNewCellStyle() {
        return this.getWb() == null ? null : this.getWb().createCellStyle();
    }

    public HSSFCellStyle getStyle(String clz) {
        return this.cellStyles.get(clz);
    }

    public int getWrapAtLength() {
        return this.wrapAt;
    }

    public static String escapeColumnValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        String returnString = rawValue.toString();
        returnString = StringEscapeUtils.escapeJava((String)StringUtils.trimToEmpty((String)returnString));
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\t", (String)"    ");
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\r", (String)" ");
        returnString = StringEscapeUtils.unescapeJava((String)returnString);
        return returnString;
    }

    static class ExcelGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public ExcelGenerationException(Throwable cause) {
            super(ExcelHssfView.class, Messages.getString("ExcelView.errorexporting"), cause);
        }

        @Override
        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }

    public static enum CellFormatTypes {
        INTEGER,
        NUMBER,
        DATE;

    }
}

