/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.render.TableTotaler;
import org.displaytag.render.TableWriterAdapter;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.MultipleHtmlAttribute;

public class XmlTotalsWriter
extends TableWriterAdapter {
    Pattern stylePat = Pattern.compile("\\s*?([\\w\\-]+?)\\s*?:\\s*?([\\w\\-]+?)(?:;|$)");
    protected StringBuffer xml = new StringBuffer();
    Map<Integer, String> currentGroupingValueByGroup = new HashMap<Integer, String>();
    Integer groupId;
    int currentGroupingLevel = 0;
    int maxWordLength = 15;
    public static final TableDecorator NOOP = new TableDecorator(){

        @Override
        public String displayGroupedValue(String cellValue, short groupingStatus, int columnNumber) {
            return cellValue;
        }
    };

    public XmlTotalsWriter(TableModel m) {
        this.setModel(m);
    }

    public void setModel(TableModel m) {
        m.setTableDecorator(NOOP);
        if (m.getTotaler() == null || m.getTotaler() == TableTotaler.NULL) {
            TableTotaler tt = new TableTotaler();
            tt.init(m);
            m.setTotaler(tt);
        }
    }

    @Override
    protected void writeTableOpener(TableModel model) throws Exception {
        this.xml.append("<?xml version=\"1.0\"?>\n<table>\n");
    }

    @Override
    protected void writeSubgroupStart(TableModel model) {
        TableTotaler tt = model.getTotaler();
        for (int i : tt.getOpenedColumns()) {
            this.xml.append("<subgroup grouped-by=\"").append(i).append("\">");
        }
    }

    @Override
    protected void writeSubgroupStop(TableModel model) {
        List<Integer> closed = model.getTotaler().getClosedColumns();
        if (!closed.isEmpty()) {
            this.writeSubtotals(model, closed);
        }
    }

    protected void writeSubtotals(TableModel model, List<Integer> closedColumns) {
        TableTotaler tt = model.getTotaler();
        Collections.reverse(closedColumns);
        for (int i : closedColumns) {
            this.xml.append("<subtotal>\n");
            for (HeaderCell cell : model.getHeaderCellList()) {
                if (cell.isTotaled()) {
                    this.xml.append("\t<subtotal-cell ");
                    HtmlAttributeMap atts = cell.getHtmlAttributes();
                    this.writeAttributes(atts);
                    this.xml.append('>');
                    this.cdata(tt.formatTotal(cell, tt.getTotalForColumn(cell.getColumnNumber(), tt.asGroup(i))));
                    this.xml.append("</subtotal-cell>");
                    continue;
                }
                this.xml.append("\t<subtotal-cell/>");
            }
            this.xml.append("\n</subtotal>\n");
            this.writeExtraGroupInfo(model, i);
            this.xml.append("</subgroup>\n");
        }
    }

    protected void writeExtraGroupInfo(TableModel model, int groupColumn) {
    }

    protected void writeAttributes(HtmlAttributeMap atts) {
        if (atts != null) {
            MultipleHtmlAttribute cssClass;
            String style = (String)atts.get("style");
            if (StringUtils.isNotBlank((CharSequence)style)) {
                Matcher m = this.stylePat.matcher(style);
                while (m.find()) {
                    this.xml.append(m.group(1));
                    this.xml.append("=\"");
                    this.xml.append(m.group(2));
                    this.xml.append("\" ");
                }
            }
            if ((cssClass = (MultipleHtmlAttribute)atts.get("class")) != null && !cssClass.isEmpty()) {
                this.xml.append(" class");
                this.xml.append("=\"");
                this.xml.append(cssClass.toString());
                this.xml.append("\"");
            }
        }
    }

    @Override
    protected void writeColumnOpener(Column column) throws Exception {
        boolean grouped = column.getHeaderCell().getGroup() >= this.currentGroupingLevel;
        String attr = "";
        if (grouped) {
            attr = " grouped=\"true\" ";
        }
        this.xml.append("\t<cell ");
        this.xml.append(attr);
        HtmlAttributeMap atts = column.getHeaderCell().getHtmlAttributes();
        this.writeAttributes(atts);
        this.xml.append(">");
    }

    @Override
    protected void writeColumnCloser(Column column) throws Exception {
        this.xml.append("</cell>\n");
    }

    @Override
    protected void writeTableHeader(TableModel model) throws Exception {
        Iterator<HeaderCell> iterator = model.getHeaderCellList().iterator();
        this.xml.append("<header>\n");
        this.xml.append("\n");
        while (iterator.hasNext()) {
            HeaderCell headerCell = iterator.next();
            this.xml.append("<header-cell>");
            this.cdata(headerCell.getTitle());
            this.xml.append("</header-cell>\n");
        }
        this.xml.append("</header>\n");
        this.xml.append("<data>");
        this.xml.append("<subgroup grouped-by=\"" + TableTotaler.WHOLE_TABLE + "\">");
    }

    protected void cdata(Object str) {
        this.xml.append("<![CDATA[");
        String defStr = StringUtils.defaultString((String)("" + str));
        this.xml.append(defStr);
        this.xml.append("]]>");
    }

    @Override
    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    @Override
    protected void writeDecoratedRowStart(TableModel model) {
        this.xml.append(StringUtils.defaultString((String)model.getTableDecorator().startRow()));
    }

    @Override
    protected void writeTableCloser(TableModel model) throws Exception {
        this.xml.append("</table>");
    }

    @Override
    protected void writeDecoratedRowFinish(TableModel model) {
        this.xml.append(StringUtils.defaultString((String)model.getTableDecorator().finishRow()));
    }

    @Override
    protected void writeRowOpener(Row row) throws Exception {
        this.xml.append("\n<row>\n");
    }

    @Override
    protected void writeColumnValue(Object value, Column column) throws Exception {
        Object rawValue = column.getValue(true);
        this.cdata(rawValue);
    }

    @Override
    protected void writeRowWithNoColumns(String value) throws Exception {
        this.xml.append("<row/>\n");
    }

    @Override
    protected void writeRowCloser(Row row) throws Exception {
        this.xml.append("</row>\n");
    }

    @Override
    protected void writeTableBodyCloser(TableModel model) {
        this.xml.append("\n<!-- grand totals -->\n");
        this.writeSubtotals(model, Arrays.asList(TableTotaler.WHOLE_TABLE));
        this.xml.append("</data>");
    }

    public String getXml() {
        return this.xml.toString();
    }
}

