/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.displaytag.export.DefaultItextExportView;

public class DefaultPdfExportView
extends DefaultItextExportView {
    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    @Override
    protected void initItextWriter(Document document, OutputStream out) throws DocumentException {
        PdfWriter.getInstance((Document)document, (OutputStream)out).setPageEvent((PdfPageEvent)new PageNumber());
    }

    private static class PageNumber
    extends PdfPageEventHelper {
        private PageNumber() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfPTable table = new PdfPTable(2);
            PdfTemplate tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            BaseFont helv = null;
            try {
                helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            }
            catch (DocumentException documentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            PdfContentByte cb = writer.getDirectContent();
            table.setTotalWidth(document.right() - document.left());
            table.writeSelectedRows(0, -1, document.left(), document.getPageSize().getHeight() - 50.0f, cb);
            String text = "Page " + writer.getPageNumber();
            float textSize = helv.getWidthPoint(text, 12.0f);
            float textBase = document.bottom() - 20.0f;
            cb.beginText();
            cb.setFontAndSize(helv, 12.0f);
            float adjust = helv.getWidthPoint("0", 12.0f);
            cb.setTextMatrix(document.right() - textSize - adjust, textBase);
            cb.showText(text);
            cb.endText();
            cb.addTemplate(tpl, document.right() - adjust, textBase);
        }
    }
}

