/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalTableDecorator
extends TableDecorator {
    private static Logger log = LoggerFactory.getLogger(TotalTableDecorator.class);
    private Map<String, Double> grandTotals = new HashMap<String, Double>();
    private Map<String, Double> subTotals = new HashMap<String, Double>();
    private Map<String, Object> previousValues = new HashMap<String, Object>();
    private String groupPropertyName;
    private String subtotalLabel = "{0} subtotal";
    private String totalLabel = "Total";

    public void setSubtotalLabel(String subtotalLabel) {
        this.subtotalLabel = subtotalLabel;
    }

    public void setTotalLabel(String totalLabel) {
        this.totalLabel = totalLabel;
    }

    @Override
    public void init(PageContext context, Object decorated, TableModel tableModel) {
        super.init(context, decorated, tableModel);
        this.groupPropertyName = null;
        this.grandTotals.clear();
        this.subTotals.clear();
        this.previousValues.clear();
        for (HeaderCell cell : tableModel.getHeaderCellList()) {
            if (cell.getGroup() != 1) continue;
            this.groupPropertyName = cell.getBeanPropertyName();
        }
    }

    @Override
    public String startRow() {
        String subtotalRow = null;
        if (this.groupPropertyName != null) {
            Object groupedPropertyValue = this.evaluate(this.groupPropertyName);
            Object previousGroupedPropertyValue = this.previousValues.get(this.groupPropertyName);
            if (previousGroupedPropertyValue != null && !ObjectUtils.equals((Object)previousGroupedPropertyValue, (Object)groupedPropertyValue)) {
                subtotalRow = this.createTotalRow(false);
            }
            this.previousValues.put(this.groupPropertyName, groupedPropertyValue);
        }
        for (HeaderCell cell : this.tableModel.getHeaderCellList()) {
            if (!cell.isTotaled()) continue;
            String totalPropertyName = cell.getBeanPropertyName();
            Number amount = (Number)this.evaluate(totalPropertyName);
            Number previousSubTotal = this.subTotals.get(totalPropertyName);
            Number previousGrandTotals = this.grandTotals.get(totalPropertyName);
            this.subTotals.put(totalPropertyName, (previousSubTotal != null ? previousSubTotal.doubleValue() : 0.0) + (amount != null ? amount.doubleValue() : 0.0));
            this.grandTotals.put(totalPropertyName, (previousGrandTotals != null ? previousGrandTotals.doubleValue() : 0.0) + (amount != null ? amount.doubleValue() : 0.0));
        }
        return subtotalRow;
    }

    @Override
    public final String finishRow() {
        StringBuilder buffer = new StringBuilder(1000);
        if (this.getViewIndex() == ((List)this.getDecoratedObject()).size() - 1) {
            if (this.groupPropertyName != null) {
                buffer.append(this.createTotalRow(false));
            }
            buffer.append(this.createTotalRow(true));
        }
        return buffer.toString();
    }

    protected String createTotalRow(boolean grandTotal) {
        StringBuilder buffer = new StringBuilder(1000);
        buffer.append("\n<tr class=\"total\">");
        List<HeaderCell> headerCells = this.tableModel.getHeaderCellList();
        for (HeaderCell cell : headerCells) {
            Object cssClassObj = cell.getHtmlAttributes().get("class");
            String cssClass = cssClassObj != null ? cssClassObj.toString() : "";
            buffer.append("<td");
            if (StringUtils.isNotEmpty((CharSequence)cssClass)) {
                buffer.append(" class=\"");
                buffer.append(cssClass);
                buffer.append("\"");
            }
            buffer.append(">");
            if (cell.isTotaled()) {
                String totalPropertyName = cell.getBeanPropertyName();
                Object total = grandTotal ? this.grandTotals.get(totalPropertyName) : this.subTotals.get(totalPropertyName);
                DisplaytagColumnDecorator[] decorators = cell.getColumnDecorators();
                for (int j = 0; j < decorators.length; ++j) {
                    try {
                        total = decorators[j].decorate(total, this.getPageContext(), this.tableModel.getMedia());
                        continue;
                    }
                    catch (DecoratorException e) {
                        log.warn(e.getMessage(), (Throwable)((Object)e));
                    }
                }
                buffer.append(total);
            } else if (this.groupPropertyName != null && this.groupPropertyName.equals(cell.getBeanPropertyName())) {
                buffer.append(grandTotal ? this.totalLabel : new MessageFormat(this.subtotalLabel, this.tableModel.getProperties().getLocale()).format(new Object[]{this.previousValues.get(this.groupPropertyName)}));
            }
            buffer.append("</td>");
        }
        buffer.append("</tr>");
        this.subTotals.clear();
        return buffer.toString();
    }
}

