/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilevelTotalTableDecorator
extends TableDecorator {
    private boolean containsTotaledColumns = true;
    private static final int NO_RESET_GROUP = 4200;
    private Map<Integer, GroupTotals> groupNumberToGroupTotal = new HashMap<Integer, GroupTotals>();
    private int deepestResetGroup = 4200;
    protected int innermostGroup;
    private Logger logger = LoggerFactory.getLogger(MultilevelTotalTableDecorator.class);
    protected String grandTotalSum = "grandtotal-sum";
    protected String grandTotalNoSum = "grandtotal-nosum";
    protected String grandTotalLabel = "grandtotal-label";
    protected String grandTotalDescription = "Grand Total";
    private String subtotalHeaderClass = "subtotal-header";
    private String subtotalLabelClass = "subtotal-label";
    private MessageFormat subtotalDesc = new MessageFormat("{0} Total");
    private String subtotalValueClass = "subtotal-sum";
    private List<StringBuffer> headerRows = new ArrayList<StringBuffer>(5);

    @Override
    public void init(PageContext context, Object decorated, TableModel model) {
        super.init(context, decorated, model);
        List<HeaderCell> headerCells = model.getHeaderCellList();
        for (HeaderCell headerCell : headerCells) {
            if (headerCell.getGroup() <= 0) continue;
            GroupTotals groupTotals = new GroupTotals(headerCell.getColumnNumber());
            groupTotals.setStartRow(this.tableModel.getPageOffset());
            this.groupNumberToGroupTotal.put(headerCell.getGroup(), groupTotals);
            if (headerCell.getGroup() <= this.innermostGroup) continue;
            this.innermostGroup = headerCell.getGroup();
        }
    }

    public String getGrandTotalDescription() {
        return this.grandTotalDescription;
    }

    public void setGrandTotalDescription(String grandTotalDescription) {
        this.grandTotalDescription = grandTotalDescription;
    }

    public void setSubtotalLabel(String pattern, Locale locale) {
        this.subtotalDesc = new MessageFormat(pattern, locale);
    }

    public String getGrandTotalLabel() {
        return this.grandTotalLabel;
    }

    public String getGrandTotalSum() {
        return this.grandTotalSum;
    }

    public String getGrandTotalNoSum() {
        return this.grandTotalNoSum;
    }

    public void setGrandTotalNoSum(String grandTotalNoSum) {
        this.grandTotalNoSum = grandTotalNoSum;
    }

    public void setGrandTotalSum(String grandTotalSum) {
        this.grandTotalSum = grandTotalSum;
    }

    public void setGrandTotalLabel(String grandTotalLabel) {
        this.grandTotalLabel = grandTotalLabel;
    }

    public String getSubtotalValueClass() {
        return this.subtotalValueClass;
    }

    public void setSubtotalValueClass(String subtotalValueClass) {
        this.subtotalValueClass = subtotalValueClass;
    }

    public String getSubtotalLabelClass() {
        return this.subtotalLabelClass;
    }

    public void setSubtotalLabelClass(String subtotalLabelClass) {
        this.subtotalLabelClass = subtotalLabelClass;
    }

    public String getSubtotalHeaderClass() {
        return this.subtotalHeaderClass;
    }

    public void setSubtotalHeaderClass(String subtotalHeaderClass) {
        this.subtotalHeaderClass = subtotalHeaderClass;
    }

    @Override
    public void startOfGroup(String value, int group) {
        if (this.containsTotaledColumns) {
            StringBuffer tr = new StringBuffer();
            tr.append("<tr>");
            GroupTotals groupTotals = this.groupNumberToGroupTotal.get(group);
            int myColumnNumber = groupTotals.columnNumber;
            for (int i = 0; i < myColumnNumber; ++i) {
                tr.append("<td></td>\n");
            }
            tr.append("<td class=\"").append(this.getSubtotalHeaderClass()).append(" group-").append(group).append("\" >");
            tr.append(value).append("</td>\n");
            List<HeaderCell> headerCells = this.tableModel.getHeaderCellList();
            for (int i = myColumnNumber; i < headerCells.size() - 1; ++i) {
                tr.append("<td></td>\n");
            }
            tr.append("</tr>\n");
            this.headerRows.add(tr);
        }
    }

    @Override
    public String displayGroupedValue(String value, short groupingStatus, int columnNumber) {
        return "";
    }

    @Override
    public String startRow() {
        StringBuffer sb = new StringBuffer();
        for (StringBuffer stringBuffer : this.headerRows) {
            sb.append(stringBuffer);
        }
        return sb.toString();
    }

    @Override
    public void endOfGroup(String value, int groupNumber) {
        if (this.deepestResetGroup > groupNumber) {
            this.deepestResetGroup = groupNumber;
        }
    }

    @Override
    public String finishRow() {
        String returnValue = "";
        if (this.containsTotaledColumns) {
            if (this.innermostGroup > 0 && this.deepestResetGroup != 4200) {
                StringBuffer out = new StringBuffer();
                for (int i = this.innermostGroup; i >= this.deepestResetGroup; --i) {
                    Integer groupNumber = i;
                    GroupTotals totals = this.groupNumberToGroupTotal.get(groupNumber);
                    if (totals == null) {
                        this.logger.warn("There is a gap in the defined groups - no group defined for {}", (Object)groupNumber);
                        continue;
                    }
                    totals.printTotals(this.getListIndex(), out);
                    this.finishGroup(totals.getColumnNumber(), out);
                    totals.setStartRow(this.getListIndex() + 1);
                }
                returnValue = out.toString();
            } else {
                returnValue = null;
            }
            this.deepestResetGroup = 4200;
            this.headerRows.clear();
            if (this.isLastRow()) {
                returnValue = StringUtils.defaultString((String)returnValue);
                returnValue = returnValue + this.totalAllRows();
            }
        }
        return returnValue;
    }

    protected void finishGroup(int columnNumber, StringBuffer out) {
    }

    protected String totalAllRows() {
        if (this.containsTotaledColumns) {
            List<HeaderCell> headerCells = this.tableModel.getHeaderCellList();
            StringBuffer output = new StringBuffer();
            int currentRow = this.getListIndex();
            output.append("\n<tr class=\"grandtotal-row\">");
            boolean first = true;
            for (HeaderCell headerCell : headerCells) {
                if (first) {
                    output.append(this.getTotalsTdOpen(headerCell, this.getGrandTotalLabel()));
                    output.append(this.getGrandTotalDescription());
                    first = false;
                } else if (headerCell.isTotaled()) {
                    Object total = this.getTotalForColumn(headerCell.getColumnNumber(), this.tableModel.getPageOffset(), currentRow);
                    output.append(this.getTotalsTdOpen(headerCell, this.getGrandTotalSum()));
                    output.append(this.formatTotal(headerCell, total));
                } else {
                    output.append(this.getTotalsTdOpen(headerCell, this.getGrandTotalNoSum()));
                }
                output.append("</td>");
            }
            output.append("\n</tr>\n");
            return output.toString();
        }
        return "";
    }

    protected String getCellValue(int columnNumber, int rowNumber) {
        List<Row> fullList = this.tableModel.getRowListFull();
        Row row = fullList.get(rowNumber);
        ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
        while (columnIterator.hasNext()) {
            Column column = columnIterator.nextColumn();
            if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
            try {
                column.initialize();
                return column.getChoppedAndLinkedValue();
            }
            catch (ObjectLookupException e) {
                this.logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException("Error: " + e.getMessage(), (Throwable)((Object)e));
            }
            catch (DecoratorException e) {
                this.logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException("Error: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        throw new RuntimeException("Unable to find column " + columnNumber + " in the list of columns");
    }

    protected Object getTotalForColumn(int columnNumber, int startRow, int stopRow) {
        List<Row> fullList = this.tableModel.getRowListFull();
        List<Row> window = fullList.subList(startRow, stopRow + 1);
        Object total = null;
        for (Row row : window) {
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
                Object value = null;
                try {
                    value = column.getValue(false);
                }
                catch (ObjectLookupException e) {
                    this.logger.error("", (Throwable)((Object)e));
                }
                catch (DecoratorException e) {
                    this.logger.error("", (Throwable)((Object)e));
                }
                if (value == null || "".equals(value)) continue;
                total = this.add(column, total, value);
            }
        }
        return total;
    }

    protected Object add(Column column, Object total, Object value) {
        if (value == null) {
            return total;
        }
        if (value instanceof Number) {
            Number oldTotal = 0.0;
            if (total != null) {
                oldTotal = (Number)total;
            }
            return oldTotal + ((Number)value).doubleValue();
        }
        throw new UnsupportedOperationException("Cannot add a value of " + value + " in column " + column.getHeaderCell().getTitle());
    }

    public String getTotalsTdOpen(HeaderCell header, String totalClass) {
        Object cssClassObj = header.getHtmlAttributes().get("class");
        String cssClass = cssClassObj != null ? cssClassObj.toString() : "";
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<");
        buffer.append("td");
        if (cssClass != null || totalClass != null) {
            buffer.append(" class=\"");
            if (cssClass != null) {
                buffer.append(cssClass);
                if (totalClass != null) {
                    buffer.append(" ");
                }
            }
            if (totalClass != null) {
                buffer.append(totalClass);
            }
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public String getTotalsRowOpen() {
        return "\n<tr class=\"subtotal\">";
    }

    public String getTotalRowLabel(String groupingValue) {
        return this.subtotalDesc.format(new Object[]{groupingValue});
    }

    public String formatTotal(HeaderCell header, Object total) {
        Object displayValue = total;
        if (header.getColumnDecorators().length > 0) {
            for (int i = 0; i < header.getColumnDecorators().length; ++i) {
                DisplaytagColumnDecorator decorator = header.getColumnDecorators()[i];
                try {
                    displayValue = decorator.decorate(total, this.getPageContext(), this.tableModel.getMedia());
                    continue;
                }
                catch (DecoratorException e) {
                    this.logger.warn(e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
        return displayValue != null ? displayValue.toString() : "";
    }

    class GroupTotals {
        protected String totalLabelClass;
        protected String totalsRowOpen;
        protected String totalValueClass;
        private int columnNumber;
        private int firstRowOfCurrentSet;

        public GroupTotals(int headerCellColumn) {
            this.totalLabelClass = MultilevelTotalTableDecorator.this.getSubtotalLabelClass();
            this.totalsRowOpen = MultilevelTotalTableDecorator.this.getTotalsRowOpen();
            this.totalValueClass = MultilevelTotalTableDecorator.this.getSubtotalValueClass();
            this.columnNumber = headerCellColumn;
            this.firstRowOfCurrentSet = 0;
        }

        public void printTotals(int currentRow, StringBuffer out) {
            List<HeaderCell> headerCells = MultilevelTotalTableDecorator.this.tableModel.getHeaderCellList();
            if (this.firstRowOfCurrentSet < currentRow) {
                out.append(this.totalsRowOpen);
                for (HeaderCell headerCell : headerCells) {
                    if (this.columnNumber == headerCell.getColumnNumber()) {
                        String currentLabel = MultilevelTotalTableDecorator.this.getCellValue(this.columnNumber, this.firstRowOfCurrentSet);
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, this.getTotalLabelClass() + " group-" + (this.columnNumber + 1)));
                        out.append(MultilevelTotalTableDecorator.this.getTotalRowLabel(currentLabel));
                    } else if (headerCell.isTotaled()) {
                        Object total = MultilevelTotalTableDecorator.this.getTotalForColumn(headerCell.getColumnNumber(), this.firstRowOfCurrentSet, currentRow);
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, this.getTotalValueClass() + " group-" + (this.columnNumber + 1)));
                        out.append(MultilevelTotalTableDecorator.this.formatTotal(headerCell, total));
                    } else {
                        StringBuilder style = new StringBuilder("group-" + (this.columnNumber + 1));
                        if (headerCell.getColumnNumber() < MultilevelTotalTableDecorator.this.innermostGroup) {
                            style.append(" ").append(this.getTotalLabelClass()).append(" ");
                        }
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, style.toString()));
                    }
                    out.append("</td>");
                }
                out.append("\n</tr>\n");
            }
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public void setStartRow(int i) {
            this.firstRowOfCurrentSet = i;
        }

        public String getTotalLabelClass() {
            return this.totalLabelClass;
        }

        public void setTotalsRowOpen(String totalsRowOpen) {
            this.totalsRowOpen = totalsRowOpen;
        }

        public void setTotalLabelClass(String totalLabelClass) {
            this.totalLabelClass = totalLabelClass;
        }

        public String getTotalValueClass() {
            return this.totalValueClass;
        }

        public void setTotalValueClass(String totalValueClass) {
            this.totalValueClass = totalValueClass;
        }
    }
}

