/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.ObjectUtils;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.TableModel;

public class CheckboxTableDecorator
extends TableDecorator {
    private String id = "id";
    private List<String> checkedIds;
    private String fieldName = "_chk";

    public void setId(String id) {
        this.id = id;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void init(PageContext pageContext, Object decorated, TableModel tableModel) {
        super.init(pageContext, decorated, tableModel);
        String[] params = pageContext.getRequest().getParameterValues(this.fieldName);
        this.checkedIds = params != null ? new ArrayList<String>(Arrays.asList(params)) : new ArrayList(0);
    }

    @Override
    public void finish() {
        if (!this.checkedIds.isEmpty()) {
            JspWriter writer = this.getPageContext().getOut();
            for (String name : this.checkedIds) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("<input type=\"hidden\" name=\"");
                buffer.append(this.fieldName);
                buffer.append("\" value=\"");
                buffer.append(name);
                buffer.append("\">");
                try {
                    writer.write(buffer.toString());
                }
                catch (IOException iOException) {}
            }
        }
        super.finish();
    }

    public String getCheckbox() {
        String evaluatedId = ObjectUtils.toString((Object)this.evaluate(this.id));
        boolean checked = this.checkedIds.contains(evaluatedId);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<input type=\"checkbox\" name=\"_chk\" value=\"");
        buffer.append(evaluatedId);
        buffer.append("\"");
        if (checked) {
            this.checkedIds.remove(evaluatedId);
            buffer.append(" checked=\"checked\"");
        }
        buffer.append("/>");
        return buffer.toString();
    }
}

