/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven.plugins.core;

import com.github.maven.plugins.core.RepositoryUtils;
import com.github.maven.plugins.core.StringUtils;
import com.github.maven.plugins.core.egit.GitHubClientEgit;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;

public abstract class GitHubProjectMojo
extends AbstractMojo
implements Contextualizable {
    @Requirement
    private PlexusContainer container;

    public static String getExceptionMessage(IOException e) {
        return e.getMessage();
    }

    protected boolean isDebug() {
        Log log = this.getLog();
        return log != null ? log.isDebugEnabled() : false;
    }

    protected boolean isInfo() {
        Log log = this.getLog();
        return log != null ? log.isInfoEnabled() : false;
    }

    protected void debug(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message);
        }
    }

    protected void debug(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message, throwable);
        }
    }

    protected void info(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message);
        }
    }

    protected void info(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message, throwable);
        }
    }

    protected GitHubClient createClient(String host, String userName, String password, String oauth2Token, String serverId, Settings settings, MavenSession session) throws MojoExecutionException {
        GitHubClient client;
        if (!StringUtils.isEmpty(host)) {
            if (this.isDebug()) {
                this.debug("Using custom host: " + host);
            }
            client = this.createClient(host);
        } else {
            client = this.createClient();
        }
        Proxy proxy = this.getProxy(settings, serverId, host);
        if (null != proxy) {
            try {
                SettingsDecrypter settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
                SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy));
                proxy = result.getProxy();
            }
            catch (ComponentLookupException cle) {
                throw new MojoExecutionException("Unable to lookup SettingsDecrypter: " + cle.getMessage(), (Exception)((Object)cle));
            }
        }
        if (null != proxy) {
            java.net.Proxy javaProxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
            if (this.isDebug()) {
                this.debug(MessageFormat.format("Found Proxy {0}:{1}", proxy.getHost(), proxy.getPort()));
            }
            if (client instanceof GitHubClientEgit) {
                GitHubClientEgit clientEgit = (GitHubClientEgit)client;
                if (this.isDebug()) {
                    this.debug(MessageFormat.format("Use Proxy for Egit {0}", javaProxy));
                }
                clientEgit.setProxy(javaProxy);
            }
        }
        if (this.configureUsernamePassword(client, userName, password) || this.configureOAuth2Token(client, oauth2Token) || this.configureServerCredentials(client, serverId, settings, session)) {
            return client;
        }
        throw new MojoExecutionException("No authentication credentials configured");
    }

    protected GitHubClient createClient(String hostname) throws MojoExecutionException {
        if (!hostname.contains("://")) {
            return new GitHubClientEgit(hostname);
        }
        try {
            URL hostUrl = new URL(hostname);
            return new GitHubClientEgit(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not parse host URL " + hostname, (Exception)e);
        }
    }

    protected GitHubClient createClient() {
        return new GitHubClientEgit();
    }

    protected boolean configureUsernamePassword(GitHubClient client, String userName, String password) {
        if (StringUtils.isEmpty(userName, password)) {
            return false;
        }
        if (this.isDebug()) {
            this.debug("Using basic authentication with username: " + userName);
        }
        client.setCredentials(userName, password);
        return true;
    }

    protected boolean configureOAuth2Token(GitHubClient client, String oauth2Token) {
        if (StringUtils.isEmpty(oauth2Token)) {
            return false;
        }
        if (this.isDebug()) {
            this.debug("Using OAuth2 access token authentication");
        }
        client.setOAuth2Token(oauth2Token);
        return true;
    }

    protected boolean configureServerCredentials(GitHubClient client, String serverId, Settings settings, MavenSession session) throws MojoExecutionException {
        if (StringUtils.isEmpty(serverId)) {
            return false;
        }
        String serverUsername = null;
        String serverPassword = null;
        Server server = this.getServer(settings, serverId);
        if (server == null) {
            throw new MojoExecutionException(MessageFormat.format("Server ''{0}'' not found in settings", serverId));
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Using ''{0}'' server credentials", serverId));
        }
        try {
            SettingsDecrypter settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
            SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            server = result.getServer();
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Unable to lookup SettingsDecrypter: " + cle.getMessage(), (Exception)((Object)cle));
        }
        serverUsername = server.getUsername();
        serverPassword = server.getPassword();
        if (!StringUtils.isEmpty(serverUsername, serverPassword)) {
            if (this.isDebug()) {
                this.debug("Using basic authentication with username: " + serverUsername);
            }
            client.setCredentials(serverUsername, serverPassword);
            return true;
        }
        if (!StringUtils.isEmpty(serverPassword)) {
            if (this.isDebug()) {
                this.debug("Using OAuth2 access token authentication");
            }
            client.setOAuth2Token(serverPassword);
            return true;
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Server ''{0}'' is missing username/password credentials", serverId));
        }
        return false;
    }

    protected RepositoryId getRepository(MavenProject project, String owner, String name) throws MojoExecutionException {
        RepositoryId repository = RepositoryUtils.getRepository(project, owner, name);
        if (repository == null) {
            throw new MojoExecutionException("No GitHub repository (owner and name) configured");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Using GitHub repository {0}", repository.generateId()));
        }
        return repository;
    }

    protected Server getServer(Settings settings, String serverId) {
        if (settings == null) {
            return null;
        }
        List servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        for (Server server : servers) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    protected boolean matchNonProxy(Proxy proxy, String hostname) {
        String[] nonProxies;
        String nonProxyHosts;
        String host = hostname;
        if (null == hostname) {
            host = "github.com";
        }
        if (null != (nonProxyHosts = proxy.getNonProxyHosts()) && null != (nonProxies = nonProxyHosts.split("(,)|(;)|(\\|)"))) {
            for (String nonProxyHost : nonProxies) {
                if (null != nonProxyHost && nonProxyHost.contains("*")) {
                    int pos = nonProxyHost.indexOf(42);
                    String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                    String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                    if (!StringUtils.isEmpty(nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty(nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isEmpty(nonProxyHostPrefix) && !StringUtils.isEmpty(nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isEmpty(nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || StringUtils.isEmpty(nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                    return true;
                }
                if (!host.equals(nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    protected Proxy getProxy(Settings settings, String serverId, String host) {
        if (settings == null) {
            return null;
        }
        List proxies = settings.getProxies();
        if (proxies == null || proxies.isEmpty()) {
            return null;
        }
        if (serverId != null && !serverId.isEmpty()) {
            for (Proxy proxy : proxies) {
                String proxyId;
                if (!proxy.isActive() || (proxyId = proxy.getId()) == null || proxyId.isEmpty() || !proxyId.equalsIgnoreCase(serverId) || !"http".equalsIgnoreCase(proxy.getProtocol()) && !"https".equalsIgnoreCase(proxy.getProtocol())) continue;
                if (this.matchNonProxy(proxy, host)) {
                    return null;
                }
                return proxy;
            }
        }
        for (Proxy proxy : proxies) {
            if (!proxy.isActive() || !"http".equalsIgnoreCase(proxy.getProtocol()) && !"https".equalsIgnoreCase(proxy.getProtocol())) continue;
            if (this.matchNonProxy(proxy, host)) {
                return null;
            }
            return proxy;
        }
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

