/*
 * Decompiled with CFR 0.152.
 */
package com.github.coveo.ua_parser;

import com.github.coveo.ua_parser.Device;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceParser {
    List<DevicePattern> patterns;

    public DeviceParser(List<DevicePattern> patterns) {
        this.patterns = patterns;
    }

    public Device parse(String agentString) {
        DevicePattern p;
        if (agentString == null) {
            return null;
        }
        String device = null;
        Iterator<DevicePattern> iterator = this.patterns.iterator();
        while (iterator.hasNext() && (device = (p = iterator.next()).match(agentString)) == null) {
        }
        if (device == null) {
            device = "Other";
        }
        return new Device(device);
    }

    public static DeviceParser fromList(List<Map<String, String>> configList) {
        ArrayList<DevicePattern> configPatterns = new ArrayList<DevicePattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(DeviceParser.patternFromMap(configMap));
        }
        return new DeviceParser(configPatterns);
    }

    protected static DevicePattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("Device is missing regex");
        }
        Pattern pattern = "i".equals(configMap.get("regex_flag")) ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        return new DevicePattern(pattern, configMap.get("device_replacement"));
    }

    protected static class DevicePattern {
        private static final Pattern SUBSTITUTIONS_PATTERN = Pattern.compile("\\$\\d");
        private final Pattern pattern;
        private final String deviceReplacement;

        public DevicePattern(Pattern pattern, String deviceReplacement) {
            this.pattern = pattern;
            this.deviceReplacement = deviceReplacement;
        }

        public String match(String agentString) {
            Matcher matcher = this.pattern.matcher(agentString);
            if (!matcher.find()) {
                return null;
            }
            String device = null;
            if (this.deviceReplacement != null) {
                if (this.deviceReplacement.contains("$")) {
                    device = this.deviceReplacement;
                    for (String substitution : this.getSubstitutions(this.deviceReplacement)) {
                        int i = Integer.valueOf(substitution.substring(1));
                        String replacement = matcher.groupCount() >= i && matcher.group(i) != null ? Matcher.quoteReplacement(matcher.group(i)) : "";
                        device = device.replaceFirst("\\" + substitution, replacement);
                    }
                    device = device.trim();
                } else {
                    device = this.deviceReplacement;
                }
            } else if (matcher.groupCount() >= 1) {
                device = matcher.group(1);
            }
            return device;
        }

        private List<String> getSubstitutions(String deviceReplacement) {
            Matcher matcher = SUBSTITUTIONS_PATTERN.matcher(deviceReplacement);
            ArrayList<String> substitutions = new ArrayList<String>();
            while (matcher.find()) {
                substitutions.add(matcher.group());
            }
            return substitutions;
        }
    }
}

