/*
 * Decompiled with CFR 0.152.
 */
package com.github.coveo.ua_parser;

import com.github.coveo.ua_parser.Client;
import com.github.coveo.ua_parser.Device;
import com.github.coveo.ua_parser.OS;
import com.github.coveo.ua_parser.Parser;
import com.github.coveo.ua_parser.UserAgent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class CachingParser
extends Parser {
    private static final int CACHE_SIZE = 1000;
    private Map<String, Client> cacheClient = null;
    private Map<String, UserAgent> cacheUserAgent = null;
    private Map<String, Device> cacheDevice = null;
    private Map<String, OS> cacheOS = null;

    public CachingParser() throws IOException {
    }

    public CachingParser(InputStream regexYaml) {
        super(regexYaml);
    }

    @Override
    public Client parse(String agentString) {
        Client client;
        if (agentString == null) {
            return null;
        }
        if (this.cacheClient == null) {
            this.cacheClient = new LRUMap(1000);
        }
        if ((client = this.cacheClient.get(agentString)) != null) {
            return client;
        }
        client = super.parse(agentString);
        this.cacheClient.put(agentString, client);
        return client;
    }

    @Override
    public UserAgent parseUserAgent(String agentString) {
        UserAgent userAgent;
        if (agentString == null) {
            return null;
        }
        if (this.cacheUserAgent == null) {
            this.cacheUserAgent = new LRUMap(1000);
        }
        if ((userAgent = this.cacheUserAgent.get(agentString)) != null) {
            return userAgent;
        }
        userAgent = super.parseUserAgent(agentString);
        this.cacheUserAgent.put(agentString, userAgent);
        return userAgent;
    }

    @Override
    public Device parseDevice(String agentString) {
        Device device;
        if (agentString == null) {
            return null;
        }
        if (this.cacheDevice == null) {
            this.cacheDevice = new LRUMap(1000);
        }
        if ((device = this.cacheDevice.get(agentString)) != null) {
            return device;
        }
        device = super.parseDevice(agentString);
        this.cacheDevice.put(agentString, device);
        return device;
    }

    @Override
    public OS parseOS(String agentString) {
        OS os;
        if (agentString == null) {
            return null;
        }
        if (this.cacheOS == null) {
            this.cacheOS = new LRUMap(1000);
        }
        if ((os = this.cacheOS.get(agentString)) != null) {
            return os;
        }
        os = super.parseOS(agentString);
        this.cacheOS.put(agentString, os);
        return os;
    }
}

