/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.animation;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.animation.Animation;
import com.bumptech.glide.request.animation.DrawableCrossFadeFactory;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.animation.GlideAnimationFactory;

public abstract class BitmapContainerCrossFadeFactory<T>
implements GlideAnimationFactory<T> {
    private final GlideAnimationFactory<Drawable> realFactory;

    public BitmapContainerCrossFadeFactory() {
        this(new DrawableCrossFadeFactory<Drawable>());
    }

    public BitmapContainerCrossFadeFactory(int duration) {
        this(new DrawableCrossFadeFactory<Drawable>(duration));
    }

    public BitmapContainerCrossFadeFactory(Context context, int defaultAnimationId, int duration) {
        this(new DrawableCrossFadeFactory<Drawable>(context, defaultAnimationId, duration));
    }

    public BitmapContainerCrossFadeFactory(Animation defaultAnimation, int duration) {
        this(new DrawableCrossFadeFactory<Drawable>(defaultAnimation, duration));
    }

    public BitmapContainerCrossFadeFactory(GlideAnimationFactory<Drawable> realFactory) {
        this.realFactory = realFactory;
    }

    @Override
    public GlideAnimation<T> build(boolean isFromMemoryCache, boolean isFirstResource) {
        GlideAnimation<Drawable> transition = this.realFactory.build(isFromMemoryCache, isFirstResource);
        return new BitmapGlideAnimation(transition);
    }

    protected abstract Bitmap getBitmap(T var1);

    private class BitmapGlideAnimation
    implements GlideAnimation<T> {
        private final GlideAnimation<Drawable> transition;

        public BitmapGlideAnimation(GlideAnimation<Drawable> transition) {
            this.transition = transition;
        }

        @Override
        public boolean animate(T current, GlideAnimation.ViewAdapter adapter) {
            Resources resources = adapter.getView().getResources();
            BitmapDrawable currentBitmap = new BitmapDrawable(resources, BitmapContainerCrossFadeFactory.this.getBitmap(current));
            return this.transition.animate((Drawable)currentBitmap, adapter);
        }
    }
}

