/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.UriMatcher;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import com.bumptech.glide.load.data.LocalUriFetcher;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class StreamLocalUriFetcher
extends LocalUriFetcher<InputStream> {
    private static final int ID_LOOKUP = 1;
    private static final int ID_THUMBNAIL = 2;
    private static final int ID_CONTACT = 3;
    private static final int ID_DISPLAY_PHOTO = 4;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);

    public StreamLocalUriFetcher(Context context, Uri uri) {
        super(context, uri);
    }

    @Override
    protected InputStream loadResource(Uri uri, ContentResolver contentResolver) throws FileNotFoundException {
        int matchedUri = URI_MATCHER.match(uri);
        return this.loadResourceFromUri(uri, contentResolver, matchedUri);
    }

    @Override
    protected void close(InputStream data) throws IOException {
        data.close();
    }

    private InputStream loadResourceFromUri(Uri uri, ContentResolver contentResolver, int matchedUri) throws FileNotFoundException {
        switch (matchedUri) {
            case 1: 
            case 3: {
                if (matchedUri == 1 && (uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri)) == null) {
                    throw new FileNotFoundException("Contact cannot be found");
                }
                return this.openContactPhotoInputStream(contentResolver, uri);
            }
        }
        return contentResolver.openInputStream(uri);
    }

    @TargetApi(value=14)
    private InputStream openContactPhotoInputStream(ContentResolver contentResolver, Uri contactUri) {
        if (Build.VERSION.SDK_INT < 14) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)contactUri);
        }
        return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)contactUri, (boolean)true);
    }

    static {
        URI_MATCHER.addURI("com.android.contacts", "contacts/lookup/*/#", 1);
        URI_MATCHER.addURI("com.android.contacts", "contacts/lookup/*", 1);
        URI_MATCHER.addURI("com.android.contacts", "contacts/#/photo", 2);
        URI_MATCHER.addURI("com.android.contacts", "contacts/#", 3);
        URI_MATCHER.addURI("com.android.contacts", "contacts/#/display_photo", 4);
    }
}

