/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifDecoder {
    private static final String TAG = GifDecoder.class.getSimpleName();
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_PARTIAL_DECODE = 3;
    public static final int TOTAL_ITERATION_COUNT_FOREVER = 0;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private int[] act;
    private final int[] pct = new int[256];
    private ByteBuffer rawData;
    private final byte[] block = new byte[256];
    private GifHeaderParser parser;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] mainPixels;
    private int[] mainScratch;
    private int framePointer;
    private byte[] data;
    private GifHeader header;
    private BitmapProvider bitmapProvider;
    private Bitmap previousImage;
    private boolean savePrevious;
    private int status;

    public GifDecoder(BitmapProvider provider) {
        this.bitmapProvider = provider;
        this.header = new GifHeader();
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStatus() {
        return this.status;
    }

    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    public int getDelay(int n) {
        int delay = -1;
        if (n >= 0 && n < this.header.frameCount) {
            delay = this.header.frames.get((int)n).delay;
        }
        return delay;
    }

    public int getNextDelay() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return -1;
        }
        return this.getDelay(this.framePointer);
    }

    public int getFrameCount() {
        return this.header.frameCount;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    @Deprecated
    public int getLoopCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        return this.header.loopCount;
    }

    public int getNetscapeLoopCount() {
        return this.header.loopCount;
    }

    public int getTotalIterationCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        if (this.header.loopCount == 0) {
            return 0;
        }
        return this.header.loopCount + 1;
    }

    public synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer));
            }
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, status=" + this.status));
            }
            return null;
        }
        this.status = 0;
        GifFrame currentFrame = this.header.frames.get(this.framePointer);
        GifFrame previousFrame = null;
        int previousIndex = this.framePointer - 1;
        if (previousIndex >= 0) {
            previousFrame = this.header.frames.get(previousIndex);
        }
        int[] nArray = this.act = currentFrame.lct != null ? currentFrame.lct : this.header.gct;
        if (this.act == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"No Valid Color Table");
            }
            this.status = 1;
            return null;
        }
        if (currentFrame.transparency) {
            System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
            this.act = this.pct;
            this.act[currentFrame.transIndex] = 0;
        }
        return this.setPixels(currentFrame, previousFrame);
    }

    public int read(InputStream is, int contentLength) {
        if (is != null) {
            try {
                int nRead;
                int capacity = contentLength > 0 ? contentLength + 4096 : 16384;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(capacity);
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                this.read(buffer.toByteArray());
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
            }
        } else {
            this.status = 2;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)e);
        }
        return this.status;
    }

    public void clear() {
        this.header = null;
        this.data = null;
        this.mainPixels = null;
        this.mainScratch = null;
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
    }

    public void setData(GifHeader header, byte[] data) {
        this.header = header;
        this.data = data;
        this.status = 0;
        this.framePointer = -1;
        this.rawData = ByteBuffer.wrap(data);
        this.rawData.rewind();
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        for (GifFrame frame : header.frames) {
            if (frame.dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.mainPixels = new byte[header.width * header.height];
        this.mainScratch = new int[header.width * header.height];
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    public int read(byte[] data) {
        this.data = data;
        this.header = this.getHeaderParser().setData(data).parseHeader();
        if (data != null) {
            this.rawData = ByteBuffer.wrap(data);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
            this.mainPixels = new byte[this.header.width * this.header.height];
            this.mainScratch = new int[this.header.width * this.header.height];
            this.savePrevious = false;
            for (GifFrame frame : this.header.frames) {
                if (frame.dispose != 3) continue;
                this.savePrevious = true;
                break;
            }
        }
        return this.status;
    }

    private Bitmap setPixels(GifFrame currentFrame, GifFrame previousFrame) {
        int width = this.header.width;
        int height = this.header.height;
        int[] dest = this.mainScratch;
        if (previousFrame == null) {
            Arrays.fill(dest, 0);
        }
        if (previousFrame != null && previousFrame.dispose > 0) {
            if (previousFrame.dispose == 2) {
                int c = 0;
                if (!currentFrame.transparency) {
                    c = this.header.bgColor;
                    if (currentFrame.lct != null && this.header.bgIndex == currentFrame.transIndex) {
                        c = 0;
                    }
                }
                int topLeft = previousFrame.iy * width + previousFrame.ix;
                int bottomLeft = topLeft + previousFrame.ih * width;
                for (int left = topLeft; left < bottomLeft; left += width) {
                    int right = left + previousFrame.iw;
                    for (int pointer = left; pointer < right; ++pointer) {
                        dest[pointer] = c;
                    }
                }
            } else if (previousFrame.dispose == 3 && this.previousImage != null) {
                this.previousImage.getPixels(dest, 0, width, 0, 0, width, height);
            }
        }
        this.decodeBitmapData(currentFrame);
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < currentFrame.ih; ++i) {
            int line = i;
            if (currentFrame.interlace) {
                if (iline >= currentFrame.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                            break;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += currentFrame.iy) >= this.header.height) continue;
            int k = line * this.header.width;
            int dx = k + currentFrame.ix;
            int dlim = dx + currentFrame.iw;
            if (k + this.header.width < dlim) {
                dlim = k + this.header.width;
            }
            int sx = i * currentFrame.iw;
            while (dx < dlim) {
                int index;
                int c;
                if ((c = this.act[index = this.mainPixels[sx++] & 0xFF]) != 0) {
                    dest[dx] = c;
                }
                ++dx;
            }
        }
        if (this.savePrevious && (currentFrame.dispose == 0 || currentFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            this.previousImage.setPixels(dest, 0, width, 0, 0, width, height);
        }
        Bitmap result = this.getNextBitmap();
        result.setPixels(dest, 0, width, 0, 0, width, height);
        return result;
    }

    private void decodeBitmapData(GifFrame frame) {
        int code;
        int npix;
        if (frame != null) {
            this.rawData.position(frame.bufferFrameStart);
        }
        int n = npix = frame == null ? this.header.width * this.header.height : frame.iw * frame.ih;
        if (this.mainPixels == null || this.mainPixels.length < npix) {
            this.mainPixels = new byte[npix];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int dataSize = this.read();
        int clear = 1 << dataSize;
        int endOfInformation = clear + 1;
        int available = clear + 2;
        int oldCode = -1;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        block1: while (i < npix) {
            if (count == 0) {
                count = this.readBlock();
                if (count <= 0) {
                    this.status = 3;
                    break;
                }
                bi = 0;
            }
            datum += (this.block[bi] & 0xFF) << bits;
            bits += 8;
            ++bi;
            --count;
            while (bits >= codeSize) {
                code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = -1;
                    continue;
                }
                if (code > available) {
                    this.status = 3;
                    continue block1;
                }
                if (code == endOfInformation) continue block1;
                if (oldCode == -1) {
                    this.pixelStack[top++] = this.suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code >= available) {
                    this.pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code >= clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                this.pixelStack[top++] = (byte)first;
                if (available < 4096) {
                    this.prefix[available] = (short)oldCode;
                    this.suffix[available] = (byte)first;
                    if ((++available & codeMask) == 0 && available < 4096) {
                        ++codeSize;
                        codeMask += available;
                    }
                }
                oldCode = inCode;
                while (top > 0) {
                    this.mainPixels[pi++] = this.pixelStack[--top];
                    ++i;
                }
            }
        }
        for (i = pi; i < npix; ++i) {
            this.mainPixels[i] = 0;
        }
    }

    private int read() {
        int curByte = 0;
        try {
            curByte = this.rawData.get() & 0xFF;
        }
        catch (Exception e) {
            this.status = 1;
        }
        return curByte;
    }

    private int readBlock() {
        int n;
        int blockSize = this.read();
        if (blockSize > 0) {
            try {
                int count;
                for (n = 0; n < blockSize; n += count) {
                    count = blockSize - n;
                    this.rawData.get(this.block, n, count);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Error Reading Block", (Throwable)e);
                this.status = 1;
            }
        }
        return n;
    }

    private Bitmap getNextBitmap() {
        Bitmap result = this.bitmapProvider.obtain(this.header.width, this.header.height, BITMAP_CONFIG);
        if (result == null) {
            result = Bitmap.createBitmap((int)this.header.width, (int)this.header.height, (Bitmap.Config)BITMAP_CONFIG);
        }
        GifDecoder.setAlpha(result);
        return result;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(true);
        }
    }

    public static interface BitmapProvider {
        public Bitmap obtain(int var1, int var2, Bitmap.Config var3);

        public void release(Bitmap var1);
    }
}

