/*
 * Decompiled with CFR 0.152.
 */
package com.getperka.flatpack.client.impl;

import com.getperka.flatpack.client.Request;
import com.getperka.flatpack.client.impl.ApiBase;
import com.getperka.flatpack.util.FlatPackCollections;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class RequestBase<R extends Request<R, X>, X>
implements Request<R, X> {
    private static final Pattern pathArgPattern = Pattern.compile("[{][^}]*[}]");
    private final ApiBase api;
    private final Object[] args;
    private Object entity;
    private Map<String, Object> headers = Collections.emptyMap();
    private final String method;
    private final String path;
    private Map<String, Object> queryParams = Collections.emptyMap();

    protected RequestBase(ApiBase api, String method, String path, Object ... args) {
        this.api = api;
        this.args = args;
        this.method = method;
        this.path = path;
    }

    @Override
    public X execute() throws IOException {
        String replacedPath = this.path;
        Matcher m = pathArgPattern.matcher(replacedPath);
        int index = 0;
        while (m.find() && index < this.args.length) {
            replacedPath = m.replaceFirst(this.args[index++].toString());
            m = pathArgPattern.matcher(replacedPath);
        }
        StringBuilder sb = new StringBuilder(replacedPath);
        if (!this.queryParams.isEmpty()) {
            sb.append("?");
            boolean needsAmp = false;
            for (Map.Entry<String, Object> entry : this.queryParams.entrySet()) {
                if (needsAmp) {
                    sb.append("&");
                } else {
                    needsAmp = true;
                }
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(), "UTF8"));
            }
        }
        URI sendTo = this.api.getServerBase().resolve(sb.toString());
        HttpURLConnection conn = (HttpURLConnection)sendTo.toURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod(this.method);
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue().toString());
        }
        conn = this.api.filter(conn);
        this.writeEntity(conn);
        return this.execute(conn);
    }

    public Object getEntity() {
        return this.entity;
    }

    @Override
    public R header(String name, Object value) {
        if (this.headers.isEmpty()) {
            this.headers = FlatPackCollections.mapForIteration();
        }
        this.headers.put(name, value);
        return this.as();
    }

    @Override
    public R queryParameter(String name, Object value) {
        if (this.queryParams.isEmpty()) {
            this.queryParams = FlatPackCollections.mapForIteration();
        }
        this.queryParams.put(name, value);
        return this.as();
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    protected R as() {
        return (R)this;
    }

    protected abstract X execute(HttpURLConnection var1) throws IOException;

    protected ApiBase getApi() {
        return this.api;
    }

    protected boolean isOk(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    protected abstract void writeEntity(HttpURLConnection var1) throws IOException;
}

