/*
 * Decompiled with CFR 0.152.
 */
package com.getperka.flatpack.client.impl;

import com.getperka.flatpack.client.impl.ApiBase;
import com.getperka.flatpack.client.impl.RequestBase;
import com.getperka.flatpack.util.FlatPackTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;

public class JsonRequestBase<R extends JsonRequestBase<R>>
extends RequestBase<R, JsonElement> {
    protected JsonRequestBase(ApiBase api, String method, String path, Object ... args) {
        super(api, method, path, args);
    }

    @Override
    protected JsonElement execute(HttpURLConnection response) throws IOException {
        int statusCode = response.getResponseCode();
        JsonObject toReturn = null;
        try {
            InputStream in = this.isOk(statusCode) ? response.getInputStream() : response.getErrorStream();
            InputStreamReader reader = new InputStreamReader(in, FlatPackTypes.UTF8);
            toReturn = new JsonParser().parse((Reader)reader);
        }
        catch (JsonParseException ignored) {
            toReturn = new JsonObject();
        }
        if (toReturn.isJsonObject()) {
            toReturn.getAsJsonObject().addProperty("status_code", (Number)statusCode);
        }
        return toReturn;
    }

    @Override
    protected void writeEntity(HttpURLConnection connection) throws IOException {
    }
}

